/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairAll
extends BaseCommandPlugin {
    private static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        boolean useSupplies = true;
        if (params.size() >= 1) {
            useSupplies = params.get(0).getBoolean(memoryMap);
        }
        float supplies = playerFleet.getCargo().getSupplies();
        float needed = playerFleet.getLogistics().getTotalRepairAndRecoverySupplyCost();
        if (needed > 0.0f) {
            needed = Math.max(1, Math.round(needed));
        }
        for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeRepaired() && (!member.isFighterWing() || member.getRepairTracker().isSuspendRepairs())) continue;
            member.getStatus().repairFully();
            float max = member.getRepairTracker().getMaxCR();
            float curr = member.getRepairTracker().getBaseCR();
            if (!(max > curr)) continue;
            member.getRepairTracker().applyCREvent(max - curr, "\u5728\u8239\u575e\u4fee\u7406");
        }
        if (needed > 0.0f && useSupplies) {
            playerFleet.getCargo().removeSupplies(needed);
            playerFleet.getLogistics().updateRepairUtilizationForUI();
        }
        return true;
    }

    private String getString(String id) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        String str = Global.getSettings().getString("stationInteractionDialog", id);
        float needed = playerFleet.getLogistics().getTotalRepairAndRecoverySupplyCost();
        float supplies = playerFleet.getCargo().getSupplies();
        str = str.replaceAll("\\$supplies", "" + (int)supplies);
        str = str.replaceAll("\\$repairSupplyCost", "" + (int)Math.ceil(needed));
        return str;
    }
}

