/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseStoryPointActionDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.StoryPointActionDelegate;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStoryOption
extends BaseCommandPlugin {
    public static boolean set(String ruleId, InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap, String params) {
        return new SetStoryOption().execute(ruleId, dialog, Misc.tokenize(params), memoryMap);
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        String optionId = "";
        String bonusXPID = "";
        String soundId = "";
        String logText = null;
        int numPoints = 1;
        if (params.size() == 3) {
            optionId = params.get((int)0).string;
            numPoints = 1;
            bonusXPID = optionId;
            soundId = params.get((int)1).string;
            logText = params.get(2).getStringWithTokenReplacement(params.get(2).getString(memoryMap), dialog, memoryMap);
        } else {
            optionId = params.get((int)0).string;
            numPoints = (int)params.get(1).getFloat(memoryMap);
            bonusXPID = params.get(2).getString(memoryMap);
            String string = soundId = params.size() >= 4 ? params.get((int)3).string : null;
            if (params.size() >= 5) {
                logText = params.get(4).getStringWithTokenReplacement(params.get(4).getString(memoryMap), dialog, memoryMap);
            }
        }
        return SetStoryOption.set(dialog, numPoints, optionId, bonusXPID, soundId, logText);
    }

    public static boolean set(InteractionDialogAPI dialog, int numPoints, Object optionId, String bonusXPID, String soundId, String logText) {
        StoryOptionParams params = new StoryOptionParams(optionId, numPoints, bonusXPID, soundId, logText);
        return SetStoryOption.set(dialog, params, new BaseOptionStoryPointActionDelegate(dialog, params));
    }

    public static boolean set(InteractionDialogAPI dialog, final StoryOptionParams params, StoryPointActionDelegate delegate) {
        final float bonusXPFraction = Global.getSettings().getBonusXP(params.bonusXPID);
        dialog.makeStoryOption(params.optionId, params.numPoints, bonusXPFraction, params.soundId);
        if (params.numPoints > Global.getSector().getPlayerStats().getStoryPoints()) {
            dialog.getOptionPanel().setEnabled(params.optionId, false);
        }
        dialog.getOptionPanel().addOptionTooltipAppender(params.optionId, new OptionPanelAPI.OptionTooltipCreator(){

            public void createTooltip(TooltipMakerAPI tooltip, boolean hadOtherText) {
                float opad = 10.0f;
                float initPad = 0.0f;
                if (hadOtherText) {
                    initPad = opad;
                }
                tooltip.addStoryPointUseInfo(initPad, params.numPoints, bonusXPFraction, true);
                int sp = Global.getSector().getPlayerStats().getStoryPoints();
                String \u70b9 = "\u70b9";
                if (sp == 1) {
                    \u70b9 = "\u70b9";
                }
                tooltip.addPara("\u4f60\u62e5\u6709 %s \u4e2a " + Misc.STORY + " " + \u70b9 + ".", opad, Misc.getStoryOptionColor(), "" + sp);
            }
        });
        dialog.getOptionPanel().addOptionConfirmation(params.optionId, delegate);
        dialog.getOptionPanel().setStoryOptionParams(params.optionId, params, delegate);
        return true;
    }

    public static class BaseOptionStoryPointActionDelegate
    extends BaseStoryPointActionDelegate {
        protected Object optionId;
        protected float bonusXPFraction;
        protected InteractionDialogAPI dialog;
        protected int numPoints;
        protected String soundId;
        protected String logText;

        public BaseOptionStoryPointActionDelegate(InteractionDialogAPI dialog, StoryOptionParams params) {
            this.optionId = params.optionId;
            this.bonusXPFraction = Global.getSettings().getBonusXP(params.bonusXPID);
            this.dialog = dialog;
            this.numPoints = params.numPoints;
            this.soundId = params.soundId;
            this.logText = params.logText;
        }

        public void preConfirm() {
            if (this.dialog != null) {
                this.dialog.addOptionSelectedText(this.optionId, true);
            }
        }

        public void confirm() {
        }

        public void createDescription(TooltipMakerAPI info) {
            info.setParaInsigniaLarge();
            this.addActionCostSection(info);
            info.addSpacer(20.0f);
        }

        protected void addActionCostSection(TooltipMakerAPI info) {
            int sp = Global.getSector().getPlayerStats().getStoryPoints();
            float pad = -10.0f;
            float opad = 10.0f;
            int percent = Math.round(this.bonusXPFraction * 100.0f);
            if (this.numPoints == 1) {
                if (percent <= 0) {
                    info.addPara("\u8be5\u6289\u62e9\u9700\u8981 %s, \u5e76\u4e14\u4e0d\u7ed9\u4e88\u4efb\u4f55\u989d\u5916\u7ecf\u9a8c\u3002", pad, Misc.getStoryOptionColor(), Misc.STORY + "\u70b9");
                } else {
                    info.addPara("\u8be5\u6289\u62e9\u9700\u8981 %s, \u4e14\u6bcf\u70b9\u7ed9\u4e88 %s \u989d\u5916\u7ecf\u9a8c\u3002", pad, Misc.getStoryOptionColor(), Misc.STORY + "\u70b9", percent + "%");
                }
            } else if (percent <= 0) {
                info.addPara("\u8be5\u6289\u62e9\u9700\u8981 %s, \u5e76\u4e14\u4e0d\u7ed9\u4e88\u4efb\u4f55\u989d\u5916\u7ecf\u9a8c\u3002", pad, Misc.getStoryOptionColor(), this.numPoints + " " + Misc.STORY + "\u70b9");
            } else {
                info.addPara("\u8be5\u6289\u62e9\u9700\u8981 %s, \u4e14\u6bcf\u70b9\u7ed9\u4e88 %s \u989d\u5916\u7ecf\u9a8c\u3002", pad, Misc.getStoryOptionColor(), this.numPoints + " " + Misc.STORY + "\u70b9", percent + "%");
            }
            if (sp <= 0) {
                info.addPara("\u6ca1\u6709\u53ef\u7528\u7684" + Misc.STORY + "\u70b9", Misc.getNegativeHighlightColor(), opad);
            } else if (sp < this.numPoints) {
                String \u70b9 = "\u70b9";
                if (sp == 1) {
                    \u70b9 = "\u70b9";
                }
                info.addPara("\u4f60\u53ea\u6709 %s \u4e2a" + Misc.STORY + " " + \u70b9 + "\u53ef\u7528", opad, Misc.getNegativeHighlightColor(), Misc.getNegativeHighlightColor(), "" + sp);
            }
        }

        public float getBonusXPFraction() {
            return this.bonusXPFraction;
        }

        public String getConfirmSoundId() {
            String soundId = this.soundId;
            if ("leadership".equals(soundId)) {
                soundId = "ui_char_spent_story_point_leadership";
            }
            if ("combat".equals(soundId)) {
                soundId = "ui_char_spent_story_point_combat";
            }
            if ("industry".equals(soundId)) {
                soundId = "ui_char_spent_story_point_industry";
            }
            if ("technology".equals(soundId)) {
                soundId = "ui_char_spent_story_point_technology";
            }
            if ("general".equals(soundId)) {
                soundId = "ui_char_spent_story_point_combat";
            }
            if ("generic".equals(soundId)) {
                soundId = "ui_char_spent_story_point_combat";
            }
            return soundId;
        }

        public int getRequiredStoryPoints() {
            return this.numPoints;
        }

        public String getLogText() {
            return this.logText;
        }

        public TextPanelAPI getTextPanel() {
            if (this.dialog == null) {
                return null;
            }
            return this.dialog.getTextPanel();
        }

        public String getTitle() {
            return null;
        }

        public boolean withSPInfo() {
            return false;
        }
    }

    public static class StoryOptionParams {
        public Object optionId;
        public int numPoints;
        public String bonusXPID;
        public String soundId;
        public String logText;

        public StoryOptionParams(Object optionId, int numPoints, String bonusXPID, String soundId, String logText) {
            this.optionId = optionId;
            this.numPoints = numPoints;
            this.bonusXPID = bonusXPID;
            this.soundId = soundId;
            this.logText = logText;
        }
    }
}

