/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.missions;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.ImportantPeopleAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.DevMenuOptions;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.intel.bar.BarEventDialogPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarData;
import com.fs.starfarer.api.impl.campaign.intel.bar.PortsideBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BarEventManager;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionBarEventWrapper;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.DumpMemory;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.AddBarEvent;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialMissionIntel;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarCMD
extends BaseCommandPlugin
implements InteractionDialogPlugin {
    public static float BAR_EVENT_MIN_TIME_BEFORE_CHANGING = 20.0f;
    public static float BAR_EVENT_MAX_TIME_BEFORE_CHANGING = 40.0f;
    protected SectorEntityToken entity;
    protected InteractionDialogPlugin originalPlugin;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        if (dialog == null) {
            return false;
        }
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        if (command.equals("returnFromEvent")) {
            MemoryAPI mem = BarCMD.getEntityMemory(memoryMap);
            BarCMD cmd = (BarCMD)mem.get("$BarCMD");
            mem.unset("$BarCMD");
            dialog.setPlugin(cmd);
            this.abortMissions(null);
            dialog.getInteractionTarget().setActivePerson(null);
            ((RuleBasedInteractionDialogPluginImpl)cmd.originalPlugin).updateMemory();
            boolean withContinue = params.size() > 1 && params.get(1).getBoolean(memoryMap);
            cmd.returningFromEvent(withContinue);
            return true;
        }
        if (command.equals("accept")) {
            String missionId = params.get(1).getString(memoryMap);
            HubMissionBarEventWrapper w = this.getWrapperFor(missionId);
            if (w != null && w.getMission() != null) {
                BarEventManager.getInstance().notifyWasInteractedWith(w);
                w.getMission().accept(dialog, memoryMap);
            }
            return true;
        }
        if (command.equals("leaveBar")) {
            this.leaveBar();
            return true;
        }
        if (command.equals("playAmbience")) {
            this.entity = dialog.getInteractionTarget();
            if (!Global.getSector().hasTransientScript(BarAmbiencePlayer.class)) {
                Global.getSector().addTransientScript(new BarAmbiencePlayer(this.entity.getMarket()));
            }
            return true;
        }
        this.entity = dialog.getInteractionTarget();
        this.originalPlugin = dialog.getPlugin();
        if (command.equals("showOptions")) {
            this.showOptions(false);
            if (!Global.getSector().hasTransientScript(BarAmbiencePlayer.class)) {
                Global.getSector().addTransientScript(new BarAmbiencePlayer(this.entity.getMarket()));
            }
        }
        return true;
    }

    public void showOptions(boolean returningFromEvent) {
        this.dialog.getVisualPanel().restoreSavedVisual();
        this.dialog.getVisualPanel().saveCurrentVisual();
        PortsideBarData data = PortsideBarData.getInstance();
        MarketAPI market = this.entity.getMarket();
        this.dialog.getOptionPanel().clearOptions();
        Random random = new Random(BarEventManager.getInstance().getSeed(this.entity, null, null));
        int min = Global.getSettings().getInt("minBarEvents");
        int max = Global.getSettings().getInt("maxBarEvents");
        float pMult = Global.getSettings().getFloat("barEventProbOneMore");
        WeightedRandomPicker<Integer> numPicker = new WeightedRandomPicker<Integer>(random);
        float p = 1.0f;
        int i = min;
        while (i <= max) {
            numPicker.add(i, p);
            p *= pMult;
            ++i;
        }
        int num = (Integer)numPicker.pick();
        if (DebugFlags.BAR_DEBUG) {
            max = 8;
            num = 7;
        }
        ArrayList<PortsideBarEvent> events = new ArrayList<PortsideBarEvent>();
        String key = "$BarCMD_shownEvents";
        MemoryAPI mem = market.getMemoryWithoutUpdate();
        boolean needToSaveShown = false;
        if (mem.contains(key)) {
            List eventIds = (List)mem.get(key);
            for (String id : eventIds) {
                for (PortsideBarEvent event : data.getEvents()) {
                    if (!id.equals(event.getBarEventId())) continue;
                    events.add(event);
                }
            }
            num = Math.max(eventIds.size(), num);
        } else {
            events.addAll(data.getEvents());
            Collections.shuffle(events, random);
            needToSaveShown = true;
        }
        boolean addedSomething = false;
        AddBarEvent.clearTempEvents(market);
        FireAll.fire(null, this.dialog, this.memoryMap, "AddBarEvents");
        ArrayList<AddBarEvent.BarEventData> temp = new ArrayList<AddBarEvent.BarEventData>(AddBarEvent.getTempEvents((MarketAPI)market).events.values());
        int i2 = 0;
        while (i2 < max && i2 < temp.size()) {
            AddBarEvent.BarEventData b = (AddBarEvent.BarEventData)temp.get(i2);
            if (!b.blurb.isEmpty()) {
                this.dialog.getTextPanel().addPara(b.blurb);
            }
            this.dialog.getOptionPanel().addOption(b.option, b.optionId);
            if (b.optionColor != null) {
                this.dialog.setOptionColor(b.optionId, b.optionColor);
            }
            addedSomething = true;
            ++i2;
        }
        ArrayList<String> shown = new ArrayList<String>();
        ImportantPeopleAPI ip = Global.getSector().getImportantPeople();
        ip.resetExcludeFromGetPerson();
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(ContactIntel.class)) {
            ip.excludeFromGetPerson(((ContactIntel)intel).getPerson());
        }
        Collections.sort(events, new Comparator<PortsideBarEvent>(){

            @Override
            public int compare(PortsideBarEvent o1, PortsideBarEvent o2) {
                boolean p1 = o1.isAlwaysShow();
                boolean p2 = o2.isAlwaysShow();
                if (p1 && !p2) {
                    return -1;
                }
                if (p2 && !p1) {
                    return 1;
                }
                return 0;
            }
        });
        int curr = 0;
        for (PortsideBarEvent event : events) {
            HubMissionBarEventWrapper w;
            if (TutorialMissionIntel.isTutorialInProgress()) continue;
            if (curr + temp.size() >= max) break;
            if (event.shouldRemoveEvent() || !event.shouldShowAtMarket(market)) continue;
            event.addPromptAndOption(this.dialog, this.memoryMap);
            if (event instanceof HubMissionBarEventWrapper && (w = (HubMissionBarEventWrapper)event).getMission() == null) continue;
            event.wasShownAtMarket(market);
            if (event.getBarEventId() != null) {
                shown.add(event.getBarEventId());
            }
            addedSomething = true;
            if (!event.isAlwaysShow()) {
                ++curr;
            }
            if (curr >= num) break;
        }
        ip.resetExcludeFromGetPerson();
        if (needToSaveShown) {
            float time = BAR_EVENT_MIN_TIME_BEFORE_CHANGING + (BAR_EVENT_MAX_TIME_BEFORE_CHANGING - BAR_EVENT_MIN_TIME_BEFORE_CHANGING) * random.nextFloat();
            mem.set(key, shown, time);
        }
        if (returningFromEvent) {
            if (!addedSomething) {
                this.dialog.getTextPanel().addPara("\u9152\u5427\u91cc\u5e76\u6ca1\u6709\u4ec0\u4e48\u503c\u5f97\u6ce8\u610f\u7684\u4e8b\u3002");
            } else {
                this.dialog.getTextPanel().addPara("\u5728\u51b3\u5b9a\u4e0b\u4e00\u6b65\u8be5\u505a\u4ec0\u4e48\u4e4b\u524d\uff0c\u4f60\u82b1\u4e86\u6570\u5206\u949f\u6084\u6084\u7684\u89c2\u5bdf\u7740\u9152\u5427\u5185\u7684\u987e\u5ba2\u3002");
            }
        }
        this.dialog.getOptionPanel().addOption("\u79bb\u5f00\u9152\u5427", "barLeave");
        this.dialog.getOptionPanel().setShortcut("barLeave", 1, false, false, false, true);
        if (Global.getSettings().isDevMode()) {
            DevMenuOptions.addOptions(this.dialog);
        }
        this.dialog.setPlugin(this);
        this.init(this.dialog);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        if (optionText != null) {
            this.dialog.addOptionSelectedText(optionData);
        }
        if (optionData == "DumpMemory.option_dump_memory") {
            new DumpMemory().execute(null, this.dialog, null, this.getMemoryMap());
            return;
        }
        if (DevMenuOptions.isDevOption(optionData)) {
            DevMenuOptions.execute(this.dialog, (String)optionData);
            return;
        }
        String optionId = null;
        if (optionData instanceof String) {
            optionId = (String)optionData;
        }
        this.abortMissions(optionId);
        if (optionData instanceof PortsideBarEvent) {
            PortsideBarEvent event = (PortsideBarEvent)optionData;
            BarEventDialogPlugin plugin = new BarEventDialogPlugin(this, this, event, this.memoryMap);
            this.dialog.setPlugin(plugin);
            plugin.init(this.dialog);
            return;
        }
        if ("barLeave".equals(optionData)) {
            this.leaveBar();
        } else if ("barContinue".equals(optionData)) {
            this.showOptions(true);
        } else if (optionData instanceof String) {
            PersonAPI person;
            MemoryAPI eMem = BarCMD.getEntityMemory(this.memoryMap);
            eMem.set("$BarCMD", this, 0.0f);
            HubMissionBarEventWrapper w = this.getWrapperFor(optionId);
            if (w != null && w.getMission() != null && (person = w.getMission().getPerson()) != null) {
                this.dialog.getInteractionTarget().setActivePerson(person);
                ((RuleBasedInteractionDialogPluginImpl)this.originalPlugin).updateMemory();
                this.dialog.getVisualPanel().showPersonInfo(person, true);
            }
            MemoryAPI mem = this.memoryMap.get("local");
            this.dialog.setPlugin(this.originalPlugin);
            mem.set("$option", (String)optionData, 0.0f);
            FireBest.fire(null, this.dialog, this.memoryMap, "DialogOptionSelected");
        }
    }

    public void returningFromEvent(PortsideBarEvent event) {
        this.returningFromEvent(event.endWithContinue());
    }

    public void returningFromEvent(boolean withContinue) {
        if (withContinue) {
            this.dialog.getOptionPanel().clearOptions();
            this.dialog.getOptionPanel().addOption("\u7ee7\u7eed", "barContinue");
        } else {
            this.showOptions(true);
        }
    }

    public HubMissionBarEventWrapper getWrapperFor(String optionId) {
        PortsideBarData data = PortsideBarData.getInstance();
        for (PortsideBarEvent event : data.getEvents()) {
            HubMissionBarEventWrapper w;
            if (!(event instanceof HubMissionBarEventWrapper) || (w = (HubMissionBarEventWrapper)event).getMission() == null || optionId == null || !optionId.startsWith(w.getMission().getTriggerPrefix())) continue;
            return w;
        }
        return null;
    }

    public void abortMissions(String optionId) {
        PortsideBarData data = PortsideBarData.getInstance();
        for (PortsideBarEvent event : data.getEvents()) {
            HubMissionBarEventWrapper w;
            if (!(event instanceof HubMissionBarEventWrapper) || (w = (HubMissionBarEventWrapper)event).getMission() == null || optionId != null && optionId.startsWith(w.getMission().getTriggerPrefix())) continue;
            w.abortMission();
        }
    }

    public static BarAmbiencePlayer getAmbiencePlayer() {
        for (EveryFrameScript script : Global.getSector().getTransientScripts()) {
            if (!(script instanceof BarAmbiencePlayer)) continue;
            return (BarAmbiencePlayer)script;
        }
        return null;
    }

    public void leaveBar() {
        BarAmbiencePlayer player = BarCMD.getAmbiencePlayer();
        if (player != null) {
            player.stop();
        }
        if (this.originalPlugin != null) {
            this.dialog.setPlugin(this.originalPlugin);
        }
        new ShowDefaultVisual().execute(null, this.dialog, Misc.tokenize(""), this.memoryMap);
        FireBest.fire(null, this.dialog, this.memoryMap, "ReturnFromBar");
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public void backFromEngagement(EngagementResultAPI battleResult) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return this.memoryMap;
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void init(InteractionDialogAPI dialog) {
    }

    public static class BarAmbiencePlayer
    implements EveryFrameScript {
        public MarketAPI market;
        public String soundId = "bar_ambience";
        public float pitch = 1.0f;
        public float volume = 1.0f;
        public float musicSuppression = 0.95f;
        public boolean done = false;
        public FaderUtil fader = new FaderUtil(0.0f, 0.5f);

        public BarAmbiencePlayer(MarketAPI market) {
            this.market = market;
            if (market.getFaction() != null) {
                this.soundId = market.getFaction().getBarSound();
            }
            this.fader.fadeIn();
        }

        public void advance(float amount) {
            this.fader.advance(amount);
            Global.getSector().getCampaignUI().suppressMusic(this.fader.getBrightness() * this.musicSuppression);
            Global.getSoundPlayer().playUILoop(this.soundId, this.pitch, this.volume * this.fader.getBrightness());
            if (!Global.getSector().isPaused()) {
                this.stop();
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return true;
        }

        public void stop() {
            this.done = true;
        }
    }
}

