/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.FactionCommissionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Commission
extends BaseCommandPlugin {
    public static RepLevel COMMISSION_REQ = RepLevel.FAVORABLE;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected PersonAPI person;
    protected FactionAPI faction;
    protected boolean offersCommissions;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = Commission.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.person = dialog.getInteractionTarget().getActivePerson();
        this.faction = this.person.getFaction();
        this.offersCommissions = this.faction.getCustomBoolean("offersCommissions");
        if (command.equals("printRequirements")) {
            this.printRequirements();
        } else {
            if (command.equals("playerMeetsCriteria")) {
                return this.playerMeetsCriteria();
            }
            if (command.equals("printInfo")) {
                this.printInfo();
            } else {
                if (command.equals("hasFactionCommission")) {
                    return this.hasFactionCommission();
                }
                if (command.equals("hasOtherCommission")) {
                    if (this.hasOtherCommission()) {
                        this.memory.set("$theOtherCommissionFaction", Misc.getCommissionFaction().getDisplayNameWithArticle(), 0.0f);
                        this.memory.set("$otherCommissionFaction", Misc.getCommissionFaction().getPersonNamePrefix(), 0.0f);
                        return true;
                    }
                    return false;
                }
                if (command.equals("accept")) {
                    this.accept();
                } else if (command.equals("resign")) {
                    this.resign(true);
                } else if (command.equals("resignNoPenalty")) {
                    this.resign(false);
                } else {
                    if (command.equals("personCanGiveCommission")) {
                        return this.personCanGiveCommission();
                    }
                    if (command.equals("commissionFactionIsAtWarWith")) {
                        if (this.hasOtherCommission() && params.size() >= 1) {
                            String target_faction_id = params.get(0).getString(memoryMap);
                            FactionAPI target_faction = Global.getSector().getFaction(target_faction_id);
                            if (target_faction != null) {
                                return Misc.getCommissionFaction().isHostileTo(target_faction);
                            }
                        }
                        return false;
                    }
                    if (command.equals("isCargoPodsScam")) {
                        MarketAPI market = dialog.getInteractionTarget().getMarket();
                        if (market == null) {
                            return false;
                        }
                        for (SectorEntityToken entity : market.getContainingLocation().getAllEntities()) {
                            float dist;
                            if (!"cargo_pods".equals(entity.getCustomEntityType()) || !((dist = Misc.getDistance(entity.getLocation(), this.playerFleet.getLocation())) < 500.0f) || !(entity.getCargo().getSupplies() >= 10.0f)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (command.equals("recalcFreeSupplyDaysRemaining")) {
                        Object obj1 = this.person.getFaction().getMemoryWithoutUpdate().get("$playerReceivedCommissionResupplyOn");
                        Object obj2 = Global.getSector().getMemoryWithoutUpdate().get("$daysSinceStart");
                        if (obj1 == null) {
                            return false;
                        }
                        if (obj2 == null) {
                            return false;
                        }
                        float d1 = ((Float)obj1).floatValue();
                        float d2 = ((Float)obj2).floatValue();
                        this.faction.getMemoryWithoutUpdate().set("$daysLeft", (int)d1 + 365 - (int)d2, 0.0f);
                    } else if (command.equals("doesPlayerFleetNeedRepairs")) {
                        float fleetCRcurrent = 0.0f;
                        float fleetCRmax = 0.0f;
                        float fleetHullDamage = 0.0f;
                        for (FleetMemberAPI member : this.playerFleet.getMembersWithFightersCopy()) {
                            if (member.isFighterWing()) continue;
                            fleetHullDamage += 1.0f - member.getStatus().getHullFraction();
                            fleetCRcurrent += member.getRepairTracker().getCR();
                            fleetCRmax += member.getRepairTracker().getMaxCR();
                        }
                        boolean needsSupplies = false;
                        if ((double)fleetHullDamage > 0.5) {
                            needsSupplies = true;
                            Global.getSector().getPlayerMemoryWithoutUpdate().set("$fleetDamaged", true, 0.0f);
                        }
                        if ((double)fleetHullDamage > 2.5) {
                            needsSupplies = true;
                            Global.getSector().getPlayerMemoryWithoutUpdate().set("$fleetDamagedLots", true, 0.0f);
                        }
                        if (fleetCRcurrent == 0.0f || fleetCRcurrent / fleetCRmax < 0.6f) {
                            needsSupplies = true;
                            Global.getSector().getPlayerMemoryWithoutUpdate().set("$fleetLowCR", true, 0.0f);
                        }
                        return needsSupplies;
                    }
                }
            }
        }
        return true;
    }

    protected boolean hasFactionCommission() {
        return this.faction.getId().equals(Misc.getCommissionFactionId());
    }

    protected boolean hasOtherCommission() {
        return Misc.getCommissionFactionId() != null && !this.hasFactionCommission();
    }

    protected boolean personCanGiveCommission() {
        if (this.person == null || !this.offersCommissions) {
            return false;
        }
        if (this.person.getFaction().isPlayerFaction()) {
            return false;
        }
        return Ranks.POST_BASE_COMMANDER.equals(this.person.getPostId()) || Ranks.POST_STATION_COMMANDER.equals(this.person.getPostId()) || Ranks.POST_ADMINISTRATOR.equals(this.person.getPostId()) || Ranks.POST_OUTPOST_COMMANDER.equals(this.person.getPostId());
    }

    protected void resign(boolean withPenalty) {
        FactionCommissionIntel intel = Misc.getCommissionIntel();
        if (intel != null) {
            BaseMissionIntel.MissionResult result = intel.createResignedCommissionResult(withPenalty, true, this.dialog);
            intel.setMissionResult(result);
            intel.setMissionState(BaseMissionIntel.MissionState.ABANDONED);
            intel.endMission(this.dialog);
        }
    }

    protected void accept() {
        if (Misc.getCommissionFactionId() == null) {
            FactionCommissionIntel intel = new FactionCommissionIntel(this.faction);
            intel.missionAccepted();
            intel.sendUpdate(FactionCommissionIntel.UPDATE_PARAM_ACCEPTED, this.dialog.getTextPanel());
            intel.makeRepChanges(this.dialog);
        }
    }

    protected void printInfo() {
        TooltipMakerAPI info = this.dialog.getTextPanel().beginTooltip();
        FactionCommissionIntel temp = new FactionCommissionIntel(this.faction);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.setParaSmallInsignia();
        int stipend = (int)temp.computeStipend();
        info.addPara("\u4ee5\u4f60\u76ee\u524d\u7684\u7b49\u7ea7\uff0c\u4e0d\u4ec5\u4f1a\u83b7\u5f97 %s \u7684\u6bcf\u6708\u6d25\u8d34\uff0c\u8fd8\u4f1a\u5728\u6467\u6bc1\u654c\u8230\u540e \u83b7\u5f97\u9002\u5f53\u7684\u8d4f\u91d1\u3002", 0.0f, h, Misc.getDGSCredits(stipend));
        List<FactionAPI> hostile = temp.getHostileFactions();
        if (hostile.isEmpty()) {
            info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " \u76ee\u524d\u6ca1\u6709\u4efb\u4f55\u654c\u5bf9\u52bf\u529b", 0.0f);
        } else {
            info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " \u76ee\u524d\u7684\u654c\u4eba\u662f\uff1a", opad);
            info.setParaFontDefault();
            info.setBulletedListMode("      ");
            float initPad = opad;
            for (FactionAPI other : hostile) {
                info.addPara(Misc.ucFirst(other.getDisplayName()), other.getBaseUIColor(), initPad);
                initPad = 3.0f;
            }
            info.setBulletedListMode(null);
        }
        this.dialog.getTextPanel().addTooltip();
    }

    protected boolean playerMeetsCriteria() {
        return this.faction.getRelToPlayer().isAtWorst(COMMISSION_REQ);
    }

    protected void printRequirements() {
        CoreReputationPlugin.addRequiredStanding(this.entityFaction, COMMISSION_REQ, null, this.dialog.getTextPanel(), null, null, 0.0f, true);
        CoreReputationPlugin.addCurrentStanding(this.entityFaction, null, this.dialog.getTextPanel(), null, null, 0.0f);
    }
}

