/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.DeliveryMissionIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryMission
extends BaseCommandPlugin {
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected MarketAPI market;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected FactionAPI faction;

    protected void init(SectorEntityToken entity) {
        this.memory = entity.getMemoryWithoutUpdate();
        this.entity = entity;
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = entity.getFaction();
        this.faction = entity.getFaction();
        this.market = entity.getMarket();
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.entity = dialog.getInteractionTarget();
        this.init(this.entity);
        this.memory = DeliveryMission.getEntityMemory(memoryMap);
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        if (command.equals("completeMissions")) {
            this.completeMissions();
        } else if (command.equals("checkCompletion")) {
            return this.checkCompletion();
        }
        return true;
    }

    protected boolean checkCompletion() {
        for (IntelInfoPlugin temp : Global.getSector().getIntelManager().getIntel(DeliveryMissionIntel.class)) {
            MarketAPI dest;
            DeliveryMissionIntel intel = (DeliveryMissionIntel)temp;
            if (!intel.isAccepted() || intel.isEnding() || (dest = intel.getDestination()) != this.market || !intel.hasEnough()) continue;
            return true;
        }
        return false;
    }

    protected void completeMissions() {
        this.dialog.getTextPanel().addPara("\u4f60\u4e0e\u6536\u8d27\u65b9\u53d6\u5f97\u4e86\u8054\u7cfb\uff0c\u5e76\u5728\u5546\u5b9a\u7684\u6e2f\u53e3\u90a3\u5378\u8d27\u5b8c\u6bd5\u3002");
        for (IntelInfoPlugin temp : Global.getSector().getIntelManager().getIntel(DeliveryMissionIntel.class)) {
            MarketAPI dest;
            DeliveryMissionIntel intel = (DeliveryMissionIntel)temp;
            if (!intel.isAccepted() || intel.isEnding() || (dest = intel.getDestination()) != this.market || !intel.hasEnough()) continue;
            intel.performDelivery(this.dialog);
        }
        this.options.clearOptions();
        this.options.addOption("\u7ee7\u7eed", MarketCMD.DEBT_RESULT_CONTINUE);
    }
}

