/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEntityPickerListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.GateEntityPlugin;
import com.fs.starfarer.api.impl.campaign.GateExplosionScript;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateCMD
extends BaseCommandPlugin {
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = GateCMD.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        if (command.equals("selectDestination")) {
            this.selectDestination();
        } else if (command.equals("notifyScanned")) {
            GateCMD.notifyScanned(this.entity);
        } else if (command.equals("explode")) {
            GateCMD.explode(this.entity);
        } else if (command.equals("isPopulated")) {
            return GateCMD.isPopulated(this.entity);
        }
        return true;
    }

    public static boolean isPopulated(SectorEntityToken targetGate) {
        if (targetGate.getContainingLocation() == null) {
            return false;
        }
        LocationAPI loc = targetGate.getContainingLocation();
        if (loc.hasTag("theme_core_populated")) {
            return true;
        }
        return !Misc.getMarketsInLocation(loc).isEmpty();
    }

    public static int computeFuelCost(SectorEntityToken targetGate) {
        float dist = Misc.getDistanceToPlayerLY(targetGate);
        float fuelPerLY = Global.getSector().getPlayerFleet().getLogistics().getFuelCostPerLightYear();
        return (int)Math.ceil(dist * fuelPerLY * Misc.GATE_FUEL_COST_MULT);
    }

    protected void selectDestination() {
        ArrayList<SectorEntityToken> gates = new ArrayList<SectorEntityToken>(GateEntityPlugin.getGateData().scanned);
        gates.remove(this.entity);
        this.dialog.showCampaignEntityPicker("\u9009\u62e9\u76ee\u7684\u5730", "\u76ee\u7684\u5730\uff1a", "\u5f00\u59cb\u4f20\u9001", Global.getSector().getPlayerFaction(), gates, new BaseCampaignEntityPickerListener(){

            public void pickedEntity(SectorEntityToken entity) {
                GateEntityPlugin plugin;
                int cost = GateCMD.computeFuelCost(entity);
                Global.getSector().getPlayerFleet().getCargo().removeFuel(cost);
                GateCMD.this.dialog.dismiss();
                Global.getSector().setPaused(false);
                JumpPointAPI.JumpDestination dest = new JumpPointAPI.JumpDestination(entity, null);
                Global.getSector().doHyperspaceTransition(GateCMD.this.playerFleet, GateCMD.this.entity, dest, 2.0f);
                float distLY = Misc.getDistanceLY(entity, GateCMD.this.entity);
                if (entity.getCustomPlugin() instanceof GateEntityPlugin) {
                    plugin = (GateEntityPlugin)entity.getCustomPlugin();
                    plugin.showBeingUsed(distLY);
                }
                if (GateCMD.this.entity.getCustomPlugin() instanceof GateEntityPlugin) {
                    plugin = (GateEntityPlugin)GateCMD.this.entity.getCustomPlugin();
                    plugin.showBeingUsed(distLY);
                }
                ListenerUtil.reportFleetTransitingGate(Global.getSector().getPlayerFleet(), GateCMD.this.entity, entity);
            }

            public void cancelledEntityPicking() {
            }

            public String getMenuItemNameOverrideFor(SectorEntityToken entity) {
                return null;
            }

            public String getSelectedTextOverrideFor(SectorEntityToken entity) {
                return String.valueOf(entity.getName()) + " - " + entity.getContainingLocation().getNameWithTypeShort();
            }

            public void createInfoText(TooltipMakerAPI info, SectorEntityToken entity) {
                int cost = GateCMD.computeFuelCost(entity);
                int available = (int)Global.getSector().getPlayerFleet().getCargo().getFuel();
                Color reqColor = Misc.getHighlightColor();
                Color availableColor = Misc.getHighlightColor();
                if (cost > available) {
                    reqColor = Misc.getNegativeHighlightColor();
                }
                info.setParaSmallInsignia();
                info.beginGrid(200.0f, 2, Misc.getGrayColor());
                info.setGridFontSmallInsignia();
                info.addToGrid(0, 0, "    Fuel required:", Misc.getWithDGS(cost), reqColor);
                info.addToGrid(1, 0, "    Fuel available:", Misc.getWithDGS(available), availableColor);
                info.addGrid(0.0f);
            }

            public boolean canConfirmSelection(SectorEntityToken entity) {
                int available;
                int cost = GateCMD.computeFuelCost(entity);
                return cost <= (available = (int)Global.getSector().getPlayerFleet().getCargo().getFuel());
            }

            public float getFuelColorAlphaMult() {
                return 0.5f;
            }

            public float getFuelRangeMult() {
                return 0.0f;
            }
        });
    }

    public static void notifyScanned(SectorEntityToken gate) {
        GateEntityPlugin.getGateData().scanned.add(gate);
        gate.getCustomPlugin().advance(0.0f);
    }

    public static void explode(SectorEntityToken gate) {
        gate.getContainingLocation().addScript(new GateExplosionScript(gate));
    }
}

