/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEntityPickerListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.intel.misc.GateHaulerIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateHaulerCMD
extends BaseCommandPlugin {
    public static int ACTIVATION_COST = 1000;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected SectorEntityToken stableLocation;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = GateHaulerCMD.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.stableLocation = this.findNearestStableLocation();
        if (command.equals("addIntel")) {
            Global.getSector().getIntelManager().addIntel(new GateHaulerIntel(this.entity), false, this.text);
        } else if (command.equals("printCost")) {
            this.printCost();
        } else if (command.equals("removeActivationCosts")) {
            this.removeActivationCosts();
        } else {
            if (command.equals("canActivate")) {
                return this.canActivate();
            }
            if (command.equals("selectDestination")) {
                this.selectDestination();
            } else if (command.equals("activate")) {
                this.activate();
            } else {
                if (command.equals("canDeploy")) {
                    return this.canDeploy();
                }
                if (command.equals("deploy")) {
                    this.deploy();
                }
            }
        }
        return true;
    }

    public void deploy() {
        if (this.stableLocation == null) {
            return;
        }
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel != null) {
            intel.initiateDeployment(this.stableLocation);
        }
    }

    public boolean canDeploy() {
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel == null) {
            return false;
        }
        return this.stableLocation != null;
    }

    public SectorEntityToken findNearestStableLocation() {
        if (this.entity.getContainingLocation() == null) {
            return null;
        }
        float minDist = Float.MAX_VALUE;
        SectorEntityToken nearest = null;
        for (SectorEntityToken curr : this.entity.getContainingLocation().getEntitiesWithTag("stable_location")) {
            float dist = Misc.getDistance(curr, this.entity);
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearest = curr;
        }
        return nearest;
    }

    public void activate() {
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel != null) {
            intel.activate();
        }
    }

    public void printCost() {
        Misc.showCost(this.text, null, null, this.getResources(), this.getQuantities());
        if (this.canActivate()) {
            this.text.addPara("\u5f00\u59cb\u91cd\u65b0\u6fc0\u6d3b\uff1f");
        } else {
            this.text.addPara("\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u8d44\u6e90\u6765\u91cd\u542f \u661f\u95e8\u8fd0\u8f93\u8230\u3002");
        }
    }

    public void removeActivationCosts() {
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getResources();
        int[] quantities = this.getQuantities();
        int i = 0;
        while (i < res.length) {
            String commodityId = res[i];
            int quantity = quantities[i];
            cargo.removeCommodity(commodityId, quantity);
            ++i;
        }
    }

    public boolean canActivate() {
        if (DebugFlags.OBJECTIVES_DEBUG) {
            return true;
        }
        CargoAPI cargo = this.playerCargo;
        String[] res = this.getResources();
        int[] quantities = this.getQuantities();
        int i = 0;
        while (i < res.length) {
            int quantity = quantities[i];
            String commodityId = res[i];
            if ((float)quantity > cargo.getQuantity(CargoAPI.CargoItemType.RESOURCES, commodityId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getResources() {
        return new String[]{"rare_metals"};
    }

    public int[] getQuantities() {
        return new int[]{ACTIVATION_COST};
    }

    public int getTravelDays(SectorEntityToken entity) {
        GateHaulerIntel intel = GateHaulerIntel.get(this.entity);
        if (intel != null) {
            StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
            return intel.computeTransitDays(system);
        }
        return 365;
    }

    public void selectDestination() {
        ArrayList<SectorEntityToken> systems = new ArrayList<SectorEntityToken>();
        for (StarSystemAPI curr : Global.getSector().getStarSystems()) {
            if (curr == this.entity.getContainingLocation() || curr.hasTag("theme_hidden") && !"Limbo".equals(curr.getBaseName()) || curr.isDeepSpace() || curr.getHyperspaceAnchor() == null || Misc.getStarSystemForAnchor(curr.getHyperspaceAnchor()) == null) continue;
            systems.add(curr.getHyperspaceAnchor());
        }
        this.dialog.showCampaignEntityPicker("\u9009\u62e9 \u661f\u95e8\u8fd0\u8f93\u8230 \u7684\u76ee\u7684\u5730", "\u76ee\u7684\u5730\uff1a", "\u6267\u884c", Global.getSector().getPlayerFaction(), systems, new BaseCampaignEntityPickerListener(){

            public void pickedEntity(SectorEntityToken entity) {
                GateHaulerCMD.this.dialog.dismiss();
                Global.getSector().setPaused(false);
                GateHaulerIntel intel = GateHaulerIntel.get(GateHaulerCMD.this.entity);
                if (intel != null) {
                    StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
                    intel.initiateDeparture(system);
                }
            }

            public void cancelledEntityPicking() {
            }

            public String getMenuItemNameOverrideFor(SectorEntityToken entity) {
                StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
                if (system != null) {
                    return system.getNameWithLowercaseTypeShort();
                }
                return null;
            }

            public String getSelectedTextOverrideFor(SectorEntityToken entity) {
                StarSystemAPI system = Misc.getStarSystemForAnchor(entity);
                if (system != null) {
                    return system.getNameWithLowercaseType();
                }
                return null;
            }

            public void createInfoText(TooltipMakerAPI info, SectorEntityToken entity) {
                int \u5929 = GateHaulerCMD.this.getTravelDays(entity);
                info.setParaSmallInsignia();
                String daysStr = "\u5929";
                if (\u5929 == 1) {
                    daysStr = "\u5929";
                }
                info.addPara("    \u9884\u8ba1 \u661f\u95e8\u8fd0\u8f93\u8230 \u822a\u884c\u8017\u65f6\uff1a%s " + daysStr, 0.0f, Misc.getHighlightColor(), "" + \u5929);
            }

            public boolean canConfirmSelection(SectorEntityToken entity) {
                return true;
            }

            public float getFuelColorAlphaMult() {
                return 0.0f;
            }

            public float getFuelRangeMult() {
                return 0.0f;
            }
        });
    }
}

