/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.missions;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.LuddicShrineIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrineCMD
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String id;
        PlanetAPI planet;
        if (dialog == null) {
            return false;
        }
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        SectorEntityToken entity = dialog.getInteractionTarget();
        if (entity.getMarket() != null && !entity.getMarket().isPlanetConditionMarketOnly() && (planet = entity.getMarket().getPlanetEntity()) != null) {
            entity = planet;
        }
        if ("addIntel".equals(command)) {
            if (params.size() > 1) {
                id = params.get(1).getString(memoryMap);
                entity = LuddicShrineIntel.getEntity(id);
            }
            LuddicShrineIntel.addShrineIntelIfNeeded(entity, dialog.getTextPanel());
            return true;
        }
        if ("setVisited".equals(command)) {
            if (params.size() > 1) {
                id = params.get(1).getString(memoryMap);
                entity = LuddicShrineIntel.getEntity(id);
            }
            LuddicShrineIntel.addShrineIntelIfNeeded(entity, dialog.getTextPanel(), true);
            LuddicShrineIntel.setVisited(entity, dialog.getTextPanel());
            return true;
        }
        if ("playMusic".equals(command)) {
            String shrineMusic = "music_luddite_shrine";
            Global.getSoundPlayer().playCustomMusic(1, 1, shrineMusic, true);
        } else if ("endMusic".equals(command)) {
            Global.getSoundPlayer().restartCurrentMusic();
        }
        return false;
    }

    public static class ShrineMusicStopFailsafe
    implements EveryFrameScript {
        public boolean done = false;
        public String musicId;

        public ShrineMusicStopFailsafe(String musicId) {
            this.musicId = musicId;
        }

        public void advance(float amount) {
            if (!Global.getSector().isPaused()) {
                if (this.musicId.equals(Global.getSoundPlayer().getCurrentMusicId())) {
                    Global.getSoundPlayer().restartCurrentMusic();
                }
                this.done = true;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean runWhilePaused() {
            return false;
        }
    }
}

