/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoPickerListener;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AICores
extends BaseCommandPlugin {
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected PersonAPI person;
    protected FactionAPI faction;
    protected boolean buysAICores;
    protected float valueMult;
    protected float repMult;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = AICores.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.person = dialog.getInteractionTarget().getActivePerson();
        this.faction = this.person.getFaction();
        this.buysAICores = this.faction.getCustomBoolean("buysAICores");
        this.valueMult = this.faction.getCustomFloat("AICoreValueMult");
        this.repMult = this.faction.getCustomFloat("AICoreRepMult");
        if (command.equals("selectCores")) {
            this.selectCores();
        } else {
            if (command.equals("playerHasCores")) {
                return this.playerHasCores();
            }
            if (command.equals("personCanAcceptCores")) {
                return this.personCanAcceptCores();
            }
        }
        return true;
    }

    protected boolean personCanAcceptCores() {
        if (this.person == null || !this.buysAICores) {
            return false;
        }
        return Ranks.POST_BASE_COMMANDER.equals(this.person.getPostId()) || Ranks.POST_STATION_COMMANDER.equals(this.person.getPostId()) || Ranks.POST_ADMINISTRATOR.equals(this.person.getPostId()) || Ranks.POST_OUTPOST_COMMANDER.equals(this.person.getPostId());
    }

    protected void selectCores() {
        CargoAPI copy = Global.getFactory().createCargo(false);
        for (CargoStackAPI stack : this.playerCargo.getStacksCopy()) {
            CommoditySpecAPI spec = stack.getResourceIfResource();
            if (spec == null || !spec.getDemandClass().equals("ai_cores")) continue;
            copy.addFromStack(stack);
        }
        copy.sort();
        float width = 310.0f;
        this.dialog.showCargoPickerDialog("\u9009\u62e9\u4e0a\u4ea4\u7684 AI \u6838\u5fc3", "\u786e\u8ba4", "\u53d6\u6d88", true, 310.0f, copy, new CargoPickerListener(){

            public void pickedCargo(CargoAPI cargo) {
                if (cargo.isEmpty()) {
                    this.cancelledCargoSelection();
                    return;
                }
                cargo.sort();
                for (CargoStackAPI stack : cargo.getStacksCopy()) {
                    AICores.this.playerCargo.removeItems(stack.getType(), stack.getData(), stack.getSize());
                    if (!stack.isCommodityStack()) continue;
                    int num = (int)stack.getSize();
                    AddRemoveCommodity.addCommodityLossText(stack.getCommodityId(), num, AICores.this.text);
                    String key = "$turnedIn_" + stack.getCommodityId();
                    int turnedIn = AICores.this.faction.getMemoryWithoutUpdate().getInt(key);
                    AICores.this.faction.getMemoryWithoutUpdate().set(key, turnedIn + num);
                    String key2 = "$turnedIn_allCores";
                    int turnedIn2 = AICores.this.faction.getMemoryWithoutUpdate().getInt(key2);
                    AICores.this.faction.getMemoryWithoutUpdate().set(key2, turnedIn2 + num);
                }
                float bounty = AICores.this.computeCoreCreditValue(cargo);
                float repChange = AICores.this.computeCoreReputationValue(cargo);
                if (bounty > 0.0f) {
                    AICores.this.playerCargo.getCredits().add(bounty);
                    AddRemoveCommodity.addCreditsGainText((int)bounty, AICores.this.text);
                }
                if (repChange >= 1.0f) {
                    CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
                    impact.delta = repChange * 0.01f;
                    Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, AICores.this.text, true), AICores.this.faction.getId());
                    impact.delta *= 0.25f;
                    if (impact.delta >= 0.01f) {
                        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, AICores.this.text, true), AICores.this.person);
                    }
                }
                FireBest.fire(null, AICores.this.dialog, AICores.this.memoryMap, "AICoresTurnedIn");
            }

            public void cancelledCargoSelection() {
            }

            public void recreateTextPanel(TooltipMakerAPI panel, CargoAPI cargo, CargoStackAPI pickedUp, boolean pickedUpFromSource, CargoAPI combined) {
                float bounty = AICores.this.computeCoreCreditValue(combined);
                float repChange = AICores.this.computeCoreReputationValue(combined);
                float pad = 3.0f;
                float small = 5.0f;
                float opad = 10.0f;
                panel.setParaFontOrbitron();
                panel.addPara(Misc.ucFirst(AICores.this.faction.getDisplayName()), AICores.this.faction.getBaseUIColor(), 1.0f);
                panel.setParaFontDefault();
                panel.addImage(AICores.this.faction.getLogo(), 310.0f, 3.0f);
                panel.addPara("\u4e0e\u5176\u4ed6\u52bf\u529b\u76f8\u6bd4\uff0c\u628a AI \u6838\u5fc3 \u4e0a\u4ea4\u7ed9 " + AICores.this.faction.getDisplayNameLongWithArticle() + " " + "\u5c06\u83b7\u5f97\uff1a", opad);
                panel.beginGridFlipped(310.0f, 1, 40.0f, 10.0f);
                panel.addToGrid(0, 0, "\u4ef7\u503c\u5956\u52b1", (int)(AICores.this.valueMult * 100.0f) + "%");
                panel.addToGrid(0, 1, "\u5173\u7cfb\u63d0\u9ad8", (int)(AICores.this.repMult * 100.0f) + "%");
                panel.addGrid(pad);
                panel.addPara("\u4e0a\u4ea4\u8be5 AI \u6838\u5fc3\uff0c\u4f60\u53ef\u83b7\u5f97 %s \u7684\u5956\u52b1\uff0c\u5e76\u8ba9\u4f60\u548c " + AICores.this.faction.getDisplayNameWithArticle() + " \u7684\u5173\u7cfb\u63d0\u9ad8 %s \u70b9\u3002", opad * 1.0f, Misc.getHighlightColor(), String.valueOf(Misc.getWithDGS(bounty)) + "\u00a2", "" + (int)repChange);
            }
        });
    }

    protected float computeCoreCreditValue(CargoAPI cargo) {
        float bounty = 0.0f;
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            CommoditySpecAPI spec = stack.getResourceIfResource();
            if (spec == null || !spec.getDemandClass().equals("ai_cores")) continue;
            bounty += spec.getBasePrice() * stack.getSize();
        }
        return bounty *= this.valueMult;
    }

    protected float computeCoreReputationValue(CargoAPI cargo) {
        float rep = 0.0f;
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            CommoditySpecAPI spec = stack.getResourceIfResource();
            if (spec == null || !spec.getDemandClass().equals("ai_cores")) continue;
            rep += AICores.getBaseRepValue(spec.getId()) * stack.getSize();
        }
        return rep *= this.repMult;
    }

    public static float getBaseRepValue(String coreType) {
        if ("omega_core".equals(coreType)) {
            return 15.0f;
        }
        if ("alpha_core".equals(coreType)) {
            return 5.0f;
        }
        if ("beta_core".equals(coreType)) {
            return 2.0f;
        }
        if ("gamma_core".equals(coreType)) {
            return 1.0f;
        }
        return 1.0f;
    }

    protected boolean playerHasCores() {
        for (CargoStackAPI stack : this.playerCargo.getStacksCopy()) {
            CommoditySpecAPI spec = stack.getResourceIfResource();
            if (spec == null || !spec.getDemandClass().equals("ai_cores")) continue;
            return true;
        }
        return false;
    }
}

