/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CargoPodsEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.CargoPodsIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoPods
extends BaseCommandPlugin {
    public static final String TRAPPED = "$trapped";
    public static final String LOCKED = "$locked";
    public static final String CAN_UNLOCK = "$canUnlock";
    public static final float BREAK_KEEP_FRACTION = 0.5f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected CargoAPI podsCargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected CargoPodsEntityPlugin plugin;
    protected Map<String, MemoryAPI> memoryMap;

    protected boolean isLocked() {
        return this.memory.getBoolean(LOCKED);
    }

    protected boolean isTrapped() {
        return this.memory.getBoolean(TRAPPED);
    }

    protected boolean canUnlock() {
        return this.memory.getBoolean(CAN_UNLOCK);
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.memory = CargoPods.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.podsCargo = this.entity.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.plugin = (CargoPodsEntityPlugin)this.entity.getCustomPlugin();
        if (command.equals("printDesc")) {
            this.showDescription();
        } else if (command.equals("openCargo")) {
            this.openCargo();
        } else if (command.equals("breakLocks")) {
            this.breakLocks();
        } else if (command.equals("destroy")) {
            this.destroy();
        } else if (command.equals("stabilize")) {
            this.stabilize();
        } else if (command.equals("computeStabilizeData")) {
            this.computeStabilizeData();
        }
        return true;
    }

    protected void computeStabilizeData() {
        float total = (float)this.podsCargo.getTotalPersonnel() + this.podsCargo.getSpaceUsed() + this.podsCargo.getFuel();
        float stabilizeSupplies = Math.max((int)total / 200, 2);
        this.memory.set("$stabilizeSupplies", (int)stabilizeSupplies, 0.0f);
        float stabilizeDays = 400.0f;
        this.memory.set("$stabilizeDays", (int)stabilizeDays, 0.0f);
    }

    public static SectorEntityToken findOrbitFocus(SectorEntityToken entity) {
        if (entity.isInHyperspace()) {
            return null;
        }
        SectorEntityToken target = null;
        float minDist = Float.MAX_VALUE;
        ArrayList<PlanetAPI> potential = new ArrayList<PlanetAPI>(entity.getContainingLocation().getPlanets());
        SectorEntityToken center = ((StarSystemAPI)entity.getContainingLocation()).getCenter();
        potential.add((PlanetAPI)center);
        potential.addAll(entity.getContainingLocation().getJumpPoints());
        for (SectorEntityToken sectorEntityToken : potential) {
            float dist = Misc.getDistance(entity.getLocation(), sectorEntityToken.getLocation());
            dist -= sectorEntityToken.getRadius();
            float maxDist = 400.0f;
            if (sectorEntityToken instanceof PlanetAPI && ((PlanetAPI)sectorEntityToken).isStar() || sectorEntityToken == center) {
                maxDist = 1.0E11f;
            }
            if (!(dist < maxDist) || !(dist < minDist)) continue;
            target = sectorEntityToken;
            minDist = dist;
        }
        return target;
    }

    public static void stabilizeOrbit(SectorEntityToken entity, boolean makeDiscovered) {
        SectorEntityToken focus = CargoPods.findOrbitFocus(entity);
        if (focus != null) {
            float radius = Misc.getDistance(focus.getLocation(), entity.getLocation());
            float orbitDays = radius / (5.0f + Misc.random.nextFloat() * 20.0f);
            float angle = Misc.getAngleInDegreesStrict(focus.getLocation(), entity.getLocation());
            entity.setCircularOrbit(focus, angle, radius, orbitDays);
        } else {
            entity.getVelocity().set(0.0f, 0.0f);
        }
        if (makeDiscovered) {
            entity.setDiscoverable(null);
            entity.setSensorProfile(null);
        }
        entity.getMemoryWithoutUpdate().set("$stabilized", true);
    }

    protected void stabilize() {
        CargoPods.stabilizeOrbit(this.entity, true);
        float stabilizeSupplies = this.memory.getFloat("$stabilizeSupplies");
        float stabilizeDays = this.memory.getFloat("$stabilizeDays");
        this.playerCargo.removeSupplies(stabilizeSupplies);
        this.plugin.setElapsed(0.0f);
        this.plugin.setExtraDays(stabilizeDays);
        this.plugin.updateBaseMaxDays();
        AddRemoveCommodity.updatePlayerMemoryQuantity("supplies");
        AddRemoveCommodity.addCommodityLossText("supplies", (int)stabilizeSupplies, this.text);
        this.text.addParagraph("\u4f60\u7684\u8239\u5458\u5fd9\u7740\u5b89\u88c5\u5fae\u578b\u63a8\u8fdb\u5668\uff0c\u5e76\u5c0f\u5fc3\u7ffc\u7ffc\u5730\u5bc6\u5c01\u3001\u5e73\u8861\u76f8\u4e92\u8fde\u63a5\u7684\u540a\u8231\uff0c\u4ee5\u786e\u4fdd\u5b83\u4eec\u4fdd\u6301\u5728\u7a33\u5b9a\u7684\u8f68\u9053\u4e0a\u3002");
        float daysLeft = this.plugin.getDaysLeft();
        this.memory.set("$stabilized", true);
        this.memory.set("$daysLeft", (int)daysLeft, 0.0f);
        CargoPodsIntel intel = null;
        for (IntelInfoPlugin iip : Global.getSector().getIntelManager().getIntel(CargoPodsIntel.class)) {
            CargoPodsIntel curr = (CargoPodsIntel)iip;
            if (curr.getPods() != this.entity) continue;
            intel = curr;
            break;
        }
        if (intel == null) {
            intel = new CargoPodsIntel(this.entity);
            Global.getSector().getIntelManager().addIntel(intel, true);
        }
        Global.getSector().getIntelManager().addIntelToTextPanel(intel, this.text);
    }

    protected void destabilize() {
        if (!this.memory.getBoolean("$stabilized")) {
            return;
        }
        this.entity.setOrbit(null);
        Vector2f vel = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        vel.scale(5.0f + 10.0f * (float)Math.random());
        this.entity.getVelocity().set((ReadableVector2f)vel);
        this.entity.setDiscoverable(null);
        this.entity.setSensorProfile(Float.valueOf(1.0f));
        this.plugin.setElapsed(0.0f);
        this.plugin.setExtraDays(0.0f);
        this.plugin.updateBaseMaxDays();
        float daysLeft = this.plugin.getDaysLeft();
        String atLeastTime = Misc.getAtLeastStringForDays((int)daysLeft);
        this.text.addParagraph("\u88c5\u5378\u8d27\u7269\u4f7f\u8f68\u9053\u53d8\u5f97\u4e0d\u592a\u7a33\u5b9a\uff0c\u4f46\u662f\u540a\u8231\u4ecd\u53ef\u88ab\u8ffd\u8e2a\u5230\u3002\u4f30\u8ba1\u80fd\u7a33\u5b9a " + atLeastTime + ".");
        this.memory.unset("$stabilized");
    }

    protected void breakLocks() {
        this.pruneCargo(0.5f);
        this.openCargo();
    }

    protected void pruneCargo(float fractionKeep) {
        CargoAPI keep = Global.getFactory().createCargo(true);
        Random random = new Random();
        if (this.memory.contains("$salvageSeed")) {
            long seed = this.memory.getLong("$salvageSeed");
            random = new Random(seed);
        }
        for (CargoStackAPI stack : this.podsCargo.getStacksCopy()) {
            int qty = (int)stack.getSize();
            int i = 0;
            while (i < qty) {
                if (random.nextFloat() < fractionKeep) {
                    keep.addItems(stack.getType(), stack.getData(), 1.0f);
                }
                ++i;
            }
        }
        this.podsCargo.clear();
        this.podsCargo.addAll(keep);
    }

    protected void destroy() {
        this.podsCargo.clear();
        Misc.fadeAndExpire(this.entity, 1.0f);
    }

    protected void showDescription() {
        float daysLeft = this.plugin.getDaysLeft();
        this.memory.set("$daysLeft", (int)daysLeft, 0.0f);
        boolean stabilized = this.memory.getBoolean("$stabilized");
        if (daysLeft >= 5000.0f) {
            this.text.addParagraph("\u8d27\u8231\u76ee\u524d\u5904\u4e8e\u7a33\u5b9a\u7684\u8f68\u9053\uff0c\u6240\u4ee5\u77ed\u65f6\u95f4\u5185\u4e0d\u4f1a\u98d8\u6563\u3002");
        } else {
            String atLeastTime = Misc.getAtLeastStringForDays((int)daysLeft);
            if (stabilized && daysLeft > 20.0f) {
                this.text.addParagraph("\u8d27\u8231\u5904\u4e8e\u7a33\u5b9a\u8f68\u9053\uff0c\u4f60\u7684\u7cfb\u7edf\u5e94\u8be5\u80fd\u8ffd\u8e2a\u5230\u5b83\u4eec\uff0c\u4f30\u8ba1\u80fd\u7a33\u5b9a " + atLeastTime + ".");
            } else {
                float depth = Misc.getAbyssalDepth(this.entity);
                if (depth >= 1.0f) {
                    this.text.addParagraph("\u7531\u4e8e \u6df1\u6e0a\u8d85\u7a7a\u95f4 \u6df1\u4e0d\u53ef\u6d4b\uff0c\u8d27\u7269\u8231\u5f88\u53ef\u80fd\u5728\u79bb\u5f00\u4f60\u4f20\u611f\u5668\u63a2\u6d4b\u8303\u56f4\u4e4b\u540e\u6c38\u4e0d\u590d\u5f97\u3002");
                } else {
                    this.text.addParagraph("\u8d27\u7269\u8231\u5904\u4e8e\u4e0d\u7a33\u5b9a\u7684\u8f68\u9053\uff0c\u4f46\u76ee\u524d\u4e0d\u4f1a\u5206\u6563\u4e22\u5931\uff0c\u4f30\u8ba1\u80fd\u7a33\u5b9a " + atLeastTime + ".");
                }
            }
        }
        if (this.podsCargo.getTotalPersonnel() > 0) {
            String crewText = "\u4f20\u611f\u5668\u8bfb\u6570\u8868\u793a\uff0c\u5b58\u5728\u6d3b\u8dc3\u7684\u751f\u547d\u652f\u6301\u8bbe\u65bd\u548c\u4f4e\u6e29\u51b7\u51bb\u8bbe\u5907\u3002";
            this.text.addParagraph(crewText);
        }
        if (this.isLocked()) {
            if (this.canUnlock()) {
                this.text.addParagraph("\u540a\u8231\u5df2\u88ab\u9501\u5b9a\uff0c\u4f46\u662f\u4f60\u62e5\u6709\u94a5\u5319\u7801\u3002");
            } else {
                this.text.addParagraph("\u8d27\u7269\u4ed3\u4e0a\u4e86\u9501\uff0c\u4f60\u6ca1\u6709\u5bc6\u5319\u3002\u867d\u7136\u4f60\u53ef\u4ee5\u5f3a\u884c\u5f00\u9501\uff0c\u4f46\u662f\u8fd9\u53ef\u80fd\u4f1a\u5371\u5bb3\u5230\u5176\u4e2d\u7684\u8d27\u7269\u3002\u90e8\u5206\u8d27\u7269\u4ed3\u8fd8\u6709\u5185\u7f6e\u7684\u81ea\u6bc1\u7cfb\u7edf\uff0c\u80fd\u591f\u786e\u4fdd\u5f3a\u884c\u5f00\u542f\u65f6\u80fd\u591f\u9500\u6bc1\u6240\u6709\u8d27\u7269\u3002");
            }
        }
    }

    public void openCargo() {
        final CargoAPI preOpen = Global.getFactory().createCargo(true);
        preOpen.addAll(this.podsCargo);
        this.dialog.getVisualPanel().showLoot("\u8d27\u7269\u540a\u8231", this.podsCargo, true, false, false, new CoreInteractionListener(){

            public void coreUIDismissed() {
                CargoPods.this.plugin.updateBaseMaxDays();
                if (CargoPods.this.podsCargo.isEmpty()) {
                    Misc.fadeAndExpire(CargoPods.this.entity, 1.0f);
                    CargoPods.this.dialog.dismiss();
                    CargoPods.this.dialog.hideTextPanel();
                    CargoPods.this.dialog.hideVisualPanel();
                } else if (!Misc.isSameCargo(preOpen, CargoPods.this.podsCargo)) {
                    CargoPods.this.destabilize();
                }
                CargoPods.this.dialog.setPromptText("\u4f60\u51b3\u5b9a...");
                FireAll.fire(null, CargoPods.this.dialog, CargoPods.this.memoryMap, "CargoPodsOptions");
                FireAll.fire(null, CargoPods.this.dialog, CargoPods.this.memoryMap, "CargoPodsOptionsUpdate");
            }
        });
        this.options.clearOptions();
        this.dialog.setPromptText("");
    }
}

