/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.GroundRaidTargetPickerDelegate;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.GroundRaidObjectivesListener;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.MilitaryResponseScript;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.econ.impl.PopulationAndInfrastructure;
import com.fs.starfarer.api.impl.campaign.graid.DisruptIndustryRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.GroundRaidObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.deciv.DecivTracker;
import com.fs.starfarer.api.impl.campaign.population.CoreImmigrationPluginImpl;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.SetStoryOption;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketCMD
extends BaseCommandPlugin {
    public static int HOSTILE_ACTIONS_TIMEOUT_DAYS = 60;
    public static int TACTICAL_BOMBARD_TIMEOUT_DAYS = 120;
    public static int SATURATION_BOMBARD_TIMEOUT_DAYS = 365;
    public static int MIN_MARINE_TOKENS = 1;
    public static float RE_PER_MARINE_TOKEN = 0.1f;
    public static int MAX_MARINE_TOKENS = 10;
    public static float LOSS_REDUCTION_PER_RESERVE_TOKEN = 0.05f;
    public static float LOSS_INCREASE_PER_RAID = 0.5f;
    public static float MAX_MARINE_LOSSES = 0.8f;
    public static float MIN_RE_TO_REDUCE_MARINE_LOSSES = 0.5f;
    public static float MAX_MARINE_LOSS_REDUCTION_MULT = 0.05f;
    public static float ECON_IMPACT_MULT = 1.0f;
    public static float QUANTITY_MULT_NORMAL = 1.0f;
    public static float QUANTITY_MULT_EXCESS = 2.0f;
    public static float QUANTITY_MULT_DEFICIT = -0.5f;
    public static float QUANTITY_MULT_OVERALL = 0.1f;
    public static String ENGAGE = "mktEngage";
    public static String RAID = "mktRaid";
    public static String RAID_NON_MARKET = "mktRaidNonMarket";
    public static String RAID_VALUABLE = "mktRaidValuable";
    public static String RAID_DISRUPT = "mktRaidDisrupt";
    public static String RAID_GO_BACK = "mktRaidGoBack";
    public static String RAID_CONFIRM_CONTINUE = "mktRaidConfirmContinue";
    public static String RAID_CONFIRM = "mktRaidConfirm";
    public static String RAID_CONFIRM_STORY = "mktRaidConfirmStory";
    public static String RAID_NEVER_MIND = "mktRaidNeverMind";
    public static String RAID_RESULT = "mktRaidResult";
    public static String INVADE = "mktInvade";
    public static String GO_BACK = "mktGoBack";
    public static String BOMBARD = "mktBombard";
    public static String BOMBARD_TACTICAL = "mktBombardTactical";
    public static String BOMBARD_SATURATION = "mktBombardSaturation";
    public static String BOMBARD_CONFIRM = "mktBombardConfirm";
    public static String BOMBARD_NEVERMIND = "mktBombardNeverMind";
    public static String BOMBARD_RESULT = "mktBombardResult";
    public static String DEBT_RESULT_CONTINUE = "marketCmd_checkDebtContinue";
    public static float DISRUPTION_THRESHOLD = 0.25f;
    public static float VALUABLES_THRESHOLD = 0.05f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected MarketAPI market;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected FactionAPI faction;
    protected TempData temp = new TempData();
    public static float MARINES_IN_MARKET_CARGO_DEFENSE_BONUS = 1.0f;
    public static final String DEFENDER_INCREASE_KEY = "$core_defenderIncrease";

    public MarketCMD() {
    }

    protected void clearTemp() {
        if (this.temp != null) {
            this.temp.raidType = null;
            this.temp.bombardType = null;
            this.temp.raidLoot = null;
            this.temp.target = null;
            this.temp.willBecomeHostile.clear();
            this.temp.bombardmentTargets.clear();
            this.temp.objectives.clear();
            this.temp.contText = null;
            this.temp.raidGoBackTrigger = null;
            this.temp.raidContinueTrigger = null;
        }
    }

    public MarketCMD(SectorEntityToken entity) {
        this.init(entity);
    }

    protected void init(SectorEntityToken entity) {
        this.memory = entity.getMemoryWithoutUpdate();
        this.entity = entity;
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = entity.getFaction();
        this.faction = entity.getFaction();
        this.market = entity.getMarket();
        String key = "$MarketCMD_temp";
        MemoryAPI mem = null;
        mem = this.market != null ? this.market.getMemoryWithoutUpdate() : entity.getMemoryWithoutUpdate();
        if (mem.contains(key)) {
            this.temp = (TempData)mem.get(key);
        } else {
            mem.set(key, this.temp, 0.0f);
        }
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.entity = dialog.getInteractionTarget();
        this.init(this.entity);
        this.memory = MarketCMD.getEntityMemory(memoryMap);
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        if (command.equals("showDefenses")) {
            this.clearTemp();
            this.showDefenses(true);
        } else if (command.equals("goBackToDefenses")) {
            if (this.temp.nonMarket) {
                String trigger = this.temp.raidGoBackTrigger;
                if (trigger == null || trigger.isEmpty()) {
                    trigger = "PopulateOptions";
                }
                this.clearTemp();
                FireAll.fire(null, dialog, memoryMap, trigger);
                return true;
            }
            this.clearTemp();
            this.showDefenses(true);
        } else if (command.equals("engage")) {
            this.engage();
        } else if (command.equals("raidMenu")) {
            this.raidMenu();
        } else if (command.equals("raidNonMarket")) {
            this.raidNonMarket();
        } else if (command.equals("raidValuable")) {
            this.raidValuable();
        } else if (command.equals("raidDisrupt")) {
            this.raidDisrupt();
        } else if (command.equals("raidConfirm")) {
            this.raidConfirm(false);
        } else if (command.equals("raidConfirmContinue")) {
            this.raidConfirmContinue();
        } else if (command.equals("raidNeverMind")) {
            this.raidNeverMind();
        } else if (command.equals("addContinueToRaidResultOption")) {
            this.addContinueOption(this.temp.contText);
        } else if (command.equals("raidResult")) {
            this.raidResult();
        } else if (command.equals("bombardMenu")) {
            this.bombardMenu();
        } else if (command.equals("bombardTactical")) {
            this.bombardTactical();
        } else if (command.equals("bombardSaturation")) {
            this.bombardSaturation();
        } else if (command.equals("bombardConfirm")) {
            this.bombardConfirm();
        } else if (command.equals("bombardNeverMind")) {
            this.bombardNeverMind();
        } else if (command.equals("bombardResult")) {
            this.bombardResult();
        } else {
            if (command.equals("checkDebtEffect")) {
                return this.checkDebtEffect();
            }
            if (command.equals("applyDebtEffect")) {
                this.applyDebtEffect();
            } else {
                if (command.equals("checkMercsLeaving")) {
                    return this.checkMercsLeaving();
                }
                if (command.equals("convinceMercToStay")) {
                    this.convinceMercToStay();
                } else if (command.equals("mercLeaves")) {
                    this.mercLeaves();
                }
            }
        }
        return true;
    }

    protected void showDefenses(boolean withText) {
        FleetMemberAPI flagship;
        CampaignFleetAPI primary = this.getInteractionTargetForFIDPI();
        CampaignFleetAPI station = this.getStationFleet();
        boolean hasNonStation = false;
        boolean hasOtherButInsignificant = true;
        boolean hasStation = station != null;
        boolean otherWantsToFight = false;
        BattleAPI b = null;
        FleetEncounterContext context = null;
        FleetInteractionDialogPluginImpl plugin = null;
        boolean ongoingBattle = false;
        boolean playerOnDefenderSide = false;
        boolean playerCanNotJoin = false;
        String stationType = "station";
        if (station != null && (flagship = station.getFlagship()) != null && flagship.getVariant() != null) {
            String name;
            stationType = name = flagship.getVariant().getDesignation().toLowerCase();
        }
        StationState state = this.getStationState();
        if (this.market != null) {
            Global.getSector().getEconomy().tripleStep();
        }
        if (primary == null) {
            if (state == StationState.NONE) {
                this.text.addPara("\u8be5\u6b96\u6c11\u5730\u6ca1\u6709\u8f68\u9053\u9632\u5fa1\u8bbe\u65bd\u4ee5\u53ca\u9632\u5fa1\u8230\u961f\u7684\u4fdd\u62a4\u3002");
            } else {
                this.printStationState();
                this.text.addPara("\u9644\u8fd1\u6ca1\u6709\u8230\u961f\u6b63\u5728\u4fdd\u536b\u6b96\u6c11\u5730\u3002");
            }
        } else {
            ongoingBattle = primary.getBattle() != null;
            CampaignFleetAPI pluginFleet = primary;
            if (ongoingBattle) {
                BattleAPI.BattleSide playerSide = primary.getBattle().pickSide(this.playerFleet);
                CampaignFleetAPI other = primary.getBattle().getPrimary(primary.getBattle().getOtherSide(playerSide));
                if (other != null) {
                    pluginFleet = other;
                }
            }
            FleetInteractionDialogPluginImpl.FIDConfig params = new FleetInteractionDialogPluginImpl.FIDConfig();
            params.justShowFleets = true;
            params.showPullInText = withText;
            plugin = new FleetInteractionDialogPluginImpl(params);
            this.dialog.setInteractionTarget(pluginFleet);
            plugin.init(this.dialog);
            this.dialog.setInteractionTarget(this.entity);
            context = (FleetEncounterContext)plugin.getContext();
            b = context.getBattle();
            BattleAPI.BattleSide playerSide = b.pickSide(this.playerFleet);
            if (playerSide != BattleAPI.BattleSide.NO_JOIN && b.getOtherSideCombined(playerSide).isEmpty()) {
                playerSide = BattleAPI.BattleSide.NO_JOIN;
            }
            boolean bl = playerCanNotJoin = playerSide == BattleAPI.BattleSide.NO_JOIN;
            if (!playerCanNotJoin) {
                boolean bl2 = playerOnDefenderSide = b.getSide(playerSide) == b.getSideFor(primary);
            }
            if (!ongoingBattle) {
                playerOnDefenderSide = false;
            }
            boolean otherHasStation = false;
            if (playerSide != BattleAPI.BattleSide.NO_JOIN) {
                if (station != null) {
                    for (CampaignFleetAPI fleet : b.getSideFor(station)) {
                        if (fleet.isStationMode()) continue;
                        hasNonStation = true;
                        hasOtherButInsignificant &= Misc.isInsignificant(fleet);
                    }
                } else if (b.getNonPlayerSide() != null) {
                    for (CampaignFleetAPI fleet : b.getNonPlayerSide()) {
                        if (fleet.isStationMode()) continue;
                        hasNonStation = true;
                        hasOtherButInsignificant &= Misc.isInsignificant(fleet);
                    }
                } else {
                    hasNonStation = true;
                }
                for (CampaignFleetAPI fleet : b.getOtherSide(playerSide)) {
                    if (!fleet.isStationMode()) continue;
                    otherHasStation = true;
                }
            }
            if (!hasNonStation) {
                hasOtherButInsignificant = false;
            }
            boolean bl3 = otherWantsToFight = otherHasStation || plugin.otherFleetWantsToFight(true);
            if (withText) {
                if (hasStation) {
                    FleetMemberAPI flagship2;
                    String name = "\u8f68\u9053\u7ad9";
                    if (station != null && (flagship2 = station.getFlagship()) != null) {
                        stationType = name = flagship2.getVariant().getDesignation().toLowerCase();
                        name = String.valueOf(Misc.ucFirst(station.getFaction().getPersonNamePrefixAOrAn())) + " " + station.getFaction().getPersonNamePrefix() + " " + name;
                    }
                    this.text.addPara(String.valueOf(name) + " \u6b63\u5904\u4e8e\u8b66\u6212\u72b6\u6001\uff0c\u9664\u975e\u88ab\u5f7b\u5e95\u6467\u6bc1\uff0c" + "\u5b83\u5c06\u963b\u6b62\u4efb\u4f55\u53ef\u9884\u6599\u7684\u654c\u5bf9\u884c\u52a8\uff0c\u4f46\u4f60\u4ecd\u53ef\u5bf9\u6b64\u8fdb\u884c\u7a81\u88ad\u3002");
                    if (hasNonStation) {
                        if (ongoingBattle) {
                            this.text.addPara("\u5c3d\u7ba1\u6709\u9632\u5fa1\u8230\u961f\u7684\u5b58\u5728\uff0c\u4f46\u7531\u4e8e\u5b83\u4eec\u6b63\u53c2\u4e0e\u7740\u53e6\u4e00\u573a\u6218\u6597\uff0c\u56e0\u6b64\u4f60\u5927\u53ef\u8d81\u5176\u4e0d\u5907\u6765\u53d1\u52a8\u7a81\u88ad\u3002");
                        } else if (hasOtherButInsignificant) {
                            this.text.addPara("\u5c3d\u7ba1\u9644\u8fd1\u6709\u9632\u5fa1\u8230\u961f\u7684\u5b58\u5728\uff0c\u4f46\u5b83\u4eec\u6ca1\u6709\u8db3\u591f\u7684\u80fd\u529b\u4e0e\u4f60\u4ea4\u6218\u5e76\u963b\u6b62\u4f60\u53ef\u80fd \u91c7\u53d6\u7684\u4efb\u4f55\u654c\u5bf9\u884c\u52a8\u3002");
                        } else {
                            this.text.addPara("\u5728\u8f68\u9053\u9632\u5fa1\u8bbe\u65bd\u7684\u5e2e\u52a9\u4e0b\uff0c\u4ee5\u73b0\u6709\u7684\u9632\u5fa1\u8230\u961f\u4e5f\u8db3\u4ee5\u9632\u6b62\u7a81\u88ad\u884c\u52a8\u7684\u53d1\u751f\u3002");
                        }
                    }
                } else if (hasNonStation && otherWantsToFight) {
                    this.printStationState();
                    this.text.addPara("\u9632\u5fa1\u8230\u961f\u5c06\u963b\u6b62\u4efb\u4f55\u654c\u5bf9\u884c\u52a8\uff0c\u5fc5\u987b\u6467\u6bc1\u5b83\u4eec\uff0c\u4f60\u624d\u80fd\u6267\u884c\u4e0b\u4e00\u6b65\u884c\u52a8\u3002");
                } else if (hasNonStation && !otherWantsToFight) {
                    this.printStationState();
                    this.text.addPara("\u5c3d\u7ba1\u9644\u8fd1\u6709\u9632\u5fa1\u8230\u961f\u7684\u5b58\u5728\uff0c\u4f46\u5b83\u4eec\u6ca1\u6709\u8db3\u591f\u7684\u80fd\u529b\u4e0e\u4f60\u4ea4\u6218\u5e76\u963b\u6b62\u4f60\u53ef\u80fd \u91c7\u53d6\u7684\u4efb\u4f55\u654c\u5bf9\u884c\u52a8\u3002");
                }
                plugin.printOngoingBattleInfo();
            }
        }
        if (!hasNonStation) {
            hasOtherButInsignificant = false;
        }
        this.options.clearOptions();
        String engageText = "\u653b\u51fb\u9632\u5fa1\u8230\u961f";
        engageText = playerCanNotJoin ? "\u653b\u51fb\u9632\u5fa1\u8230\u961f" : (playerOnDefenderSide ? (hasStation && hasNonStation ? "\u5e2e\u52a9\u8be5 " + stationType + " \u4ee5\u53ca\u5b83\u7684\u9632\u5fa1\u8230\u961f" : (hasStation ? "\u5e2e\u52a9\u8be5 " + stationType : "\u63f4\u52a9\u9632\u5fa1\u8230\u961f")) : (ongoingBattle ? "\u534f\u52a9\u8fdb\u653b\u90e8\u961f" : (hasStation && hasNonStation ? "\u653b\u51fb " + stationType + " \u4ee5\u53ca\u5b83\u7684\u9632\u5fa1\u8230\u961f" : (hasStation ? "\u653b\u51fb " + stationType : "\u653b\u51fb\u9632\u5fa1\u8230\u961f"))));
        this.options.addOption(engageText, ENGAGE);
        this.temp.secret = false;
        this.temp.canRaid = ongoingBattle || hasOtherButInsignificant || hasNonStation && !otherWantsToFight || !hasNonStation;
        this.temp.canBombard = (hasOtherButInsignificant || hasNonStation && !otherWantsToFight || !hasNonStation) && !hasStation;
        boolean couldRaidIfNotDebug = this.temp.canRaid;
        if (DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            if (!this.temp.canRaid || !this.temp.canBombard) {
                this.text.addPara("(DEBUG mode: can raid and bombard anyway)");
            }
            this.temp.canRaid = true;
            this.temp.canBombard = true;
        }
        this.options.addOption("\u51c6\u5907\u7a81\u88ad " + this.market.getName(), RAID);
        this.options.addOption("\u51c6\u5907\u8f68\u9053\u8f70\u70b8 " + this.market.getName(), BOMBARD);
        if (!this.temp.canRaid) {
            this.options.setEnabled(RAID, false);
            this.options.setTooltip(RAID, "\u76ee\u6807\u9644\u8fd1\u5b58\u5728\u654c\u65b9\u8230\u961f\uff0c\u5bfc\u81f4\u65e0\u6cd5\u8fdb\u884c\u7a81\u88ad\u3002");
        }
        if (!this.temp.canBombard) {
            this.options.setEnabled(BOMBARD, false);
            this.options.setTooltip(BOMBARD, "\u60f3\u8981\u6267\u884c\u8f68\u9053\u8f70\u70b8\uff0c\u5c31\u5fc5\u987b\u6467\u6bc1\u6240\u6709\u9632\u5fa1\u8bbe\u65bd\u3002");
        }
        if (this.temp.canRaid && this.getRaidCooldown() > 0.0f) {
            if (!DebugFlags.MARKET_HOSTILITIES_DEBUG) {
                this.options.setEnabled(RAID, false);
                this.text.addPara("\u4f60\u7684\u90e8\u961f\u9700\u6574\u987f\u4e00\u5929\u7684\u65f6\u95f4\uff0c\u624d\u80fd\u91cd\u65b0\u7ec4\u7ec7\u53e6\u4e00\u6b21\u7a81\u88ad\u3002");
                this.temp.canRaid = false;
            } else {
                this.text.addPara("\u4f60\u7684\u90e8\u961f\u9700\u6574\u987f\u4e00\u5929\u7684\u65f6\u95f4\uff0c\u624d\u80fd\u91cd\u65b0\u7ec4\u7ec7\u53e6\u4e00\u6b21\u7a81\u88ad\u3002");
                this.text.addPara("(DEBUG mode: can do it anyway)");
            }
        }
        if (context != null && otherWantsToFight && !playerCanNotJoin) {
            boolean knows = context.getBattle() != null && context.getBattle().getNonPlayerSide() != null && context.getBattle().knowsWhoPlayerIs(context.getBattle().getNonPlayerSide());
            boolean lowImpact = context.isLowRepImpact();
            FactionAPI nonHostile = plugin.getNonHostileOtherFaction();
            if (nonHostile != null && knows && !lowImpact && !context.isEngagedInHostilities()) {
                this.options.addOptionConfirmation(ENGAGE, "\u8be5 " + nonHostile.getDisplayNameLong() + " " + nonHostile.getDisplayNameIsOrAre() + "\u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u5e76\u4e14\u4f60\u7684\u8eab\u4efd\u5df2\u88ab\u5bf9\u65b9\u77e5\u6653\u3002" + "\u4f60\u786e\u5b9a\u8981\u4e0e\u5176\u516c\u5f00\u654c\u5bf9\u5417\uff1f", "\u662f\u7684", "\u653e\u5f03");
            }
        } else if (context == null || playerCanNotJoin || !otherWantsToFight) {
            this.options.setEnabled(ENGAGE, false);
            if (!otherWantsToFight) {
                if (ongoingBattle && playerOnDefenderSide && !otherWantsToFight) {
                    this.options.setTooltip(ENGAGE, "\u7531\u4e8e\u88ad\u51fb\u8005\u81ea\u4e71\u9635\u811a\uff0c\u6240\u4ee5\u76ee\u524d\u672a\u4e0e\u7a7a\u95f4\u7ad9\u8fdb\u884c\u4ea4\u6218\u3002");
                } else if (playerCanNotJoin) {
                    this.options.setTooltip(ENGAGE, "\u4f60\u65e0\u6cd5\u53c2\u52a0\u8fd9\u6b21\u6218\u6597\u3002");
                } else if (primary == null) {
                    this.options.setTooltip(ENGAGE, "\u6ca1\u6709\u53ef\u53c2\u4e0e\u6218\u6597\u7684\u5b88\u519b\u3002");
                } else {
                    this.options.setTooltip(ENGAGE, "\u5b88\u519b\u62d2\u7edd\u4e3a\u4fdd\u536b\u6b96\u6c11\u5730\u800c\u732e\u8eab\u6218\u6597\u3002");
                }
            }
        }
        this.options.addOption("\u8fd4\u56de", GO_BACK);
        this.options.setShortcut(GO_BACK, 1, false, false, false, true);
        if (plugin != null) {
            plugin.cleanUpBattle();
        }
    }

    public static float getRaidStr(CampaignFleetAPI fleet) {
        float attackerStr = fleet.getCargo().getMaxPersonnel() * 0.25f;
        float support = Misc.getFleetwideTotalMod(fleet, "ground_support", 0.0f);
        attackerStr += Math.min(support, attackerStr);
        StatBonus stat = fleet.getStats().getDynamic().getMod("ground_attack_mod");
        attackerStr = stat.computeEffective(attackerStr);
        return attackerStr;
    }

    public static float getDefenderStr(MarketAPI market) {
        return MarketCMD.getDefenderStr(market, false);
    }

    public static float getDefenderStr(MarketAPI market, boolean forBombard) {
        StatBonus stat = market.getStats().getDynamic().getMod("ground_defenses_mod");
        float defenderStr = Math.round(stat.computeEffective(0.0f));
        float added = MarketCMD.getDefenderIncreaseValue(market);
        defenderStr += added;
        if (market.isPlayerOwned() && !forBombard) {
            float marineDefenseValueMult = MARINES_IN_MARKET_CARGO_DEFENSE_BONUS;
            CargoAPI cargo = Misc.getStorageCargo(market);
            if (cargo != null) {
                defenderStr += (float)cargo.getMarines() * marineDefenseValueMult;
            }
            if ((cargo = Misc.getLocalResourcesCargo(market)) != null) {
                defenderStr += (float)cargo.getMarines() * marineDefenseValueMult;
            }
        }
        return defenderStr;
    }

    public static float getRaidEffectiveness(MarketAPI market, CampaignFleetAPI fleet) {
        return MarketCMD.getRaidEffectiveness(market, MarketCMD.getRaidStr(fleet));
    }

    public static float getRaidEffectiveness(MarketAPI market, float attackerStr) {
        float defenderStr = MarketCMD.getDefenderStr(market);
        return attackerStr / Math.max(1.0f, attackerStr + defenderStr);
    }

    public static int getMarinesFor(MarketAPI market, int tokens) {
        float defenderStr = MarketCMD.getDefenderStr(market);
        return MarketCMD.getMarinesFor((int)defenderStr, tokens);
    }

    public static int getMarinesFor(int defenderStrength, int tokens) {
        int marines = Math.round((float)tokens * RE_PER_MARINE_TOKEN * (float)defenderStrength / (1.0f - (float)tokens * RE_PER_MARINE_TOKEN));
        return marines;
    }

    public static int getDisruptDaysPerToken(MarketAPI market, Industry industry) {
        DisruptIndustryRaidObjectivePluginImpl obj = new DisruptIndustryRaidObjectivePluginImpl(market, industry);
        return Math.round(obj.getBaseDisruptDuration(1));
    }

    protected void raidNonMarket() {
        float width = 350.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        this.temp.nonMarket = true;
        float difficulty = this.memory.getFloat("$raidDifficulty");
        this.temp.raidGoBackTrigger = this.memory.getString("$raidGoBackTrigger");
        this.temp.raidContinueTrigger = this.memory.getString("$raidContinueTrigger");
        this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_prepare", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        float marines = this.playerFleet.getCargo().getMarines();
        float support = Misc.getFleetwideTotalMod(this.playerFleet, "ground_support", 0.0f);
        if (support > marines) {
            support = marines;
        }
        StatBonus attackerBase = new StatBonus();
        StatBonus defenderBase = new StatBonus();
        attackerBase.modifyFlatAlways("core_marines", marines, "\u5f85\u547d\u4e2d\u7684\u9646\u6218\u961f\u5458");
        attackerBase.modifyFlatAlways("core_support", support, "\u8230\u961f\u5730\u9762\u652f\u63f4\u80fd\u529b");
        StatBonus attacker = this.playerFleet.getStats().getDynamic().getMod("ground_attack_mod");
        StatBonus defender = new StatBonus();
        if (this.market != null && difficulty <= 0.0f) {
            defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        }
        defender.modifyFlat("difficulty", difficulty, "\u9884\u8ba1\u963b\u529b");
        String surpriseKey = "core_surprise";
        String increasedDefensesKey = "core_addedDefStr";
        float added = 0.0f;
        if (this.market != null) {
            added = MarketCMD.getDefenderIncreaseValue(this.market);
        }
        if (added > 0.0f) {
            defender.modifyFlat(increasedDefensesKey, added, "\u63d0\u9ad8\u9632\u5fa1\u80fd\u529b");
        }
        float attackerStr = Math.round(attacker.computeEffective(attackerBase.computeEffective(0.0f)));
        float defenderStr = Math.round(defender.computeEffective(defenderBase.computeEffective(0.0f)));
        this.temp.attackerStr = attackerStr;
        this.temp.defenderStr = defenderStr;
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        String has = this.faction.getDisplayNameHasOrHave();
        String is = this.faction.getDisplayNameIsOrAre();
        boolean hostile = this.faction.isHostileTo("player");
        boolean tOn = this.playerFleet.isTransponderOn();
        float initPad = 0.0f;
        if (!hostile && !this.faction.isNeutralFaction()) {
            if (tOn) {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + "\u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u4f46\u7531\u4e8e\u4f60\u7684\u8230\u961f\u5e94\u7b54\u5668\u5904\u4e8e\u5f00\u542f\u72b6\u6001\uff0c" + "\u6240\u4ee5\u6b64\u65f6\u53d1\u52a8\u7a81\u88ad\u5c06\u610f\u5473\u7740\u516c\u5f00\u4ea4\u6218\u3002", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + "\u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u4f46\u7531\u4e8e\u4f60\u7684\u8230\u961f\u5e94\u7b54\u5668\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c" + "\u6240\u4ee5\u6b64\u65f6\u53d1\u52a8\u7a81\u88ad\u53ea\u4f1a\u5bf9\u4f60\u7684\u58f0\u8a89\u9020\u6210\u8f7b\u5fae\u7684\u60e9\u7f5a\u3002", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            }
            initPad = opad;
        }
        float sep = small;
        sep = 3.0f;
        info.addPara("\u7a81\u88ad\u6218\u529b\uff1a%s", initPad, h, "" + (int)attackerStr);
        info.addStatModGrid(width, 50.0f, opad, small, attackerBase, true, MarketCMD.statPrinter(false));
        if (!attacker.isUnmodified()) {
            info.addStatModGrid(width, 50.0f, opad, sep, attacker, true, MarketCMD.statPrinter(true));
        }
        info.addPara("\u884c\u52a8\u96be\u5ea6\uff1a%s", opad, h, "" + (int)defenderStr);
        info.addStatModGrid(width, 50.0f, opad, small, defender, true, MarketCMD.statPrinter(true));
        defender.unmodifyFlat(increasedDefensesKey);
        defender.unmodifyMult(surpriseKey);
        attacker.unmodifyMult(surpriseKey);
        this.text.addTooltip();
        boolean hasForces = true;
        this.temp.raidMult = attackerStr / Math.max(1.0f, attackerStr + defenderStr);
        this.temp.raidMult = (float)Math.round(this.temp.raidMult * 100.0f) / 100.0f;
        Color eColor = h;
        if (this.temp.raidMult < DISRUPTION_THRESHOLD && this.temp.raidMult < VALUABLES_THRESHOLD) {
            eColor = Misc.getNegativeHighlightColor();
        }
        this.text.addPara("\u9884\u8ba1\u7a81\u88ad\u6548\u679c\uff1a%s", eColor, (int)(this.temp.raidMult * 100.0f) + "%");
        if (this.temp.raidMult < VALUABLES_THRESHOLD) {
            this.text.addPara("\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u6218\u529b\u8fdb\u884c\u7a81\u88ad\u3002");
            hasForces = false;
        }
        this.options.clearOptions();
        this.options.addOption("\u6307\u5b9a\u7a81\u88ad\u76ee\u6807", RAID_VALUABLE);
        if (!hasForces) {
            this.options.setEnabled(RAID_VALUABLE, false);
        }
        this.options.addOption("\u8fd4\u56de", RAID_GO_BACK);
        this.options.setShortcut(RAID_GO_BACK, 1, false, false, false, true);
    }

    protected void raidMenu() {
        float width = 350.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        this.temp.nonMarket = false;
        this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_prepare", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        float marines = this.playerFleet.getCargo().getMarines();
        float support = Misc.getFleetwideTotalMod(this.playerFleet, "ground_support", 0.0f);
        if (support > marines) {
            support = marines;
        }
        StatBonus attackerBase = new StatBonus();
        StatBonus defenderBase = new StatBonus();
        attackerBase.modifyFlatAlways("core_marines", marines, "\u5f85\u547d\u4e2d\u7684\u9646\u6218\u961f\u5458");
        attackerBase.modifyFlatAlways("core_support", support, "\u8230\u961f\u5730\u9762\u652f\u63f4\u80fd\u529b");
        StatBonus attacker = this.playerFleet.getStats().getDynamic().getMod("ground_attack_mod");
        StatBonus defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        String surpriseKey = "core_surprise";
        String increasedDefensesKey = "core_addedDefStr";
        float added = MarketCMD.getDefenderIncreaseValue(this.market);
        if (added > 0.0f) {
            defender.modifyFlat(increasedDefensesKey, added, "\u63d0\u9ad8\u9632\u5fa1\u80fd\u529b");
        }
        float attackerStr = Math.round(attacker.computeEffective(attackerBase.computeEffective(0.0f)));
        float defenderStr = Math.round(defender.computeEffective(defenderBase.computeEffective(0.0f)));
        this.temp.attackerStr = attackerStr;
        this.temp.defenderStr = defenderStr;
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        String has = this.faction.getDisplayNameHasOrHave();
        String is = this.faction.getDisplayNameIsOrAre();
        boolean hostile = this.faction.isHostileTo("player");
        boolean tOn = this.playerFleet.isTransponderOn();
        float initPad = 0.0f;
        if (!hostile) {
            if (tOn) {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + "\u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u4f46\u7531\u4e8e\u4f60\u7684\u8230\u961f\u5e94\u7b54\u5668\u5904\u4e8e\u5f00\u542f\u72b6\u6001\uff0c" + "\u6240\u4ee5\u6b64\u65f6\u53d1\u52a8\u7a81\u88ad\u5c06\u610f\u5473\u7740\u516c\u5f00\u4ea4\u6218\u3002", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            } else {
                info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + "\u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u4f46\u7531\u4e8e\u4f60\u7684\u8230\u961f\u5e94\u7b54\u5668\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c" + "\u6240\u4ee5\u6b64\u65f6\u53d1\u52a8\u7a81\u88ad\u53ea\u4f1a\u5bf9\u4f60\u7684\u58f0\u8a89\u9020\u6210\u8f7b\u5fae\u7684\u60e9\u7f5a\u3002", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            }
            initPad = opad;
        }
        float sep = small;
        sep = 3.0f;
        info.addPara("\u7a81\u88ad\u6218\u529b\uff1a%s", initPad, h, "" + (int)attackerStr);
        info.addStatModGrid(width, 50.0f, opad, small, attackerBase, true, MarketCMD.statPrinter(false));
        if (!attacker.isUnmodified()) {
            info.addStatModGrid(width, 50.0f, opad, sep, attacker, true, MarketCMD.statPrinter(true));
        }
        info.addPara("\u5730\u9762\u9632\u5fa1\u6218\u529b\uff1a%s", opad, h, "" + (int)defenderStr);
        info.addStatModGrid(width, 50.0f, opad, small, defender, true, MarketCMD.statPrinter(true));
        defender.unmodifyFlat(increasedDefensesKey);
        defender.unmodifyMult(surpriseKey);
        attacker.unmodifyMult(surpriseKey);
        this.text.addTooltip();
        boolean hasForces = true;
        boolean canDisrupt = true;
        this.temp.raidMult = attackerStr / Math.max(1.0f, attackerStr + defenderStr);
        this.temp.raidMult = (float)Math.round(this.temp.raidMult * 100.0f) / 100.0f;
        Color eColor = h;
        if (this.temp.raidMult < DISRUPTION_THRESHOLD && this.temp.raidMult < VALUABLES_THRESHOLD) {
            eColor = Misc.getNegativeHighlightColor();
        }
        if (this.temp.raidMult < DISRUPTION_THRESHOLD) {
            canDisrupt = false;
        } else {
            float cfr_ignored_0 = this.temp.raidMult;
        }
        this.text.addPara("\u9884\u8ba1\u7a81\u88ad\u6548\u679c\uff1a%s", eColor, (int)(this.temp.raidMult * 100.0f) + "%");
        if (!canDisrupt) {
            this.text.addPara("\u7531\u4e8e\u76ee\u6807\u5730\u9762\u9632\u5fa1\u8fc7\u4e8e\u5f3a\u5927\uff0c\u81f4\u4f60\u7684\u90e8\u961f\u65e0\u6cd5\u9020\u6210\u6709\u6548\u7834\u574f\u3002");
        }
        if (this.temp.raidMult < VALUABLES_THRESHOLD) {
            this.text.addPara("\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u6218\u529b\u6765\u63a0\u593a\u8d35\u91cd\u7269\u54c1\u6216\u8fbe\u6210\u5176\u4ed6\u76ee\u6807\u3002");
            hasForces = false;
        }
        if (DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            canDisrupt = true;
        }
        this.options.clearOptions();
        this.options.addOption("\u8bd5\u56fe\u63a0\u593a\u8d35\u91cd\u7269\u54c1\uff0c\u5982\u5927\u5b97\u5546\u54c1\u3001\u84dd\u56fe\u6216\u8fbe\u6210\u5176\u4ed6\u76ee\u6807", RAID_VALUABLE);
        this.options.addOption("\u762b\u75ea\u7279\u5b9a\u5de5\u4e1a\u8bbe\u65bd\u4ee5\u53ca\u5176\u4ed6\u8bbe\u65bd\u7684\u6b63\u5e38\u8fd0\u4f5c", RAID_DISRUPT);
        if (!hasForces) {
            this.options.setEnabled(RAID_VALUABLE, false);
        }
        if (!hasForces || !canDisrupt) {
            this.options.setEnabled(RAID_DISRUPT, false);
            if (!canDisrupt) {
                String pct = Math.round(DISRUPTION_THRESHOLD * 100.0f) + "%";
                this.options.setTooltip(RAID_DISRUPT, "\u7a81\u88ad\u6548\u679c\u81f3\u5c11\u9700\u8981 " + pct + " \u4ee5\u4e0a\u624d\u80fd\u8fdb\u884c\u7a81\u88ad\u3002");
                this.options.setTooltipHighlights(RAID_DISRUPT, pct);
                this.options.setTooltipHighlightColors(RAID_DISRUPT, h);
            }
        }
        this.options.addOption("\u8fd4\u56de", RAID_GO_BACK);
        this.options.setShortcut(RAID_GO_BACK, 1, false, false, false, true);
    }

    protected void raidValuable() {
        this.temp.raidType = RaidType.VALUABLE;
        ArrayList<GroundRaidObjectivePlugin> obj = new ArrayList<GroundRaidObjectivePlugin>();
        final RaidType useType = !this.temp.nonMarket ? this.temp.raidType : RaidType.CUSTOM_ONLY;
        int i = 0;
        while (i < 10) {
            ListenerUtil.modifyRaidObjectives(this.market, this.entity, obj, useType, this.getNumMarineTokens(), i);
            ++i;
        }
        if (obj.isEmpty()) {
            this.text.addPara("\u7ecf\u8fc7\u4ed4\u7ec6\u8003\u8651\uff0c\u4f3c\u4e4e\u6ca1\u6709\u4efb\u4f55\u6709\u4ef7\u503c\u7684\u76ee\u6807\u662f\u503c\u5f97\u7834\u574f\u7684\u3002");
            this.addNeverMindOption();
            return;
        }
        this.dialog.showGroundRaidTargetPicker("\u9009\u62e9\u7a81\u88ad\u76ee\u6807", "\u51c6\u5907", this.market, obj, new GroundRaidTargetPickerDelegate(){

            @Override
            public void pickedGroundRaidTargets(List<GroundRaidObjectivePlugin> data) {
                float value = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    value += (float)curr.getProjectedCreditsValue();
                }
                Color h = Misc.getHighlightColor();
                ArrayList<String> names = new ArrayList<String>();
                for (GroundRaidObjectivePlugin curr : data) {
                    names.add(curr.getNameOverride() != null ? curr.getNameOverride() : curr.getName());
                }
                String list = Misc.getAndJoined(names);
                String item = "\u9488\u5bf9";
                if (names.size() > 1) {
                    item = "objectives";
                }
                String isOrAre = "\u800c";
                String marinesStr = "\u9646\u6218\u961f\u5458";
                if (MarketCMD.this.playerCargo.getMarines() == 1) {
                    isOrAre = "\u800c";
                    marinesStr = "\u9646\u6218\u961f\u5458";
                }
                LabelAPI label = MarketCMD.this.text.addPara("\u4f60\u7684\u9646\u6218\u961f\u6307\u6325\u5b98\u63d0\u4ea4\u4e86\u4e00\u4efd\u8ba1\u5212\u4f9b\u4f60\u6279\u51c6\u3002\u6b64\u6b21\u884c\u52a8\u671f\u95f4\u7684\u635f\u5931\u9884\u8ba1\u4e3a %s}\u3002" + isOrAre + "\u4f60\u7684\u8230\u961f\u4e2d\u4e00\u5171\u6709 %s \u540d " + marinesStr + "\u5728\u4f60\u7684\u8230\u961f\u4e2d\u3002", this.getMarineLossesColor(data), this.getProjectedMarineLosses(data).toLowerCase(), Misc.getWithDGS(MarketCMD.this.playerCargo.getMarines()));
                label.setHighlightColors(this.getMarineLossesColor(data), Misc.getHighlightColor());
                MarketCMD.this.text.addPara(String.valueOf(Misc.ucFirst(item)) + "\u76ee\u6807\uff1a" + list + "\u3002", h, names.toArray(new String[0]));
                if (value > 0.0f) {
                    MarketCMD.this.text.addPara("\u9884\u8ba1\u6240\u83b7\u6218\u5229\u54c1\u7684\u4ef7\u503c\u4e3a %s}\u3002", h, Misc.getDGSCredits(value));
                }
                MarketCMD.this.text.addPara("\u9646\u6218\u961f\u5df2\u51c6\u5907\u5c31\u7eea\uff0c\u5e76\u7b49\u5f85\u4f60\u7684\u6700\u7ec8\u786e\u8ba4\u3002");
                MarketCMD.this.temp.objectives = data;
                MarketCMD.this.addConfirmOptions();
            }

            @Override
            public boolean isDisruptIndustryMode() {
                return false;
            }

            @Override
            public boolean isCustomOnlyMode() {
                return useType == RaidType.CUSTOM_ONLY;
            }

            @Override
            public void cancelledGroundRaidTargetPicking() {
            }

            @Override
            public int getCargoSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getCargoSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getFuelSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getFuelSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getProjectedCreditsValue(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getProjectedCreditsValue();
                }
                return (int)total;
            }

            @Override
            public int getNumMarineTokens() {
                return MarketCMD.this.getNumMarineTokens();
            }

            @Override
            public MutableStat getMarineLossesStat(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getMarineLossesStat(data);
            }

            @Override
            public String getProjectedMarineLosses(List<GroundRaidObjectivePlugin> data) {
                float \u9646\u6218\u961f\u5458 = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, \u9646\u6218\u961f\u5458);
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (level == RaidDangerLevel.NONE) {
                        test = RaidDangerLevel.NONE.marineLossesMult;
                    }
                    if (test >= f) {
                        return level.lossesName;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.lossesName;
            }

            @Override
            public float getAverageMarineLosses(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getAverageMarineLosses(data);
            }

            @Override
            public Color getMarineLossesColor(List<GroundRaidObjectivePlugin> data) {
                float \u9646\u6218\u961f\u5458 = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, \u9646\u6218\u961f\u5458);
                if (f <= 0.0f && data.isEmpty()) {
                    return Misc.getGrayColor();
                }
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (test >= f) {
                        return level.color;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.color;
            }

            @Override
            public String getRaidEffectiveness() {
                return (int)(MarketCMD.this.temp.raidMult * 100.0f) + "%";
            }
        });
    }

    protected void addBombardConfirmOptions() {
        this.options.clearOptions();
        this.options.addOption("\u5f00\u59cb\u8f70\u70b8", BOMBARD_CONFIRM);
        this.options.addOption("\u653e\u5f03", BOMBARD_NEVERMIND);
        this.options.setShortcut(BOMBARD_NEVERMIND, 1, false, false, false, true);
        ArrayList<FactionAPI> nonHostile = new ArrayList<FactionAPI>();
        for (FactionAPI faction : this.temp.willBecomeHostile) {
            boolean hostile = faction.isHostileTo("player");
            if (hostile) continue;
            nonHostile.add(faction);
        }
        if (nonHostile.size() == 1) {
            FactionAPI faction;
            faction = (FactionAPI)nonHostile.get(0);
            this.options.addOptionConfirmation(BOMBARD_CONFIRM, "\u8be5 " + faction.getDisplayNameLong() + " " + faction.getDisplayNameIsOrAre() + "\u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u5982\u679c\u5b9e\u65bd\u8f68\u9053\u8f70\u70b8\uff0c\u5c06\u610f\u5473\u7740\u4e0e\u5176\u516c\u5f00\u4ea4\u6218\u3002" + "\u4f60\u786e\u5b9a\u5417\uff1f", "\u662f\u7684", "\u653e\u5f03");
        } else if (nonHostile.size() > 1) {
            this.options.addOptionConfirmation(BOMBARD_CONFIRM, "\u5982\u679c\u8fdb\u884c\u9971\u548c\u8f70\u70b8\uff0c\u90a3\u4e9b\u76ee\u524d\u4e0e\u4f60\u5904\u4e8e\u975e\u654c\u5bf9\u4e0b\u7684\u591a\u4e2a\u52bf\u529b\u5c06\u4f1a\u7acb\u5373\u4e0e\u4f60\u51b3\u88c2\u3002\u4f60\u786e\u5b9a\u5417\uff1f", "\u662f\u7684", "\u653e\u5f03");
        }
    }

    protected void raidDisrupt() {
        this.temp.raidType = RaidType.DISRUPT;
        ArrayList<GroundRaidObjectivePlugin> obj = new ArrayList<GroundRaidObjectivePlugin>();
        int i = 0;
        while (i < 10) {
            ListenerUtil.modifyRaidObjectives(this.market, this.entity, obj, this.temp.raidType, this.getNumMarineTokens(), i);
            ++i;
        }
        if (obj.isEmpty()) {
            this.text.addPara("\u76ee\u524d\u6ca1\u6709\u5de5\u4e1a\u8bbe\u65bd\u4e0e\u5176\u4ed6\u8bbe\u65bd\u4f1a\u88ab\u7a81\u88ad\u6240\u7834\u574f\u3002");
            this.addNeverMindOption();
            return;
        }
        this.dialog.showGroundRaidTargetPicker("\u9009\u62e9\u7a81\u88ad\u76ee\u6807", "\u51c6\u5907", this.market, obj, new GroundRaidTargetPickerDelegate(){

            @Override
            public void pickedGroundRaidTargets(List<GroundRaidObjectivePlugin> data) {
                float value = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    value += (float)curr.getProjectedCreditsValue();
                }
                Color h = Misc.getHighlightColor();
                ArrayList<String> names = new ArrayList<String>();
                for (GroundRaidObjectivePlugin curr : data) {
                    names.add(curr.getNameOverride() != null ? curr.getNameOverride() : curr.getName());
                }
                String list = Misc.getAndJoined(names);
                String item = "\u9488\u5bf9";
                if (names.size() > 1) {
                    item = "objectives";
                }
                MarketCMD.this.text.addPara("\u4f60\u7684\u9646\u6218\u961f\u6307\u6325\u5b98\u63d0\u4ea4\u4e86\u4e00\u4efd\u8ba1\u5212\u4f9b\u4f60\u6279\u51c6\u3002\u6b64\u6b21\u884c\u52a8\u671f\u95f4\u7684\u635f\u5931\u9884\u8ba1\u4e3a %s}\u3002", this.getMarineLossesColor(data), this.getProjectedMarineLosses(data).toLowerCase());
                MarketCMD.this.text.addPara(String.valueOf(Misc.ucFirst(item)) + "\u76ee\u6807\uff1a" + list + "\u3002", h, names.toArray(new String[0]));
                if (value > 0.0f) {
                    MarketCMD.this.text.addPara("\u9884\u8ba1\u6240\u83b7\u6218\u5229\u54c1\u7684\u4ef7\u503c\u4e3a %s.", h, Misc.getDGSCredits(value));
                }
                MarketCMD.this.text.addPara("\u9646\u6218\u961f\u5df2\u51c6\u5907\u5c31\u7eea\uff0c\u5e76\u7b49\u5f85\u4f60\u7684\u6700\u7ec8\u786e\u8ba4\u3002\u4f60\u76ee\u524d\u5171\u6709 %s \u540d\u9646\u6218\u961f\u5458\u3002", Misc.getHighlightColor(), Misc.getWithDGS(MarketCMD.this.playerCargo.getMarines()));
                MarketCMD.this.temp.objectives = data;
                MarketCMD.this.addConfirmOptions();
            }

            @Override
            public boolean isDisruptIndustryMode() {
                return true;
            }

            @Override
            public void cancelledGroundRaidTargetPicking() {
            }

            @Override
            public int getCargoSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getCargoSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getFuelSpaceNeeded(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getFuelSpaceNeeded();
                }
                return (int)total;
            }

            @Override
            public int getProjectedCreditsValue(List<GroundRaidObjectivePlugin> data) {
                float total = 0.0f;
                for (GroundRaidObjectivePlugin curr : data) {
                    total += (float)curr.getProjectedCreditsValue();
                }
                return (int)total;
            }

            @Override
            public int getNumMarineTokens() {
                return MarketCMD.this.getNumMarineTokens();
            }

            @Override
            public MutableStat getMarineLossesStat(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getMarineLossesStat(data);
            }

            @Override
            public String getProjectedMarineLosses(List<GroundRaidObjectivePlugin> data) {
                float marines = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, marines);
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (level == RaidDangerLevel.NONE) {
                        test = RaidDangerLevel.NONE.marineLossesMult;
                    }
                    if (test >= f) {
                        return level.lossesName;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.lossesName;
            }

            @Override
            public float getAverageMarineLosses(List<GroundRaidObjectivePlugin> data) {
                return MarketCMD.this.getAverageMarineLosses(data);
            }

            @Override
            public Color getMarineLossesColor(List<GroundRaidObjectivePlugin> data) {
                float marines = MarketCMD.this.playerFleet.getCargo().getMarines();
                float losses = this.getAverageMarineLosses(data);
                float f = losses / Math.max(1.0f, marines);
                if (f <= 0.0f) {
                    return Misc.getGrayColor();
                }
                RaidDangerLevel[] raidDangerLevelArray = RaidDangerLevel.values();
                int n = raidDangerLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RaidDangerLevel level = raidDangerLevelArray[n2];
                    float test = level.marineLossesMult + (level.next().marineLossesMult - level.marineLossesMult) * 0.5f;
                    if (test >= f) {
                        return level.color;
                    }
                    ++n2;
                }
                return RaidDangerLevel.EXTREME.color;
            }

            @Override
            public String getRaidEffectiveness() {
                return (int)(MarketCMD.this.temp.raidMult * 100.0f) + "%";
            }

            @Override
            public boolean isCustomOnlyMode() {
                return false;
            }
        });
    }

    protected float computeBaseDisruptDuration(Industry ind) {
        float dur = (float)this.getNumMarineTokens() * ind.getSpec().getDisruptDanger().disruptionDays - ind.getDisruptedDays();
        return (int)dur;
    }

    public static int getBombardDestroyThreshold() {
        return Global.getSettings().getInt("bombardSaturationDestroySize");
    }

    public static int getBombardDisruptDuration() {
        float dur = Global.getSettings().getFloat("bombardDisruptDuration");
        return (int)dur;
    }

    protected void raidDisruptIndustryPicked(Industry target) {
        this.temp.target = target;
        this.text.addParagraph("\u76ee\u6807\uff1a" + target.getCurrentName(), Global.getSettings().getColor("buttonText"));
        float dur = this.computeBaseDisruptDuration(target);
        Color h = Misc.getHighlightColor();
        float already = target.getDisruptedDays();
        if (already > 0.0f) {
            this.text.addPara(String.valueOf(target.getNameForModifier()) + " \u7531\u4e8e\u76ee\u6807\u5f53\u5730\u8bbe\u65bd\u5df2\u88ab\u762b\u75ea\uff0c\u5bfc\u81f4\u672c\u6b21\u7a81\u88ad\u884c\u52a8\u7684\u6548\u679c" + "\u906d\u5230\u51cf\u5f31\u3002");
        }
        this.text.addPara("\u4f60\u7684\u5730\u9762\u90e8\u961f\u6307\u6325\u5b98\u5728\u8861\u91cf\u4e86\u53cc\u65b9\u90e8\u961f\u5b9e\u529b\u540e\uff0c\u8ba4\u4e3a\u6b64\u6b21\u7a81\u88ad\u4f1a\u762b\u75ea\u4e00\u5207 " + target.getCurrentName() + " \u4e0a\u7684\u8fd0\u4f5c\u81f3\u5c11 %s \u5929\u3002", h, "" + (int)Misc.getRounded(dur));
        this.text.addPara("\u4f60\u7684\u90e8\u961f\u5df2\u7ecf\u51c6\u5907\u5c31\u7eea\uff0c\u6b63\u7b49\u5f85\u4f60\u4e0b\u8fbe\u6700\u540e\u6307\u4ee4\u3002");
        this.options.clearOptions();
        this.addConfirmOptions();
    }

    protected void addNeverMindOption() {
        this.options.clearOptions();
        this.options.addOption("\u653e\u5f03", RAID_NEVER_MIND);
        this.options.setShortcut(RAID_NEVER_MIND, 1, false, false, false, true);
    }

    protected void addBombardNeverMindOption() {
        this.options.clearOptions();
        this.options.addOption("\u653e\u5f03", BOMBARD_NEVERMIND);
        this.options.setShortcut(BOMBARD_NEVERMIND, 1, false, false, false, true);
    }

    protected void addContinueOption() {
        this.addContinueOption(null);
    }

    protected void addContinueOption(String text) {
        if (text == null) {
            text = "\u7ee7\u7eed";
        }
        this.options.clearOptions();
        this.options.addOption(text, RAID_RESULT);
    }

    public static float getDefenderIncreaseRaw(MarketAPI market) {
        if (market == null) {
            return 0.0f;
        }
        float e = market.getMemoryWithoutUpdate().getExpire(DEFENDER_INCREASE_KEY);
        if (e < 0.0f) {
            e = 0.0f;
        }
        return e;
    }

    public static void applyDefenderIncreaseFromRaid(MarketAPI market) {
        float max;
        float e = market.getMemoryWithoutUpdate().getExpire(DEFENDER_INCREASE_KEY);
        if (e < 0.0f) {
            e = 0.0f;
        }
        if ((e += MarketCMD.getRaidDefenderIncreasePerRaid()) > (max = MarketCMD.getRaidDefenderIncreaseMax())) {
            e = max;
        }
        market.getMemoryWithoutUpdate().set(DEFENDER_INCREASE_KEY, true);
        market.getMemoryWithoutUpdate().expire(DEFENDER_INCREASE_KEY, e);
    }

    public static float getDefenderIncreaseValue(MarketAPI market) {
        float e = MarketCMD.getDefenderIncreaseRaw(market);
        float f = MarketCMD.getRaidDefenderIncreaseFraction();
        float min = MarketCMD.getRaidDefenderIncreaseMin();
        float base = PopulationAndInfrastructure.getBaseGroundDefenses(market.getSize());
        float incr = Math.max(base * f, min);
        float per = MarketCMD.getRaidDefenderIncreasePerRaid();
        return (int)(incr * e / per);
    }

    protected static float getRaidDefenderIncreasePerRaid() {
        return Global.getSettings().getFloat("raidDefenderIncreasePerRaid");
    }

    protected static float getRaidDefenderIncreaseMax() {
        return Global.getSettings().getFloat("raidDefenderIncreaseMax");
    }

    protected static float getRaidDefenderIncreaseFraction() {
        return Global.getSettings().getFloat("raidDefenderIncreaseFraction");
    }

    protected static float getRaidDefenderIncreaseMin() {
        return Global.getSettings().getFloat("raidDefenderIncreaseMin");
    }

    protected float getRaidCooldownMax() {
        return Global.getSettings().getFloat("raidCooldownDays");
    }

    protected void setRaidCooldown(float cooldown) {
        String key = "$raid_cooldown";
        Global.getSector().getMemoryWithoutUpdate().set(key, true, cooldown);
    }

    protected float getRaidCooldown() {
        String key = "$raid_cooldown";
        return Global.getSector().getMemoryWithoutUpdate().getExpire(key);
    }

    protected Random getRandom() {
        String key = "$raid_random";
        MemoryAPI mem = null;
        SectorEntityToken entity = null;
        if (this.market != null) {
            mem = this.market.getMemoryWithoutUpdate();
            entity = this.market.getPrimaryEntity();
        } else {
            entity = this.entity;
            mem = entity.getMemoryWithoutUpdate();
        }
        Random random = null;
        if (mem.contains(key)) {
            random = (Random)mem.get(key);
        } else if (entity != null) {
            long seed = Misc.getSalvageSeed(entity);
            seed /= 321L;
            random = new Random(seed *= (long)(Global.getSector().getClock().getMonth() + 10));
        } else {
            random = new Random();
        }
        mem.set(key, random, 30.0f);
        return random;
    }

    public int getNumMarineTokens() {
        int num = Math.round(this.temp.raidMult / RE_PER_MARINE_TOKEN);
        if (num < MIN_MARINE_TOKENS) {
            num = MIN_MARINE_TOKENS;
        }
        if (num > MAX_MARINE_TOKENS) {
            num = MAX_MARINE_TOKENS;
        }
        return num;
    }

    protected MutableStat getMarineLossesStat(List<GroundRaidObjectivePlugin> data) {
        float extra;
        MutableStat stat = new MutableStat(1.0f);
        float total = 0.0f;
        float assignedTokens = 0.0f;
        for (GroundRaidObjectivePlugin curr : data) {
            RaidDangerLevel danger = curr.getDangerLevel();
            total += danger.marineLossesMult * (float)curr.getMarinesAssigned();
            assignedTokens += (float)curr.getMarinesAssigned();
        }
        float danger = total / Math.max(1.0f, assignedTokens);
        float hazard = 1.0f;
        if (this.market != null) {
            hazard = this.market.getHazardValue();
        }
        float reMult = 1.0f;
        if (this.temp.raidMult > MIN_RE_TO_REDUCE_MARINE_LOSSES) {
            extra = (this.temp.raidMult - MIN_RE_TO_REDUCE_MARINE_LOSSES) / (1.0f - MIN_RE_TO_REDUCE_MARINE_LOSSES);
            reMult = extra = MAX_MARINE_LOSS_REDUCTION_MULT + (1.0f - MAX_MARINE_LOSS_REDUCTION_MULT) * (1.0f - extra);
        } else if (this.temp.raidMult < RE_PER_MARINE_TOKEN) {
            reMult = extra = 1.0f + (RE_PER_MARINE_TOKEN - this.temp.raidMult) / RE_PER_MARINE_TOKEN;
        }
        if (this.market != null && reMult < 1.0f) {
            float minMarinesForAssignedTokens = MarketCMD.getMarinesFor(this.market, Math.round(assignedTokens));
            float actualMarines = Global.getSector().getPlayerFleet().getCargo().getMarines();
            if (actualMarines > minMarinesForAssignedTokens && actualMarines > 0.0f) {
                reMult *= 0.5f + 0.5f * minMarinesForAssignedTokens / actualMarines;
            }
        }
        float reservesMult = 1.0f;
        float maxTokens = this.getNumMarineTokens();
        if (maxTokens > assignedTokens) {
            reservesMult = 1.0f - (maxTokens - assignedTokens) * LOSS_REDUCTION_PER_RESERVE_TOKEN;
            reservesMult = Math.max(0.5f, reservesMult);
        }
        float e = MarketCMD.getDefenderIncreaseRaw(this.market);
        float per = MarketCMD.getRaidDefenderIncreasePerRaid();
        float prep = e / per * LOSS_INCREASE_PER_RAID;
        stat.modifyMultAlways("danger", danger, "\u76ee\u6807\u7684\u5371\u9669\u7a0b\u5ea6");
        stat.modifyMult("hazard", hazard, "\u6b96\u6c11\u5730\u5371\u9669\u7b49\u7ea7");
        if (reMult < 1.0f) {
            stat.modifyMultAlways("reMult", reMult, "\u8f83\u9ad8\u7684\u7a81\u88ad\u6548\u7387");
        } else if (reMult > 1.0f) {
            stat.modifyMultAlways("reMult", reMult, "\u8f83\u4f4e\u7684\u7a81\u88ad\u6548\u7387");
        }
        if (reservesMult < 1.0f && assignedTokens > 0.0f) {
            stat.modifyMultAlways("reservesMult", reservesMult, "\u5f85\u547d\u7684\u9884\u5907\u90e8\u961f");
        }
        stat.modifyMult("prep", 1.0f + prep, "\u63d0\u9ad8\u9632\u5fa1\u80fd\u529b");
        stat.applyMods(this.playerFleet.getStats().getDynamic().getStat("ground_attack_casualties_mult"));
        ListenerUtil.modifyMarineLossesStatPreRaid(this.market, data, stat);
        return stat;
    }

    protected float getAverageMarineLosses(List<GroundRaidObjectivePlugin> data) {
        MutableStat stat = this.getMarineLossesStat(data);
        float mult = stat.getModifiedValue();
        if (mult > MAX_MARINE_LOSSES) {
            mult = MAX_MARINE_LOSSES;
        }
        float marines = this.playerFleet.getCargo().getMarines();
        return marines * mult;
    }

    protected void addMilitaryResponse() {
        if (this.market == null) {
            return;
        }
        if (!this.market.getFaction().getCustomBoolean("noWarSim")) {
            MilitaryResponseScript.MilitaryResponseParams params = new MilitaryResponseScript.MilitaryResponseParams(CampaignFleetAIAPI.ActionType.HOSTILE, "player_ground_raid_" + this.market.getId(), this.market.getFaction(), this.market.getPrimaryEntity(), 0.75f, 30.0f);
            this.market.getContainingLocation().addScript(new MilitaryResponseScript(params));
        }
        List<CampaignFleetAPI> fleets = this.market.getContainingLocation().getFleets();
        for (CampaignFleetAPI other : fleets) {
            if (other.getFaction() != this.market.getFaction()) continue;
            MemoryAPI mem = other.getMemoryWithoutUpdate();
            Misc.setFlagWithReason(mem, "$cfai_makeHostileWhileTOff", "raidAlarm", true, 1.0f);
        }
    }

    protected void raidConfirm(boolean secret) {
        if (this.temp.raidType == null) {
            this.raidNeverMind();
            return;
        }
        this.temp.secret = secret;
        Random random = this.getRandom();
        if (!DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            Misc.increaseMarketHostileTimeout(this.market, HOSTILE_ACTIONS_TIMEOUT_DAYS);
        }
        this.addMilitaryResponse();
        this.setRaidCooldown(this.getRaidCooldownMax());
        int stabilityPenalty = 0;
        if (!this.temp.nonMarket) {
            String reason = "\u8fd1\u671f\u906d\u5230\u7a81\u88ad";
            if (Misc.isPlayerFactionSetUp()) {
                reason = String.valueOf(this.playerFaction.getDisplayName()) + " \u7a81\u88ad";
            }
            float raidMultForStabilityPenalty = this.temp.raidMult;
            if (this.temp.objectives != null) {
                float assignedTokens = 0.0f;
                for (GroundRaidObjectivePlugin curr : this.temp.objectives) {
                    assignedTokens += (float)curr.getMarinesAssigned();
                }
                raidMultForStabilityPenalty = assignedTokens * 0.1f;
            }
            stabilityPenalty = MarketCMD.applyRaidStabiltyPenalty(this.market, reason, raidMultForStabilityPenalty);
            Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", "player", true, 30.0f);
            Misc.setRaidedTimestamp(this.market);
        }
        int marines = this.playerFleet.getCargo().getMarines();
        float probOfLosses = 1.0f;
        int losses = 0;
        if (random.nextFloat() < probOfLosses) {
            float variance;
            float averageLosses = this.getAverageMarineLosses(this.temp.objectives);
            float randomizedLosses = StarSystemGenerator.getNormalRandom(random, averageLosses - (variance = averageLosses / 4.0f), averageLosses + variance);
            if (randomizedLosses < 1.0f) {
                float f = randomizedLosses = random.nextFloat() < randomizedLosses ? 1.0f : 0.0f;
            }
            if ((losses = (int)(randomizedLosses = (float)Math.round(randomizedLosses))) < 0) {
                losses = 0;
            }
            if (losses > marines) {
                losses = marines;
            }
        }
        if (losses <= 0) {
            this.text.addPara("\u4f60\u7684\u90e8\u961f\u6ca1\u6709\u4efb\u4f55\u4f24\u4ea1\u3002");
            this.temp.marinesLost = 0;
        } else {
            this.text.addPara("\u4f60\u7684\u90e8\u961f\u5728\u7a81\u88ad\u4e2d\u7684\u4f24\u4ea1\u62a5\u544a\u3002", Misc.getHighlightColor(), "" + losses);
            this.playerFleet.getCargo().removeMarines(losses);
            this.temp.marinesLost = losses;
            AddRemoveCommodity.addCommodityLossText("marines", losses, this.text);
        }
        if (!secret) {
            boolean tOn = this.playerFleet.isTransponderOn();
            boolean hostile = this.faction.isHostileTo("player");
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = this.market != null ? (float)this.market.getSize() * -0.01f * 1.0f : -0.01f;
            if (!hostile && tOn) {
                impact.ensureAtBest = RepLevel.HOSTILE;
            }
            if (impact.delta != 0.0f && !this.faction.isNeutralFaction()) {
                Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.text, true, true), this.faction.getId());
            }
        }
        if (stabilityPenalty > 0) {
            this.text.addPara("\u8be5 " + this.market.getName() + " \u7684\u7a33\u5b9a\u6027\u964d\u4f4e\u4e86 %s \u70b9\u3002", Misc.getHighlightColor(), "" + stabilityPenalty);
        }
        CargoAPI result = this.performRaid(random, this.temp.raidMult);
        if (this.market != null) {
            this.market.reapplyIndustries();
        }
        result.sort();
        result.updateSpaceUsed();
        this.temp.raidLoot = result;
        if (this.temp.xpGained > 0) {
            Global.getSector().getPlayerStats().addXP(this.temp.xpGained, this.dialog.getTextPanel());
        }
        if (this.temp.raidType == RaidType.VALUABLE) {
            if ((float)result.getTotalCrew() + result.getSpaceUsed() + result.getFuel() < 10.0f) {
                this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_covert_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
            } else {
                this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_valuables_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
            }
        } else if (this.temp.raidType == RaidType.DISRUPT) {
            this.dialog.getVisualPanel().showImagePortion("illustrations", "raid_disrupt_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        }
        boolean withContinue = false;
        for (GroundRaidObjectivePlugin curr : this.temp.objectives) {
            if (!curr.withContinueBeforeResult()) continue;
            withContinue = true;
            break;
        }
        if (this.market != null) {
            MarketCMD.applyDefenderIncreaseFromRaid(this.market);
        }
        if (withContinue) {
            this.options.clearOptions();
            this.options.addOption("\u7ee7\u7eed", RAID_CONFIRM_CONTINUE);
        } else {
            this.raidConfirmContinue();
        }
    }

    public void raidConfirmContinue() {
        int raidCredits;
        String contText = null;
        RaidType cfr_ignored_0 = this.temp.raidType;
        if (!this.temp.nonMarket) {
            RaidType cfr_ignored_1 = this.temp.raidType;
        }
        if ((raidCredits = (int)this.temp.raidLoot.getCredits().get()) < 0) {
            raidCredits = 0;
        }
        if (raidCredits > 0) {
            AddRemoveCommodity.addCreditsGainText(raidCredits, this.text);
            this.playerFleet.getCargo().getCredits().add(raidCredits);
        }
        if (!this.temp.raidLoot.isEmpty()) {
            contText = "\u6311\u9009\u6218\u5229\u54c1";
        }
        this.temp.contText = contText;
        float assignedTokens = 0.0f;
        ArrayList<Industry> disrupted = new ArrayList<Industry>();
        for (GroundRaidObjectivePlugin curr : this.temp.objectives) {
            assignedTokens += (float)curr.getMarinesAssigned();
            if (!(curr instanceof DisruptIndustryRaidObjectivePluginImpl) || curr.getSource() == null) continue;
            disrupted.add(curr.getSource());
        }
        GroundRaidObjectivesListener.RaidResultData data = new GroundRaidObjectivesListener.RaidResultData();
        data.market = this.market;
        data.entity = this.entity;
        data.objectives = this.temp.objectives;
        data.type = this.temp.raidType;
        data.raidEffectiveness = this.temp.raidMult;
        data.xpGained = this.temp.xpGained;
        data.marinesTokensInReserve = Math.round((float)this.getNumMarineTokens() - assignedTokens);
        data.marinesTokens = this.getNumMarineTokens();
        data.marinesLost = this.temp.marinesLost;
        ListenerUtil.reportRaidObjectivesAchieved(data, this.dialog, this.memoryMap);
        if (this.temp.raidType == RaidType.VALUABLE) {
            ListenerUtil.reportRaidForValuablesFinishedBeforeCargoShown(this.dialog, this.market, this.temp, this.temp.raidLoot);
        } else if (this.temp.raidType == RaidType.DISRUPT) {
            for (Industry curr : disrupted) {
                ListenerUtil.reportRaidToDisruptFinished(this.dialog, this.market, this.temp, curr);
            }
        }
        Global.getSoundPlayer().playUISound("ui_raid_finished", 1.0f, 1.0f);
        FireBest.fire(null, this.dialog, this.memoryMap, "PostGroundRaid");
    }

    protected CargoAPI performRaid(Random random, float raidEffectiveness) {
        CargoAPI result = Global.getFactory().createCargo(true);
        float leftoverRE = Math.round(raidEffectiveness * 100.0f) % Math.round(RE_PER_MARINE_TOKEN * 100.0f);
        leftoverRE /= 100.0f;
        if (raidEffectiveness < RE_PER_MARINE_TOKEN) {
            leftoverRE = 0.0f;
        }
        long baseSeed = random.nextLong();
        int xp = 0;
        for (GroundRaidObjectivePlugin plugin : this.temp.objectives) {
            float lootMult = 1.0f + leftoverRE / Math.max(RE_PER_MARINE_TOKEN, raidEffectiveness);
            Random curr = new Random(Misc.seedUniquifier() ^ baseSeed * (long)plugin.getClass().getName().hashCode());
            xp += plugin.performRaid(result, curr, lootMult, this.dialog.getTextPanel());
        }
        this.temp.xpGained = xp;
        return result;
    }

    protected void raidNeverMind() {
        if (this.temp.nonMarket) {
            this.raidNonMarket();
        } else {
            this.raidMenu();
        }
    }

    protected void raidShowLoot() {
        this.dialog.getVisualPanel().showLoot("\u6218\u5229\u54c1", this.temp.raidLoot, false, true, true, new CoreInteractionListener(){

            public void coreUIDismissed() {
                MarketCMD.this.finishedRaidOrBombard();
            }
        });
    }

    protected void printStationState() {
        StationState state = this.getStationState();
        if (state == StationState.REPAIRS || state == StationState.UNDER_CONSTRUCTION) {
            FleetMemberAPI flagship;
            CampaignFleetAPI fleet = Misc.getStationBaseFleet(this.market);
            String name = "\u8f68\u9053\u7ad9";
            if (fleet != null && (flagship = fleet.getFlagship()) != null) {
                name = flagship.getVariant().getDesignation().toLowerCase();
            }
            if (state == StationState.REPAIRS) {
                this.text.addPara("\u8be5 " + name + " \u7531\u4e8e\u906d\u53d7\u4e86\u5927\u5e45\u5ea6\u7684\u7834\u574f\uff0c\u76ee\u524d\u5df2\u7ecf\u5b8c\u5168\u4e27\u5931\u4e86\u6218\u6597\u80fd\u529b\u3002");
            } else {
                this.text.addPara("\u8be5 " + name + " \u7531\u4e8e\u76ee\u524d\u6b63\u5904\u4e8e\u5efa\u8bbe\u5f53\u4e2d\uff0c\u56e0\u6b64\u6ca1\u6709\u4efb\u4f55\u6218\u6597\u80fd\u529b\u3002");
            }
        }
    }

    protected void engage() {
        final SectorEntityToken entity = this.dialog.getInteractionTarget();
        MemoryAPI memory = MarketCMD.getEntityMemory(this.memoryMap);
        final CampaignFleetAPI primary = this.getInteractionTargetForFIDPI();
        this.dialog.setInteractionTarget(primary);
        FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
        config.leaveAlwaysAvailable = true;
        config.showCommLinkOption = false;
        config.showEngageText = false;
        config.showFleetAttitude = false;
        config.showTransponderStatus = false;
        config.alwaysAttackVsAttack = true;
        config.impactsAllyReputation = true;
        config.noSalvageLeaveOptionText = "\u7ee7\u7eed";
        config.dismissOnLeave = false;
        config.printXPToDialog = true;
        config.straightToEngage = true;
        CampaignFleetAPI station = this.getStationFleet();
        config.playerAttackingStation = station != null;
        final FleetInteractionDialogPluginImpl plugin = new FleetInteractionDialogPluginImpl(config);
        final InteractionDialogPlugin originalPlugin = this.dialog.getPlugin();
        config.delegate = new FleetInteractionDialogPluginImpl.BaseFIDDelegate(){

            public void notifyLeave(InteractionDialogAPI dialog) {
                if (primary.isStationMode()) {
                    primary.getMemoryWithoutUpdate().clear();
                    primary.clearAssignments();
                }
                dialog.setPlugin(originalPlugin);
                dialog.setInteractionTarget(entity);
                boolean quickExit = entity.hasTag("non_clickable");
                if (!Global.getSector().getPlayerFleet().isValidPlayerFleet() || quickExit) {
                    dialog.getOptionPanel().clearOptions();
                    dialog.getOptionPanel().addOption("\u79bb\u5f00", "marketLeave");
                    dialog.getOptionPanel().setShortcut("marketLeave", 1, false, false, false, true);
                    dialog.showTextPanel();
                    dialog.setPromptText("\u4f60\u51b3\u5b9a...");
                    dialog.getVisualPanel().finishFadeFast();
                    MarketCMD.this.text.updateSize();
                    return;
                }
                if (plugin.getContext() instanceof FleetEncounterContext) {
                    FleetEncounterContext context = (FleetEncounterContext)plugin.getContext();
                    context.didPlayerWinMostRecentBattleOfEncounter();
                    if (context.isEngagedInHostilities()) {
                        dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "NONE", 0.0f);
                    }
                    MarketCMD.this.showDefenses(context.isEngagedInHostilities());
                } else {
                    MarketCMD.this.showDefenses(false);
                }
                dialog.getVisualPanel().finishFadeFast();
            }

            public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                bcc.objectivesAllowed = false;
            }

            public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
            }
        };
        this.dialog.setPlugin(plugin);
        plugin.init(this.dialog);
    }

    protected CampaignFleetAPI getStationFleet() {
        CampaignFleetAPI station = Misc.getStationFleet(this.market);
        if (station == null) {
            return null;
        }
        if (station.getFleetData().getMembersListCopy().isEmpty()) {
            return null;
        }
        return station;
    }

    protected CampaignFleetAPI getInteractionTargetForFIDPI() {
        CampaignFleetAPI primary = this.getStationFleet();
        if (primary == null) {
            CampaignFleetAPI best = null;
            float minDist = Float.MAX_VALUE;
            for (CampaignFleetAPI fleet : Misc.getNearbyFleets(this.entity, 2000.0f)) {
                if (fleet.getBattle() != null || fleet.getFaction() != this.market.getFaction() || fleet.getFleetData().getNumMembers() <= 0) continue;
                float dist = Misc.getDistance(this.entity.getLocation(), fleet.getLocation());
                dist -= this.entity.getRadius();
                if (!((dist -= fleet.getRadius()) < Misc.getBattleJoinRange()) || !(dist < minDist)) continue;
                best = fleet;
                minDist = dist;
            }
            primary = best;
        }
        return primary;
    }

    protected StationState getStationState() {
        CampaignFleetAPI fleet = Misc.getStationFleet(this.market);
        boolean destroyed = false;
        if (fleet == null && (fleet = Misc.getStationBaseFleet(this.market)) != null) {
            destroyed = true;
        }
        if (fleet == null) {
            return StationState.NONE;
        }
        MarketAPI market = Misc.getStationMarket(fleet);
        if (market != null) {
            for (Industry ind : market.getIndustries()) {
                if (!ind.getSpec().hasTag("station") || !ind.isBuilding() || ind.isDisrupted() || ind.isUpgrading()) continue;
                return StationState.UNDER_CONSTRUCTION;
            }
        }
        if (destroyed) {
            return StationState.REPAIRS;
        }
        return StationState.OPERATIONAL;
    }

    public static int applyRaidStabiltyPenalty(MarketAPI target, String desc, float re) {
        int penalty = 0;
        if (re >= 0.79f) {
            penalty = 3;
        } else if (re >= 0.59f) {
            penalty = 2;
        } else if (re >= 0.29f) {
            penalty = 1;
        }
        if (penalty > 0) {
            RecentUnrest.get(target).add(penalty, desc);
        }
        return penalty;
    }

    public static int applyRaidStabiltyPenalty(MarketAPI target, String desc, float re, float maxPenalty) {
        int penalty = Math.round((0.45f + maxPenalty) * re);
        if (penalty > 0) {
            RecentUnrest.get(target).add(penalty, desc);
        }
        return penalty;
    }

    public static TooltipMakerAPI.StatModValueGetter statPrinter(final boolean withNegative) {
        return new TooltipMakerAPI.StatModValueGetter(){

            public String getPercentValue(MutableStat.StatMod mod) {
                String prefix = mod.getValue() > 0.0f ? "+" : "";
                return String.valueOf(prefix) + (int)mod.getValue() + "%";
            }

            public String getMultValue(MutableStat.StatMod mod) {
                return "\u00d7" + Misc.getRoundedValue(mod.getValue());
            }

            public String getFlatValue(MutableStat.StatMod mod) {
                String prefix = mod.getValue() > 0.0f ? "+" : "";
                return String.valueOf(prefix) + (int)mod.getValue();
            }

            public Color getModColor(MutableStat.StatMod mod) {
                if (withNegative && mod.getValue() < 1.0f) {
                    return Misc.getNegativeHighlightColor();
                }
                return null;
            }
        };
    }

    public static int getBombardmentCost(MarketAPI market, CampaignFleetAPI fleet) {
        float bomardBonus;
        float str = MarketCMD.getDefenderStr(market, true);
        int result = (int)(str * Global.getSettings().getFloat("bombardFuelFraction"));
        if (result < 2) {
            result = 2;
        }
        if (fleet != null && (result = (int)((float)result - (bomardBonus = Misc.getFleetwideTotalMod(fleet, "fleet_bombard_cost_reduction", 0.0f)))) < 0) {
            result = 0;
        }
        return result;
    }

    public static int getTacticalBombardmentStabilityPenalty() {
        return (int)Global.getSettings().getFloat("bombardTacticalStability");
    }

    public static int getSaturationBombardmentStabilityPenalty() {
        return (int)Global.getSettings().getFloat("bombardSaturationStability");
    }

    protected void bombardMenu() {
        float width = 350.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color b = Misc.getNegativeHighlightColor();
        this.dialog.getVisualPanel().showImagePortion("illustrations", "bombard_prepare", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        StatBonus defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        float bomardBonus = Misc.getFleetwideTotalMod(this.playerFleet, "fleet_bombard_cost_reduction", 0.0f);
        String increasedBombardKey = "core_addedBombard";
        StatBonus bombardBonusStat = new StatBonus();
        if (bomardBonus > 0.0f) {
            bombardBonusStat.modifyFlat(increasedBombardKey, -bomardBonus, "\u906d\u5230\u7279\u9063\u961f\u8f70\u70b8");
        }
        float defenderStr = Math.round(defender.computeEffective(0.0f));
        if ((defenderStr -= bomardBonus) < 0.0f) {
            defenderStr = 0.0f;
        }
        this.temp.defenderStr = defenderStr;
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        String has = this.faction.getDisplayNameHasOrHave();
        String is = this.faction.getDisplayNameIsOrAre();
        boolean hostile = this.faction.isHostileTo("player");
        boolean tOn = this.playerFleet.isTransponderOn();
        float initPad = 0.0f;
        if (!hostile) {
            info.addPara(String.valueOf(Misc.ucFirst(this.faction.getDisplayNameWithArticle())) + " " + is + " \u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u5982\u679c\u73b0\u5728\u5c55\u5f00\u58f0\u52bf\u6d69\u5927\u7684\u8f68\u9053\u8f70\u70b8\uff0c\u65e0\u8bba\u4f60\u7684\u5e94\u7b54\u5668 \u5904\u4e8e\u4f55\u79cd\u72b6\u6001\uff0c" + "\u90fd\u5c06\u65e0\u6cd5\u63a9\u76d6\u4f60\u6240\u5b9e\u65bd\u7684\u66b4\u884c\u3002", initPad, this.faction.getBaseUIColor(), this.faction.getDisplayNameWithArticleWithoutArticle());
            initPad = opad;
        }
        info.addPara("\u661f\u8230\u71c3\u6599\u5f88\u5bb9\u6613\u5c31\u80fd\u5931\u53bb\u7a33\u5b9a\uff0c\u8ba9\u5176\u4e2d\u7684\u53cd\u7269\u8d28\u91ca\u653e\u5176\u8574\u542b\u7684\u7834\u574f\u6f5c\u80fd\u3002\u5730\u9762\u9632\u5fa1\u4f1a\u963b\u788d\u8f70\u70b8\uff0c\u4f46\u5b9e\u9645\u4e0a\u53ea\u9700\u6295\u4e0b\u66f4\u591a\u71c3\u6599\u5c31\u53ef\u4ee5\u8fbe\u6210\u540c\u6837\u7684\u8f70\u70b8\u6548\u679c\u3002", initPad);
        if (bomardBonus > 0.0f) {
            info.addPara("\u6709\u6548\u7684\u5730\u9762\u9632\u5fa1\u6218\u529b\uff1a%s", opad, h, "" + (int)defenderStr);
        } else {
            info.addPara("\u5730\u9762\u9632\u5fa1\u6218\u529b\uff1a%s", opad, h, "" + (int)defenderStr);
        }
        info.addStatModGrid(width, 50.0f, opad, small, defender, true, MarketCMD.statPrinter(true));
        if (!bombardBonusStat.isUnmodified()) {
            info.addStatModGrid(width, 50.0f, opad, 3.0f, bombardBonusStat, true, MarketCMD.statPrinter(false));
        }
        this.text.addTooltip();
        this.temp.bombardCost = MarketCMD.getBombardmentCost(this.market, this.playerFleet);
        int fuel = (int)this.playerFleet.getCargo().getFuel();
        boolean canBombard = fuel >= this.temp.bombardCost;
        LabelAPI label = this.text.addPara("\u8f70\u70b8\u9700\u8981 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002\u800c\u4f60\u73b0\u6709 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002", h, "" + this.temp.bombardCost, "" + fuel);
        label.setHighlight("" + this.temp.bombardCost, "" + fuel);
        label.setHighlightColors(canBombard ? h : b, h);
        this.options.clearOptions();
        this.options.addOption("\u51c6\u5907\u6218\u672f\u8f70\u70b8", BOMBARD_TACTICAL);
        this.options.addOption("\u51c6\u5907\u9971\u548c\u8f70\u70b8", BOMBARD_SATURATION);
        if (DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            canBombard = true;
        }
        if (!canBombard) {
            this.options.setEnabled(BOMBARD_TACTICAL, false);
            this.options.setTooltip(BOMBARD_TACTICAL, "\u6ca1\u6709\u8db3\u591f\u7684\u71c3\u6599\u3002");
            this.options.setEnabled(BOMBARD_SATURATION, false);
            this.options.setTooltip(BOMBARD_SATURATION, "\u6ca1\u6709\u8db3\u591f\u7684\u71c3\u6599\u3002");
        }
        this.options.addOption("\u8fd4\u56de", RAID_GO_BACK);
        this.options.setShortcut(RAID_GO_BACK, 1, false, false, false, true);
    }

    protected void addConfirmOptions() {
        this.options.clearOptions();
        this.options.addOption("\u5f00\u59cb\u7a81\u88ad", RAID_CONFIRM);
        boolean tOn = this.playerFleet.isTransponderOn();
        if (this.market != null && !this.market.isPlanetConditionMarketOnly()) {
            this.options.addOption("\u4fdd\u8bc1\u533f\u540d\u7684\u60c5\u51b5\u4e0b\u5b8c\u6210\u4efb\u52a1", RAID_CONFIRM_STORY);
            String req = "";
            if (tOn) {
                req = "\n\n\u9700\u8981\u5173\u95ed\u5e94\u7b54\u5668";
                this.options.setEnabled(RAID_CONFIRM_STORY, false);
            }
            this.options.setTooltip(RAID_CONFIRM_STORY, "\u5982\u679c\u6765\u6b64\u7a81\u88ad\u7684\u8230\u961f\u672a\u88ab\u5de1\u903b\u961f\u902e\u5230\u6216\u6ca1\u6709\u6253\u5f00\u5e94\u7b54\u5668\u7684\u8bdd\uff0c\u90a3\u672c\u6b21\u884c\u52a8\u5c06\u4e0d\u4f1a\u5f71\u54cd\u4f60\u4e0e " + this.market.getFaction().getDisplayNameWithArticle() + " \u95f4" + "\u7684\u5173\u7cfb\u3002" + req);
            this.options.setTooltipHighlightColors(RAID_CONFIRM_STORY, this.market.getFaction().getBaseUIColor(), Misc.getNegativeHighlightColor());
            this.options.setTooltipHighlights(RAID_CONFIRM_STORY, this.market.getFaction().getDisplayNameWithArticleWithoutArticle(), req.isEmpty() ? req : req.substring(2));
            SetStoryOption.StoryOptionParams params = new SetStoryOption.StoryOptionParams(RAID_CONFIRM_STORY, 1, "noRepPenaltyRaid", Sounds.STORY_POINT_SPEND_LEADERSHIP, "\u79d8\u5bc6\u7a81\u88ad " + this.market.getName());
            SetStoryOption.set(this.dialog, params, new SetStoryOption.BaseOptionStoryPointActionDelegate(this.dialog, params){

                public void confirm() {
                    super.confirm();
                    MarketCMD.this.raidConfirm(true);
                }
            });
        }
        this.options.addOption("\u653e\u5f03", RAID_NEVER_MIND);
        this.options.setShortcut(RAID_NEVER_MIND, 1, false, false, false, true);
        boolean hostile = this.faction.isHostileTo("player");
        if (tOn && !hostile && !this.faction.isNeutralFaction()) {
            this.options.addOptionConfirmation(RAID_CONFIRM, "\u8be5 " + this.faction.getDisplayNameLong() + " " + this.faction.getDisplayNameIsOrAre() + "\u76ee\u524d\u8fd8\u6ca1\u6709\u654c\u610f\uff0c\u5e76\u4e14\u4f60\u7684\u8eab\u4efd\u5df2\u88ab\u5bf9\u65b9\u77e5\u6653\u3002" + "\u4f60\u786e\u5b9a\u8981\u4e0e\u5176\u516c\u5f00\u654c\u5bf9\u5417\uff1f", "\u662f\u7684", "\u653e\u5f03");
        }
    }

    public static List<Industry> getTacticalBombardmentTargets(MarketAPI market) {
        int dur = MarketCMD.getBombardDisruptDuration();
        ArrayList<Industry> targets = new ArrayList<Industry>();
        for (Industry ind : market.getIndustries()) {
            if (!ind.getSpec().hasTag("tactical_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
            targets.add(ind);
        }
        return targets;
    }

    protected void bombardTactical() {
        this.temp.bombardType = BombardType.TACTICAL;
        boolean hostile = this.faction.isHostileTo("player");
        this.temp.willBecomeHostile.clear();
        this.temp.willBecomeHostile.add(this.faction);
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color b = Misc.getNegativeHighlightColor();
        int dur = MarketCMD.getBombardDisruptDuration();
        List<Industry> targets = MarketCMD.getTacticalBombardmentTargets(this.market);
        this.temp.bombardmentTargets.clear();
        this.temp.bombardmentTargets.addAll(targets);
        if (targets.isEmpty()) {
            this.text.addPara(String.valueOf(this.market.getName()) + " \u6ca1\u6709\u53ef\u4f9b\u762b\u75ea\u7684\u519b\u4e8b\u8bbe\u65bd\u3002");
            this.addBombardNeverMindOption();
            return;
        }
        int fuel = (int)this.playerFleet.getCargo().getFuel();
        this.text.addPara("\u6218\u672f\u8f70\u70b8\u4e0d\u4ec5\u4f1a\u7834\u574f\u6b96\u6c11\u5730\u7684\u7a33\u5b9a\uff0c\u8fd8\u4f1a\u762b\u75ea\u4ee5\u4e0b\u519b\u4e8b\u76ee\u6807\u7ea6 %s \u5929\uff1a", h, "" + dur);
        TooltipMakerAPI info = this.text.beginTooltip();
        info.setParaSmallInsignia();
        info.setParaFontDefault();
        info.setBulletedListMode("      ");
        float initPad = 0.0f;
        for (Industry ind : targets) {
            info.addPara(ind.getCurrentName(), initPad);
            initPad = 3.0f;
        }
        info.setBulletedListMode(null);
        this.text.addTooltip();
        this.text.addPara("\u8f70\u70b8\u9700\u8981 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002\u800c\u4f60\u6709 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002", h, "" + this.temp.bombardCost, "" + fuel);
        this.addBombardConfirmOptions();
    }

    protected void bombardSaturation() {
        boolean destroy;
        this.temp.bombardType = BombardType.SATURATION;
        this.temp.willBecomeHostile.clear();
        this.temp.willBecomeHostile.add(this.faction);
        ArrayList<FactionAPI> nonHostile = new ArrayList<FactionAPI>();
        nonHostile.add(this.faction);
        for (FactionAPI faction : Global.getSector().getAllFactions()) {
            if (this.temp.willBecomeHostile.contains(faction) || !faction.getCustomBoolean("caresAboutAtrocities")) continue;
            boolean hostile = faction.isHostileTo("player");
            this.temp.willBecomeHostile.add(faction);
            if (hostile) continue;
            nonHostile.add(faction);
        }
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color b = Misc.getNegativeHighlightColor();
        int dur = MarketCMD.getBombardDisruptDuration();
        ArrayList<Industry> targets = new ArrayList<Industry>();
        for (Industry ind : this.market.getIndustries()) {
            if (ind.getSpec().hasTag("no_saturation_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
            targets.add(ind);
        }
        this.temp.bombardmentTargets.clear();
        this.temp.bombardmentTargets.addAll(targets);
        boolean bl = destroy = this.market.getSize() <= MarketCMD.getBombardDestroyThreshold();
        if (Misc.isStoryCritical(this.market)) {
            destroy = false;
        }
        int fuel = (int)this.playerFleet.getCargo().getFuel();
        if (destroy) {
            this.text.addPara("\u5982\u679c\u5bf9\u8fd9\u79cd\u89c4\u6a21\u7684\u6b96\u6c11\u5730\u8fdb\u884c\u9971\u548c\u8f70\u70b8\u5c06\u4f1a\u5f7b\u5e95\u6467\u6bc1\u5b83\u3002");
        } else {
            this.text.addPara("\u9971\u548c\u8f70\u70b8\u4e0d\u4ec5\u4f1a\u5927\u5e45\u5ea6\u7834\u574f\u6b96\u6c11\u5730\u7684\u7a33\u5b9a\uff0c\u8fd8\u4f1a\u964d\u4f4e\u5176\u4eba\u53e3\uff0c\u5e76\u8ba9\u6240\u6709 \u8bbe\u65bd\u957f\u671f\u5904\u4e8e\u762b\u75ea\u72b6\u6001\u3002");
        }
        if (nonHostile.isEmpty()) {
            this.text.addPara("\u8fd9\u79cd\u89c4\u6a21\u7684\u66b4\u884c\u662f\u65e0\u6cd5\u9690\u85cf\u7684\uff0c\u6240\u4ee5\u4efb\u4f55\u5bf9\u8fd9\u79cd\u884c\u52a8\u611f\u5230\u9707\u6012\u7684\u52bf\u529b\u5c06\u5f00\u59cb\u5bf9\u4f60\u62b1\u6709\u654c\u610f\u3002");
        } else {
            this.text.addPara("\u8fd9\u79cd\u89c4\u6a21\u7684\u66b4\u884c\u662f\u65e0\u6cd5\u9690\u85cf\u7684\uff0c\u6240\u4ee5\u8fd9\u4f1a\u8ba9\u4e0b\u5217\u52bf\u529b\u7acb\u5373\u4e0e\u4f60\u654c\u5bf9\uff1a");
        }
        if (!nonHostile.isEmpty()) {
            TooltipMakerAPI info = this.text.beginTooltip();
            info.setParaFontDefault();
            info.setBulletedListMode("      ");
            float initPad = 0.0f;
            for (FactionAPI fac : nonHostile) {
                info.addPara(Misc.ucFirst(fac.getDisplayName()), fac.getBaseUIColor(), initPad);
                initPad = 3.0f;
            }
            info.setBulletedListMode(null);
            this.text.addTooltip();
        }
        this.text.addPara("\u8f70\u70b8\u9700\u8981 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002\u800c\u4f60\u6709 %s \u5355\u4f4d\u7684\u71c3\u6599\u3002", h, "" + this.temp.bombardCost, "" + fuel);
        this.addBombardConfirmOptions();
    }

    protected void bombardConfirm() {
        boolean bl;
        boolean bl2;
        if (this.temp.bombardType == null) {
            this.bombardNeverMind();
            return;
        }
        if (this.temp.bombardType == BombardType.TACTICAL) {
            this.dialog.getVisualPanel().showImagePortion("illustrations", "bombard_tactical_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        } else {
            this.dialog.getVisualPanel().showImagePortion("illustrations", "bombard_saturation_result", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        }
        Random random = this.getRandom();
        if (!DebugFlags.MARKET_HOSTILITIES_DEBUG) {
            float timeout = TACTICAL_BOMBARD_TIMEOUT_DAYS;
            if (this.temp.bombardType == BombardType.SATURATION) {
                timeout = SATURATION_BOMBARD_TIMEOUT_DAYS;
            }
            Misc.increaseMarketHostileTimeout(this.market, timeout);
            timeout *= 0.7f;
            for (MarketAPI marketAPI : Global.getSector().getEconomy().getMarkets(this.market.getContainingLocation())) {
                if (marketAPI == this.market) continue;
                boolean cares = marketAPI.getFaction().getCustomBoolean("caresAboutAtrocities");
                if (marketAPI.getFaction().isNeutralFaction() || marketAPI.getFaction().isPlayerFaction() || marketAPI.getFaction().isHostileTo(this.market.getFaction()) && !(cares &= this.temp.bombardType == BombardType.SATURATION)) continue;
                Misc.increaseMarketHostileTimeout(marketAPI, timeout);
            }
        }
        this.addMilitaryResponse();
        this.playerFleet.getCargo().removeFuel(this.temp.bombardCost);
        AddRemoveCommodity.addCommodityLossText("fuel", this.temp.bombardCost, this.text);
        for (FactionAPI curr : this.temp.willBecomeHostile) {
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = (float)this.market.getSize() * -0.01f * 1.0f;
            impact.ensureAtBest = RepLevel.HOSTILE;
            if (this.temp.bombardType == BombardType.SATURATION) {
                if (curr == this.faction) {
                    impact.ensureAtBest = RepLevel.VENGEFUL;
                }
                impact.delta = (float)this.market.getSize() * -0.01f * 1.0f;
            }
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, this.text, true, true), curr.getId());
        }
        if (this.temp.bombardType == BombardType.SATURATION) {
            int atrocities = (int)Global.getSector().getCharacterData().getMemoryWithoutUpdate().getFloat("$atrocities");
            Global.getSector().getCharacterData().getMemoryWithoutUpdate().set("$atrocities", ++atrocities);
            if (this.market != null && this.market.getFaction() != null) {
                MemoryAPI memoryAPI = this.market.getFaction().getMemoryWithoutUpdate();
                int count = memoryAPI.getInt("$numTimesSatBombardedByPlayer");
                memoryAPI.set("$numTimesSatBombardedByPlayer", ++count);
            }
        }
        int stabilityPenalty = MarketCMD.getTacticalBombardmentStabilityPenalty();
        if (this.temp.bombardType == BombardType.SATURATION) {
            stabilityPenalty = MarketCMD.getSaturationBombardmentStabilityPenalty();
        }
        boolean bl3 = bl2 = this.temp.bombardType == BombardType.SATURATION && this.market.getSize() <= MarketCMD.getBombardDestroyThreshold();
        if (Misc.isStoryCritical(this.market)) {
            bl = false;
        }
        if (stabilityPenalty > 0 && !bl) {
            String reason = "\u8fd1\u671f\u906d\u5230\u8f70\u70b8";
            if (Misc.isPlayerFactionSetUp()) {
                reason = String.valueOf(this.playerFaction.getDisplayName()) + " \u8f70\u70b8";
            }
            RecentUnrest.get(this.market).add(stabilityPenalty, reason);
            this.text.addPara("\u8be5 " + this.market.getName() + " \u7684\u7a33\u5b9a\u6027\u964d\u4f4e\u4e86 %s \u70b9\u3002", Misc.getHighlightColor(), "" + stabilityPenalty);
        }
        if (this.market.hasCondition("habitable") && !this.market.hasCondition("pollution")) {
            this.market.addCondition("pollution");
        }
        if (!bl) {
            for (Industry curr : this.temp.bombardmentTargets) {
                int dur = MarketCMD.getBombardDisruptDuration();
                dur = (int)((float)dur * StarSystemGenerator.getNormalRandom(random, 1.0f, 1.25f));
                curr.setDisrupted(dur);
            }
        }
        if (this.temp.bombardType == BombardType.TACTICAL) {
            this.text.addPara("\u6240\u6709\u519b\u4e8b\u8bbe\u65bd\u5df2\u88ab\u762b\u75ea\u3002");
            ListenerUtil.reportTacticalBombardmentFinished(this.dialog, this.market, this.temp);
        } else if (this.temp.bombardType == BombardType.SATURATION) {
            if (bl) {
                DecivTracker.decivilize(this.market, true);
                this.text.addPara(String.valueOf(this.market.getName()) + " \u5df2\u88ab\u5f7b\u5e95\u6467\u6bc1\u3002");
            } else {
                int prevSize = this.market.getSize();
                CoreImmigrationPluginImpl.reduceMarketSize(this.market);
                if (prevSize == this.market.getSize()) {
                    this.text.addPara("\u6240\u6709\u884c\u52a8\u5747\u88ab\u4e2d\u65ad\u3002");
                } else {
                    this.text.addPara("\u7531\u4e8e\u6240\u6709\u8bbe\u65bd\u906d\u5230\u762b\u75ea\uff0c\u800c\u5bfc\u81f4\u6b96\u6c11\u5730\u7684\u89c4\u6a21\u964d\u4f4e\u81f3 %s.", Misc.getHighlightColor(), "" + this.market.getSize());
                }
            }
            ListenerUtil.reportSaturationBombardmentFinished(this.dialog, this.market, this.temp);
        }
        if (this.dialog != null && this.dialog.getPlugin() instanceof RuleBasedDialog) {
            if (this.dialog.getInteractionTarget() != null && this.dialog.getInteractionTarget().getMarket() != null) {
                Global.getSector().setPaused(false);
                this.dialog.getInteractionTarget().getMarket().getMemoryWithoutUpdate().advance(1.0E-4f);
                Global.getSector().setPaused(true);
            }
            ((RuleBasedDialog)((Object)this.dialog.getPlugin())).updateMemory();
        }
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyBombarded", "player", true, 30.0f);
        if (bl && this.dialog != null && this.dialog.getPlugin() instanceof RuleBasedDialog) {
            ((RuleBasedDialog)((Object)this.dialog.getPlugin())).updateMemory();
        }
        MarketCMD.addBombardVisual(this.market.getPrimaryEntity());
        this.addBombardContinueOption();
    }

    protected void bombardNeverMind() {
        this.bombardMenu();
    }

    protected void raidResult() {
        if (this.temp.raidLoot != null) {
            if (this.temp.raidLoot.isEmpty()) {
                this.finishedRaidOrBombard();
            } else {
                this.raidShowLoot();
            }
            return;
        }
        this.finishedRaidOrBombard();
    }

    protected void bombardResult() {
        this.finishedRaidOrBombard();
    }

    protected void finishedRaidOrBombard() {
        new ShowDefaultVisual().execute(null, this.dialog, Misc.tokenize(""), this.memoryMap);
        this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$menuState", "main", 0.0f);
        if (this.dialog.getInteractionTarget().getMemoryWithoutUpdate().contains("$tradeMode")) {
            if (this.market.isPlanetConditionMarketOnly()) {
                this.dialog.getInteractionTarget().getMemoryWithoutUpdate().unset("$hasMarket");
            }
            this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "NONE", 0.0f);
        } else {
            this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "OPEN", 0.0f);
        }
        if (this.temp.nonMarket) {
            String trigger = this.temp.raidContinueTrigger;
            if (trigger == null || trigger.isEmpty()) {
                trigger = "OpenInteractionDialog";
            }
            FireAll.fire(null, this.dialog, this.memoryMap, trigger);
        } else {
            FireAll.fire(null, this.dialog, this.memoryMap, "PopulateOptions");
        }
        this.clearTemp();
    }

    protected void addBombardContinueOption() {
        this.addBombardContinueOption(null);
    }

    protected void addBombardContinueOption(String text) {
        if (text == null) {
            text = "\u7ee7\u7eed";
        }
        this.options.clearOptions();
        this.options.addOption(text, BOMBARD_RESULT);
    }

    protected boolean checkDebtEffect() {
        float f;
        String key = "$debt_effectTimeout";
        if (Global.getSector().getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        if (this.market.isPlayerOwned() && this.market.getSize() <= 3) {
            return false;
        }
        MonthlyReport report = SharedData.getData().getPreviousReport();
        if (report.getPreviousDebt() <= 0 || report.getDebt() <= 0) {
            return false;
        }
        float debt = report.getDebt() + report.getPreviousDebt();
        float income = report.getRoot().totalIncome;
        if (income < 1.0f) {
            income = 1.0f;
        }
        if ((f = debt / income) > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f < 0.1f) {
            return false;
        }
        int crew = this.playerFleet.getCargo().getCrew();
        int marines = this.playerFleet.getCargo().getMarines();
        return crew > 10 || marines > 10;
    }

    protected void applyDebtEffect() {
        int marineLoss;
        float f;
        MonthlyReport report = SharedData.getData().getPreviousReport();
        float debt = report.getDebt() + report.getPreviousDebt();
        float income = report.getRoot().totalIncome;
        if (income < 1.0f) {
            income = 1.0f;
        }
        if ((f = debt / income) > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        int crew = this.playerFleet.getCargo().getCrew();
        int marines = this.playerFleet.getCargo().getMarines();
        float maxLossFraction = 0.03f + Math.min(f + 0.05f, 0.2f) * (float)Math.random();
        float marineLossFraction = 0.03f + Math.min(f + 0.05f, 0.2f) * (float)Math.random();
        int crewLoss = (int)((float)crew * maxLossFraction);
        if (crewLoss < 2) {
            crewLoss = 2;
        }
        if ((marineLoss = (int)((float)marines * marineLossFraction)) < 2) {
            marineLoss = 2;
        }
        this.dialog.getVisualPanel().showImagePortion("illustrations", "crew_leaving", 640.0f, 400.0f, 0.0f, 0.0f, 480.0f, 300.0f);
        this.text.addPara("\u5728\u8fc7\u53bb\u51e0\u4e2a\u6708\u91cc\uff0c\u56e0\u957f\u671f\u62d6\u6b20\u5de5\u8d44\u800c\u5f15\u8d77\u90e8\u5206\u8239\u5458\u7684\u4e0d\u6ee1\uff0c\u5982\u4eca\u4e00\u4e9b\u4eba\u6b63\u597d\u501f\u6b64\u673a\u4f1a\u79bb\u5f00\u4e86\u539f\u6765\u7684\u5de5\u4f5c\u5c97\u4f4d\u3002");
        if (crewLoss < crew) {
            this.playerFleet.getCargo().removeCrew(crewLoss);
            AddRemoveCommodity.addCommodityLossText("crew", crewLoss, this.text);
        }
        if (marineLoss <= marines) {
            this.playerFleet.getCargo().removeMarines(marineLoss);
            AddRemoveCommodity.addCommodityLossText("marines", marineLoss, this.text);
        }
        String key = "$debt_effectTimeout";
        Global.getSector().getMemoryWithoutUpdate().set(key, true, 30.0f + (float)Math.random() * 10.0f);
        this.options.clearOptions();
        this.options.addOption("\u7ee7\u7eed", DEBT_RESULT_CONTINUE);
    }

    public void doGenericRaid(FactionAPI faction, float attackerStr) {
        this.doGenericRaid(faction, attackerStr, 3.0f);
    }

    public void doGenericRaid(FactionAPI faction, float attackerStr, float maxPenalty) {
        this.doGenericRaid(faction, attackerStr, maxPenalty, false);
    }

    public void doGenericRaid(FactionAPI faction, float attackerStr, float maxPenalty, boolean allowedRepeat) {
        if (!allowedRepeat && Misc.flagHasReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", faction.getId())) {
            return;
        }
        float re = MarketCMD.getRaidEffectiveness(this.market, attackerStr);
        if (maxPenalty == 3.0f) {
            MarketCMD.applyRaidStabiltyPenalty(this.market, String.valueOf(Misc.ucFirst(faction.getPersonNamePrefix())) + " \u7a81\u88ad", re);
        } else {
            MarketCMD.applyRaidStabiltyPenalty(this.market, String.valueOf(Misc.ucFirst(faction.getPersonNamePrefix())) + " \u7a81\u88ad", re, maxPenalty);
        }
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", faction.getId(), true, 30.0f);
        Misc.setRaidedTimestamp(this.market);
    }

    public boolean doIndustryRaid(FactionAPI faction, float attackerStr, Industry industry, float durMult) {
        this.temp.raidType = RaidType.DISRUPT;
        this.temp.target = industry;
        StatBonus defenderBase = new StatBonus();
        StatBonus defender = this.market.getStats().getDynamic().getMod("ground_defenses_mod");
        String increasedDefensesKey = "core_addedDefStr";
        float added = MarketCMD.getDefenderIncreaseValue(this.market);
        if (added > 0.0f) {
            defender.modifyFlat(increasedDefensesKey, added, "\u63d0\u9ad8\u9632\u5fa1\u80fd\u529b");
        }
        float defenderStr = Math.round(defender.computeEffective(defenderBase.computeEffective(0.0f)));
        defender.unmodifyFlat(increasedDefensesKey);
        this.temp.attackerStr = attackerStr;
        this.temp.defenderStr = defenderStr;
        boolean hasForces = true;
        boolean canDisrupt = true;
        this.temp.raidMult = attackerStr / Math.max(1.0f, attackerStr + defenderStr);
        this.temp.raidMult = (float)Math.round(this.temp.raidMult * 100.0f) / 100.0f;
        if (this.temp.raidMult < VALUABLES_THRESHOLD) {
            hasForces = false;
        }
        if (this.temp.raidMult < DISRUPTION_THRESHOLD) {
            canDisrupt = false;
        }
        if (!canDisrupt) {
            return false;
        }
        Random random = this.getRandom();
        MarketCMD.applyDefenderIncreaseFromRaid(this.market);
        String reason = String.valueOf(faction.getDisplayName()) + " \u7a81\u88ad";
        if (faction.getPersonNamePrefix() != null) {
            reason = String.valueOf(Misc.ucFirst(faction.getPersonNamePrefix())) + " \u7a81\u88ad";
        }
        MarketCMD.applyRaidStabiltyPenalty(this.market, reason, this.temp.raidMult);
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyRaided", faction.getId(), true, 30.0f);
        Misc.setRaidedTimestamp(this.market);
        if (this.temp.target != null) {
            float dur = this.computeBaseDisruptDuration(this.temp.target);
            dur *= StarSystemGenerator.getNormalRandom(random, 1.0f, 1.25f);
            if ((dur *= durMult) < 2.0f) {
                dur = 2.0f;
            }
            float already = this.temp.target.getDisruptedDays();
            this.temp.target.setDisrupted(already + dur);
        }
        return true;
    }

    public void doBombardment(FactionAPI faction, BombardType type) {
        ArrayList<Industry> targets;
        this.temp.bombardType = type;
        Random random = this.getRandom();
        int dur = MarketCMD.getBombardDisruptDuration();
        int stabilityPenalty = MarketCMD.getTacticalBombardmentStabilityPenalty();
        if (this.temp.bombardType == BombardType.SATURATION) {
            stabilityPenalty = MarketCMD.getSaturationBombardmentStabilityPenalty();
            targets = new ArrayList();
            for (Industry ind : this.market.getIndustries()) {
                if (ind.getSpec().hasTag("no_saturation_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
                targets.add(ind);
            }
            this.temp.bombardmentTargets.clear();
            this.temp.bombardmentTargets.addAll(targets);
        } else {
            targets = new ArrayList<Industry>();
            for (Industry ind : this.market.getIndustries()) {
                if (!ind.getSpec().hasTag("tactical_bombardment") || ind.getDisruptedDays() >= (float)dur * 0.8f) continue;
                targets.add(ind);
            }
            this.temp.bombardmentTargets.clear();
            this.temp.bombardmentTargets.addAll(targets);
        }
        if (stabilityPenalty > 0) {
            String reason = "\u9971\u548c\u8f70\u70b8";
            if (this.temp.bombardType == BombardType.TACTICAL) {
                reason = "\u6218\u672f\u8f70\u70b8";
            }
            RecentUnrest.get(this.market).add(stabilityPenalty, reason);
        }
        if (this.market.hasCondition("habitable") && !this.market.hasCondition("pollution")) {
            this.market.addCondition("pollution");
        }
        for (Industry curr : this.temp.bombardmentTargets) {
            dur = MarketCMD.getBombardDisruptDuration();
            dur = (int)((float)dur * StarSystemGenerator.getNormalRandom(random, 1.0f, 1.25f));
            curr.setDisrupted(dur);
        }
        if (this.temp.bombardType != BombardType.TACTICAL && this.temp.bombardType == BombardType.SATURATION) {
            boolean destroy;
            boolean bl = destroy = this.market.getSize() <= MarketCMD.getBombardDestroyThreshold();
            if (Misc.isStoryCritical(this.market)) {
                destroy = false;
            }
            if (destroy) {
                DecivTracker.decivilize(this.market, true);
            } else {
                CoreImmigrationPluginImpl.reduceMarketSize(this.market);
            }
        }
        Misc.setFlagWithReason(this.market.getMemoryWithoutUpdate(), "$recentlyBombarded", faction.getId(), true, 30.0f);
        MarketCMD.addBombardVisual(this.market.getPrimaryEntity());
    }

    public static void addBombardVisual(SectorEntityToken target) {
        if (target != null && target.isInCurrentLocation()) {
            int num = (int)(target.getRadius() * target.getRadius() / 300.0f);
            if ((num *= 2) > 150) {
                num = 150;
            }
            if (num < 10) {
                num = 10;
            }
            target.addScript(new BombardmentAnimation(num, target));
        }
    }

    protected boolean checkMercsLeaving() {
        String key = "$mercs_leaveTimeout";
        if (Global.getSector().getMemoryWithoutUpdate().contains(key)) {
            return false;
        }
        if (this.market.isHidden()) {
            return false;
        }
        if (this.market.getSize() <= 3) {
            return false;
        }
        List<OfficerDataAPI> mercs = Misc.getMercs(this.playerFleet);
        if (mercs.isEmpty()) {
            return false;
        }
        MonthlyReport report = SharedData.getData().getPreviousReport();
        boolean debt = report.getDebt() > 0;
        float contractDur = Global.getSettings().getFloat("officerMercContractDur");
        for (OfficerDataAPI od : mercs) {
            float elapsed;
            if (debt && od.getPerson().getMemoryWithoutUpdate().contains(key) || !((elapsed = Misc.getMercDaysSinceHired(od.getPerson())) > contractDur) && (!debt || !(elapsed > 45.0f))) continue;
            this.dialog.getInteractionTarget().setActivePerson(od.getPerson());
            ((RuleBasedInteractionDialogPluginImpl)this.dialog.getPlugin()).notifyActivePersonChanged();
            return true;
        }
        return false;
    }

    protected void convinceMercToStay() {
        PersonAPI merc = this.dialog.getInteractionTarget().getActivePerson();
        this.dialog.getInteractionTarget().setActivePerson(null);
        if (merc != null) {
            Misc.setMercHiredNow(merc);
            String key = "$mercs_leaveTimeout";
            Global.getSector().getMemoryWithoutUpdate().set(key, true, 5.0f + (float)Math.random() * 5.0f);
            merc.getMemoryWithoutUpdate().set(key, true, 35.0f + (float)Math.random() * 5.0f);
        }
    }

    protected void mercLeaves() {
        PersonAPI merc = this.dialog.getInteractionTarget().getActivePerson();
        this.dialog.getInteractionTarget().setActivePerson(null);
        if (merc != null) {
            FleetMemberAPI member = this.playerFleet.getFleetData().getMemberWithCaptain(merc);
            if (member != null) {
                member.setCaptain(null);
            }
            this.playerFleet.getFleetData().removeOfficer(merc);
            AddRemoveCommodity.addOfficerLossText(merc, this.text);
            String key = "$mercs_leaveTimeout";
            Global.getSector().getMemoryWithoutUpdate().set(key, true, 5.0f + (float)Math.random() * 5.0f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BombardType {
        TACTICAL,
        SATURATION;

    }

    public static class BombardmentAnimation
    implements EveryFrameScript {
        int num = 0;
        SectorEntityToken target;
        int added = 0;
        float elapsed = 0.0f;

        public BombardmentAnimation(int num, SectorEntityToken target) {
            this.num = num;
            this.target = target;
        }

        public boolean runWhilePaused() {
            return false;
        }

        public boolean isDone() {
            return this.added >= this.num;
        }

        public void advance(float amount) {
            this.elapsed += amount * (float)Math.random();
            if (this.elapsed < 0.03f) {
                return;
            }
            this.elapsed = 0.0f;
            int curr = (int)Math.round(Math.random() * 4.0);
            if (curr < 1) {
                curr = 0;
            }
            Color color = new Color(255, 165, 100, 255);
            Vector2f vel = new Vector2f();
            if (this.target.getOrbit() != null && this.target.getCircularOrbitRadius() > 0.0f && this.target.getCircularOrbitPeriod() > 0.0f && this.target.getOrbitFocus() != null) {
                float circumference = (float)Math.PI * 2 * this.target.getCircularOrbitRadius();
                float speed = circumference / this.target.getCircularOrbitPeriod();
                float dir = Misc.getAngleInDegrees(this.target.getLocation(), this.target.getOrbitFocus().getLocation()) + 90.0f;
                vel = Misc.getUnitVectorAtDegreeAngle(dir);
                vel.scale(speed / Global.getSector().getClock().getSecondsPerDay());
            }
            int i = 0;
            while (i < curr) {
                float glowSize = 50.0f + 50.0f * (float)Math.random();
                float angle = (float)Math.random() * 360.0f;
                float dist = (float)Math.sqrt(Math.random()) * this.target.getRadius();
                float factor = 0.5f + 0.5f * (1.0f - (float)Math.sqrt(dist / this.target.getRadius()));
                glowSize *= factor;
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
                loc.scale(dist);
                Vector2f.add((Vector2f)loc, (Vector2f)this.target.getLocation(), (Vector2f)loc);
                Color c2 = Misc.scaleColor(color, factor);
                Misc.addHitGlow(this.target.getContainingLocation(), loc, vel, glowSize, c2);
                ++this.added;
                if (i == 0 && (dist = Misc.getDistance(loc, Global.getSector().getPlayerFleet().getLocation())) < HyperspaceTerrainPlugin.STORM_STRIKE_SOUND_RANGE) {
                    float volumeMult = 1.0f - dist / HyperspaceTerrainPlugin.STORM_STRIKE_SOUND_RANGE;
                    volumeMult = (float)Math.sqrt(volumeMult);
                    if ((volumeMult *= 0.1f * factor) > 0.0f) {
                        Global.getSoundPlayer().playSound("mine_explosion", 1.0f, 1.0f * volumeMult, loc, Misc.ZERO);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RaidDangerLevel {
        NONE("\u65e0", "\u65e0", Misc.getPositiveHighlightColor(), 0.0f, 60.0f, 1),
        MINIMAL("\u6781\u4f4e", "\u6781\u4f4e", Misc.getPositiveHighlightColor(), 0.02f, 50.0f, 1),
        LOW("\u4f4e", "\u8f83\u4f4e", Misc.getPositiveHighlightColor(), 0.04f, 40.0f, 2),
        MEDIUM("\u4e2d\u7b49", "\u666e\u901a", Misc.getHighlightColor(), 0.08f, 30.0f, 3),
        HIGH("\u9ad8", "\u5f88\u9ad8", Misc.getNegativeHighlightColor(), 0.16f, 20.0f, 5),
        EXTREME("\u6781\u9ad8", "\u6781\u9ad8", Misc.getNegativeHighlightColor(), 0.32f, 10.0f, 7);

        private static RaidDangerLevel[] vals;
        public String name;
        public String lossesName;
        public Color color;
        public float marineLossesMult;
        public int marineTokens;
        public float disruptionDays;

        static {
            vals = RaidDangerLevel.values();
        }

        private RaidDangerLevel(String name, String lossesName, Color color, float marineLossesMult, float disruptionDays, int marineTokens) {
            this.name = name;
            this.lossesName = lossesName;
            this.color = color;
            this.marineLossesMult = marineLossesMult;
            this.disruptionDays = disruptionDays;
            this.marineTokens = marineTokens;
        }

        public RaidDangerLevel next() {
            int index = this.ordinal() + 1;
            if (index >= vals.length) {
                index = vals.length - 1;
            }
            return vals[index];
        }

        public RaidDangerLevel prev() {
            int index = this.ordinal() - 1;
            if (index < 0) {
                index = 0;
            }
            return vals[index];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RaidType {
        CUSTOM_ONLY,
        VALUABLE,
        DISRUPT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StationState {
        NONE,
        OPERATIONAL,
        UNDER_CONSTRUCTION,
        REPAIRS;

    }

    public static class TempData {
        public boolean canRaid;
        public boolean canBombard;
        public int bombardCost;
        public int marinesLost;
        public float raidMult;
        public float attackerStr;
        public float defenderStr;
        public boolean nonMarket = false;
        public boolean secret = false;
        public RaidType raidType = null;
        public BombardType bombardType = null;
        public CargoAPI raidLoot;
        public int xpGained;
        public Industry target = null;
        public List<FactionAPI> willBecomeHostile = new ArrayList<FactionAPI>();
        public List<Industry> bombardmentTargets = new ArrayList<Industry>();
        public List<GroundRaidObjectivePlugin> objectives = new ArrayList<GroundRaidObjectivePlugin>();
        public String contText;
        public String raidGoBackTrigger;
        public String raidContinueTrigger;
    }
}

