/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintWreckDescription
extends BaseCommandPlugin {
    public static final String TRAPPED = "$trapped";
    public static final String LOCKED = "$locked";
    public static final String CAN_UNLOCK = "$canUnlock";
    public static final float BREAK_KEEP_FRACTION = 0.5f;
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI cargo;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    private DerelictShipEntityPlugin plugin;
    private Map<String, MemoryAPI> memoryMap;

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        this.memory = PrintWreckDescription.getEntityMemory(memoryMap);
        this.entity = dialog.getInteractionTarget();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.cargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = this.entity.getFaction();
        this.plugin = (DerelictShipEntityPlugin)this.entity.getCustomPlugin();
        ShipRecoverySpecial.PerShipData shipData = this.plugin.getData().ship;
        boolean nameKnown = ShipRecoverySpecial.isNameKnown(shipData.condition);
        ShipVariantAPI variant = shipData.variant;
        if (variant == null && shipData.variantId != null) {
            variant = Global.getSettings().getVariant(shipData.variantId);
        }
        ShipRecoverySpecial.ShipCondition condition = shipData.condition;
        String conStr = "";
        switch (condition) {
            case PRISTINE: {
                conStr = "\u51e0\u8fd1\u65e0\u635f";
                break;
            }
            case GOOD: {
                conStr = "\u60c5\u51b5\u826f\u597d";
                break;
            }
            case AVERAGE: {
                conStr = "\u8f7b\u5fae\u53d7\u635f";
                break;
            }
            case BATTERED: {
                conStr = "\u6709\u4e9b\u5143\u6c14\u5927\u4f24";
                break;
            }
            case WRECKED: {
                conStr = "\u51e0\u4e4e\u5343\u75ae\u767e\u5b54";
            }
        }
        if (variant == null) {
            String str = "\u4e00\u8258\u88ab\u9057\u5f03\u7684\u8230\u8239\uff0c\u5728\u592a\u7a7a\u4e2d\u6f02\u6d41\u3002";
            this.text.addParagraph(str);
        } else {
            String hullType = "";
            ShipHullSpecAPI spec = variant.getHullSpec();
            if (spec.hasHullName()) {
                hullType = String.valueOf(hullType) + spec.getHullNameWithDashClass();
            }
            if (spec.hasDesignation()) {
                if (!hullType.isEmpty()) {
                    hullType = String.valueOf(hullType) + " ";
                }
                hullType = String.valueOf(hullType) + spec.getDesignation().toLowerCase();
            }
            String str = "\u88ab\u9057\u5f03\u7684 " + hullType + "\uff0c\u5728\u592a\u7a7a\u4e2d\u6f02\u6d41\u3002";
            this.text.addParagraph(str);
        }
        this.text.addParagraph("\u8be5\u8230 " + conStr + ", " + "\u867d\u7136\u786e\u5b9a\u53ef\u4ee5\u6253\u635e\uff0c\u4f46\u8fd8\u9700\u8981\u4ed4\u7ec6\u68c0\u67e5\u3002");
        return true;
    }

    public String getString(String format) {
        return Misc.getStringWithTokenReplacement(format, this.entity, this.memoryMap);
    }
}

