/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.FleetAdvanceScript;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageGenFromSeed;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalvageDefenderInteraction
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, final Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        final SectorEntityToken entity = dialog.getInteractionTarget();
        final MemoryAPI memory = SalvageDefenderInteraction.getEntityMemory(memoryMap);
        final CampaignFleetAPI defenders = memory.getFleet("$defenderFleet");
        if (defenders == null) {
            return false;
        }
        dialog.setInteractionTarget(defenders);
        final FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
        config.leaveAlwaysAvailable = true;
        config.showCommLinkOption = false;
        config.showEngageText = false;
        config.showFleetAttitude = false;
        config.showTransponderStatus = false;
        config.showWarningDialogWhenNotHostile = false;
        config.alwaysAttackVsAttack = true;
        config.impactsAllyReputation = true;
        config.impactsEnemyReputation = false;
        config.pullInAllies = false;
        config.pullInEnemies = false;
        config.pullInStations = false;
        config.lootCredits = false;
        config.firstTimeEngageOptionText = "\u6467\u6bc1\u81ea\u52a8\u9632\u5fa1\u7cfb\u7edf";
        config.afterFirstTimeEngageOptionText = "\u91cd\u65b0\u542f\u52a8\u81ea\u52a8\u9632\u5fa1";
        config.noSalvageLeaveOptionText = "\u7ee7\u7eed";
        config.dismissOnLeave = false;
        config.printXPToDialog = true;
        long seed = memory.getLong("$salvageSeed");
        config.salvageRandom = Misc.getRandom(seed, 75);
        final FleetInteractionDialogPluginImpl plugin = new FleetInteractionDialogPluginImpl(config);
        final InteractionDialogPlugin originalPlugin = dialog.getPlugin();
        config.delegate = new FleetInteractionDialogPluginImpl.BaseFIDDelegate(){

            public void notifyLeave(InteractionDialogAPI dialog) {
                defenders.getMemoryWithoutUpdate().clear();
                defenders.clearAssignments();
                defenders.deflate();
                dialog.setPlugin(originalPlugin);
                dialog.setInteractionTarget(entity);
                if (plugin.getContext() instanceof FleetEncounterContext) {
                    FleetEncounterContext context = (FleetEncounterContext)plugin.getContext();
                    if (context.didPlayerWinEncounterOutright()) {
                        SalvageGenFromSeed.SDMParams p = new SalvageGenFromSeed.SDMParams();
                        p.entity = entity;
                        p.factionId = defenders.getFaction().getId();
                        SalvageGenFromSeed.SalvageDefenderModificationPlugin plugin2 = Global.getSector().getGenericPlugins().pickPlugin(SalvageGenFromSeed.SalvageDefenderModificationPlugin.class, p);
                        if (plugin2 != null) {
                            plugin2.reportDefeated(p, entity, defenders);
                        }
                        memory.unset("$hasDefenders");
                        memory.unset("$defenderFleet");
                        memory.set("$defenderFleetDefeated", true);
                        entity.removeScriptsOfClass(FleetAdvanceScript.class);
                        FireBest.fire(null, dialog, memoryMap, "BeatDefendersContinue");
                    } else {
                        boolean persistDefenders = false;
                        if (context.isEngagedInHostilities()) {
                            persistDefenders |= !Misc.getSnapshotMembersLost(defenders).isEmpty();
                            for (FleetMemberAPI member : defenders.getFleetData().getMembersListCopy()) {
                                if (!member.getStatus().needsRepairs()) continue;
                                persistDefenders = true;
                                break;
                            }
                        }
                        if (persistDefenders) {
                            if (!entity.hasScriptOfClass(FleetAdvanceScript.class)) {
                                defenders.setDoNotAdvanceAI(true);
                                defenders.setContainingLocation(entity.getContainingLocation());
                                defenders.setLocation(1000000.0f, 1000000.0f);
                                entity.addScript(new FleetAdvanceScript(defenders));
                            }
                            memory.expire("$defenderFleet", 10.0f);
                        }
                        dialog.dismiss();
                    }
                } else {
                    dialog.dismiss();
                }
            }

            public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                bcc.aiRetreatAllowed = false;
                bcc.objectivesAllowed = false;
                bcc.enemyDeployAll = true;
            }

            public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
                FleetEncounterContextPlugin.DataForEncounterSide winner = context.getWinnerData();
                FleetEncounterContextPlugin.DataForEncounterSide loser = context.getLoserData();
                if (winner == null || loser == null) {
                    return;
                }
                float playerContribMult = context.computePlayerContribFraction();
                ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>();
                ArrayList<SalvageEntityGenDataSpec.DropData> dropValue = new ArrayList<SalvageEntityGenDataSpec.DropData>();
                float valueMultFleet = Global.getSector().getPlayerFleet().getStats().getDynamic().getValue("battle_salvage_value_bonus_fleet");
                float valueModShips = context.getSalvageValueModPlayerShips();
                for (FleetEncounterContextPlugin.FleetMemberData data : winner.getEnemyCasualties()) {
                    if (data.getMember() != null && context.getBattle() != null) {
                        CampaignFleetAPI fleet = context.getBattle().getSourceFleet(data.getMember());
                        if (fleet != null && fleet.getFaction().getId().equals("omega")) {
                            for (String slotId : data.getMember().getVariant().getNonBuiltInWeaponSlots()) {
                                WeaponSpecAPI spec;
                                String weaponId = data.getMember().getVariant().getWeaponId(slotId);
                                if (weaponId == null || salvage.getNumWeapons(weaponId) > 0 || (spec = Global.getSettings().getWeaponSpec(weaponId)).hasTag("no_drop")) continue;
                                salvage.addWeapons(weaponId, 1);
                            }
                        }
                        if (fleet != null && fleet.getFaction().getCustomBoolean("noAICoresFromAutomatedDefenses")) continue;
                    }
                    if (!(config.salvageRandom.nextFloat() < playerContribMult)) continue;
                    SalvageEntityGenDataSpec.DropData drop = new SalvageEntityGenDataSpec.DropData();
                    drop.chances = 1;
                    drop.value = -1;
                    switch (data.getMember().getHullSpec().getHullSize()) {
                        case CAPITAL_SHIP: {
                            drop.group = "ai_cores3";
                            drop.chances = 2;
                            break;
                        }
                        case CRUISER: {
                            drop.group = "ai_cores3";
                            break;
                        }
                        case DESTROYER: {
                            drop.group = "ai_cores2";
                            break;
                        }
                        case FIGHTER: 
                        case FRIGATE: {
                            drop.group = "ai_cores1";
                        }
                    }
                    if (drop.group == null) continue;
                    dropRandom.add(drop);
                }
                float fuelMult = Global.getSector().getPlayerFleet().getStats().getDynamic().getValue("fuel_salvage_value_mult_fleet");
                CargoAPI extra = SalvageEntity.generateSalvage(config.salvageRandom, valueMultFleet + valueModShips, 1.0f, 1.0f, fuelMult, dropValue, dropRandom);
                for (CargoStackAPI stack : extra.getStacksCopy()) {
                    if (stack.isFuelStack()) {
                        stack.setSize((int)(stack.getSize() * fuelMult));
                    }
                    salvage.addFromStack(stack);
                }
            }
        };
        dialog.setPlugin(plugin);
        plugin.init(dialog);
        return true;
    }
}

