/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.academy.GAPZPostEncounters;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZigguratCMD
extends BaseCommandPlugin {
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected MemoryAPI memory;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;

    public ZigguratCMD() {
    }

    public ZigguratCMD(SectorEntityToken entity) {
        this.init(entity);
    }

    protected void init(SectorEntityToken entity) {
        this.memory = entity.getMemoryWithoutUpdate();
        this.entity = entity;
        this.playerFleet = Global.getSector().getPlayerFleet();
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.entity = dialog.getInteractionTarget();
        this.init(this.entity);
        this.memory = ZigguratCMD.getEntityMemory(memoryMap);
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        if (command.equals("initEncounters")) {
            this.initEncounters();
        } else if (command.equals("createSecondDiktatEncounter")) {
            this.createSecondDiktatEncounter();
        } else if (command.equals("abortSecondDiktatEncounter")) {
            this.abortSecondDiktatEncounter();
        } else if (command.equals("updateData")) {
            this.updateData();
        }
        return true;
    }

    protected void updateData() {
        boolean hasZiggurat = false;
        boolean hasNonZiggurat = false;
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
            if (member.getHullSpec().getBaseHullId().equals("ziggurat")) {
                this.memory.set("$zigguratShipName", member.getShipName(), 0.0f);
                this.memory.set("$zigguratMember", member, 0.0f);
                hasZiggurat = true;
                continue;
            }
            hasNonZiggurat = true;
        }
        this.memory.set("$hasZiggurat", hasZiggurat, 0.0f);
        this.memory.set("$hasNonZiggurat", hasNonZiggurat, 0.0f);
        this.memory.set("$hasOnlyZiggurat", hasZiggurat && !hasNonZiggurat, 0.0f);
        this.memory.set("$ttZigBuyPrice", Misc.getWithDGS(2000000.0f), 0.0f);
        this.memory.set("$ttZigLowBuyPrice", Misc.getWithDGS(100000.0f), 0.0f);
    }

    protected void initEncounters() {
        GAPZPostEncounters.init();
    }

    protected void createSecondDiktatEncounter() {
        DelayedFleetEncounter e = GAPZPostEncounters.createSecondDiktatEncounter();
        this.memory.set("$gaPZ_secondDiktatEncounter", e, 0.0f);
    }

    protected void abortSecondDiktatEncounter() {
        DelayedFleetEncounter e = (DelayedFleetEncounter)this.memory.get("$gaPZ_secondDiktatEncounter");
        if (e != null) {
            e.setAlwaysAbort();
        }
    }
}

