/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.util.Misc;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSalvageSpecial
implements SalvageSpecialInteraction.SalvageSpecialPlugin {
    public static final String EXTRA_SALVAGE = "$extraSpecialSalvage";
    public static final String TEMP_EXTRA_SALVAGE = "$tempExtraSpecialSalvage";
    protected boolean done = false;
    protected boolean endWithContinue = true;
    protected InteractionDialogAPI dialog;
    protected Random random;
    protected SectorEntityToken entity;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected Map<String, MemoryAPI> memoryMap;
    protected CampaignFleetAPI playerFleet;
    private boolean showAgain = false;
    private boolean shouldAbortSalvageAndRemoveEntity;

    protected void addTempExtraSalvage(CargoAPI cargo) {
        ExtraSalvage extra = BaseSalvageSpecial.getTempExtraSalvage(this.memoryMap);
        if (extra == null) {
            extra = new ExtraSalvage(cargo);
        } else {
            extra.cargo.addAll(cargo);
        }
        MemoryAPI memory = BaseCommandPlugin.getEntityMemory(this.dialog.getPlugin().getMemoryMap());
        memory.set(TEMP_EXTRA_SALVAGE, extra, 0.0f);
    }

    public static void addExtraSalvage(SectorEntityToken entity, CargoAPI cargo) {
        BaseSalvageSpecial.addExtraSalvage(cargo, entity.getMemoryWithoutUpdate(), -1.0f);
    }

    public static void addExtraSalvage(CargoAPI cargo, MemoryAPI memory, float expire2) {
        ExtraSalvage extra = BaseSalvageSpecial.getExtraSalvage(memory);
        if (extra == null) {
            extra = new ExtraSalvage(cargo);
        } else {
            extra.cargo.addAll(cargo);
        }
        memory.set(EXTRA_SALVAGE, extra, expire2);
    }

    public static CargoAPI getCombinedExtraSalvage(Map<String, MemoryAPI> memoryMap) {
        ExtraSalvage extra = BaseSalvageSpecial.getExtraSalvage(memoryMap);
        ExtraSalvage temp = BaseSalvageSpecial.getTempExtraSalvage(memoryMap);
        CargoAPI cargo = Global.getFactory().createCargo(true);
        if (extra != null && extra.cargo != null) {
            cargo.addAll(extra.cargo);
        }
        if (temp != null && temp.cargo != null) {
            cargo.addAll(temp.cargo);
        }
        return cargo;
    }

    public static CargoAPI getCombinedExtraSalvage(SectorEntityToken entity) {
        ExtraSalvage extra = BaseSalvageSpecial.getExtraSalvage(entity);
        ExtraSalvage temp = BaseSalvageSpecial.getTempExtraSalvage(entity);
        CargoAPI cargo = Global.getFactory().createCargo(true);
        if (extra != null && extra.cargo != null) {
            cargo.addAll(extra.cargo);
        }
        if (temp != null && temp.cargo != null) {
            cargo.addAll(temp.cargo);
        }
        return cargo;
    }

    public static ExtraSalvage getTempExtraSalvage(SectorEntityToken entity) {
        return BaseSalvageSpecial.getTempExtraSalvage(entity.getMemoryWithoutUpdate());
    }

    public static ExtraSalvage getExtraSalvage(SectorEntityToken entity) {
        return BaseSalvageSpecial.getExtraSalvage(entity.getMemoryWithoutUpdate());
    }

    public static ExtraSalvage getExtraSalvage(MemoryAPI memory) {
        if (memory.contains(EXTRA_SALVAGE)) {
            return (ExtraSalvage)memory.get(EXTRA_SALVAGE);
        }
        return null;
    }

    public static ExtraSalvage getTempExtraSalvage(MemoryAPI memory) {
        if (memory.contains(TEMP_EXTRA_SALVAGE)) {
            return (ExtraSalvage)memory.get(TEMP_EXTRA_SALVAGE);
        }
        return null;
    }

    public static ExtraSalvage getTempExtraSalvage(Map<String, MemoryAPI> memoryMap) {
        MemoryAPI memory = BaseCommandPlugin.getEntityMemory(memoryMap);
        return BaseSalvageSpecial.getTempExtraSalvage(memory);
    }

    public static ExtraSalvage getExtraSalvage(Map<String, MemoryAPI> memoryMap) {
        MemoryAPI memory = BaseCommandPlugin.getEntityMemory(memoryMap);
        return BaseSalvageSpecial.getExtraSalvage(memory);
    }

    public static void clearExtraSalvage(Map<String, MemoryAPI> memoryMap) {
        MemoryAPI memory = BaseCommandPlugin.getEntityMemory(memoryMap);
        BaseSalvageSpecial.clearExtraSalvage(memory);
    }

    public static void clearExtraSalvage(MemoryAPI memory) {
        memory.unset(EXTRA_SALVAGE);
        memory.unset(TEMP_EXTRA_SALVAGE);
    }

    public static void clearExtraSalvage(SectorEntityToken entity) {
        BaseSalvageSpecial.clearExtraSalvage(entity.getMemoryWithoutUpdate());
    }

    @Override
    public void init(InteractionDialogAPI dialog, Object specialData) {
        this.dialog = dialog;
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.memoryMap = dialog.getPlugin().getMemoryMap();
        this.entity = dialog.getInteractionTarget();
        MemoryAPI memory = BaseCommandPlugin.getEntityMemory(dialog.getPlugin().getMemoryMap());
        long seed = memory.getLong("$salvageSeed");
        this.random = seed == 0L ? new Random() : Misc.getRandom(seed, 50);
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
    }

    public void initNothing() {
        this.setDone(true);
        this.setEndWithContinue(false);
        this.setShowAgain(false);
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public boolean endWithContinue() {
        return this.endWithContinue;
    }

    public void setEndWithContinue(boolean endWithContinue) {
        this.endWithContinue = endWithContinue;
    }

    public String getString(String format) {
        return Misc.getStringWithTokenReplacement(format, this.entity, this.memoryMap);
    }

    public void addText(String format) {
        this.text.addParagraph(this.getString(format));
    }

    @Override
    public boolean shouldShowAgain() {
        return this.showAgain;
    }

    public void setShowAgain(boolean showAgain) {
        this.showAgain = showAgain;
    }

    @Override
    public boolean shouldAbortSalvageAndRemoveEntity() {
        return this.shouldAbortSalvageAndRemoveEntity;
    }

    public void setShouldAbortSalvageAndRemoveEntity(boolean shouldAbortSalvageAndRemoveEntity) {
        this.shouldAbortSalvageAndRemoveEntity = shouldAbortSalvageAndRemoveEntity;
    }

    public static class ExtraSalvage {
        public CargoAPI cargo;

        public ExtraSalvage(CargoAPI cargo) {
            this.cargo = cargo;
        }
    }
}

