/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import java.util.ArrayList;
import java.util.Random;

public class BlueprintSpecial
extends BaseSalvageSpecial {
    public static float MAX_RANGE = 16000.0f;
    protected BlueprintSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (BlueprintSpecialData)specialData;
        CargoAPI bp = this.generateBP(this.random);
        bp.sort();
        if (bp.getStacksCopy().size() <= 0) {
            this.initNothing();
        } else {
            this.initBP(bp.getStacksCopy().get(0));
        }
    }

    public void initNothing() {
        this.addText("\u4f60\u7684\u6253\u635e\u4eba\u5458\u627e\u5230\u4e86\u4e00\u4e2a\u770b\u4f3c\u4fdd\u5b58\u5b8c\u597d\u7684\u4fdd\u9669\u7bb1\uff0c\u4f46\u4e0d\u5e78\u7684\u662f\uff0c\u91cc\u9762\u7a7a\u65e0\u4e00\u7269\u3002");
        this.setDone(true);
    }

    protected void initBP(CargoStackAPI stack) {
        if (!stack.isSpecialStack()) {
            this.initNothing();
            return;
        }
        this.addText("\u4f60\u7684\u6253\u635e\u4eba\u5458\u5728\u4e00\u5904\u85cf\u533f\u70b9\u5185\u53d1\u73b0\u4e86\u4e00\u4e2a\u4fdd\u9669\u7bb1\uff0c\u5728\u7535\u78c1\u8109\u51b2\u4e0e\u7b49\u79bb\u5b50\u5207\u5272\u5668\u7684\u7d27\u5bc6\u914d\u5408\u4e0b\uff0c\u4f60\u6210\u529f\u83b7\u5f97\u4e86\u7bb1\u5185\u7684\u7269\u54c1\u3002");
        this.playerFleet.getCargo().addFromStack(stack);
        AddRemoveCommodity.addStackGainText(stack, this.text, false);
        this.setDone(true);
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public CargoAPI generateBP(Random random) {
        ArrayList<SalvageEntityGenDataSpec.DropData> dropRandom = new ArrayList<SalvageEntityGenDataSpec.DropData>();
        SalvageEntityGenDataSpec.DropData d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "blueprints_guaranteed";
        dropRandom.add(d);
        CargoAPI result = SalvageEntity.generateSalvage(random, 1.0f, 1.0f, 1.0f, 1.0f, null, dropRandom);
        return result;
    }

    public static class BlueprintSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new BlueprintSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SurveyDataSpecialType {
        SCRAMBLED,
        PLANET_INTERESTING_PROPERTY,
        PLANET_SURVEY_DATA,
        SYSTEM_PRELIMINARY_SURVEY,
        AUTO_PICK,
        AUTO_PICK_NOT_SYSTEM;

    }
}

