/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbSpecial
extends BaseSalvageSpecial {
    private BreadcrumbSpecialData data;

    @Override
    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (BreadcrumbSpecialData)specialData;
        this.initEntityLocation();
    }

    private void initEntityLocation() {
        if (this.data.targetId == null) {
            this.initNothing();
            return;
        }
        SectorEntityToken target = Global.getSector().getEntityById(this.data.targetId);
        if (target == null) {
            this.initNothing();
            return;
        }
        if (!target.hasSensorProfile() && !target.isDiscoverable()) {
            this.initNothing();
            return;
        }
        String targetName = BreadcrumbSpecial.getNameWithAOrAn(target, this.data.targetName, true, false);
        String targetNameUC = BreadcrumbSpecial.getNameWithAOrAn(target, this.data.targetName, false, true);
        String located = BreadcrumbSpecial.getLocatedString(target, true);
        String nameForTitle = targetNameUC.substring(targetNameUC.indexOf(" ") + 1);
        String subject = this.getString("\u4f4d\u7f6e\uff1a" + nameForTitle);
        String text1 = " $shortName \u7684\u5b58\u50a8\u4f53\u4ecd\u6709\u4e00\u90e8\u5206\u53ef\u4ee5\u8bbf\u95ee\uff0c";
        text1 = String.valueOf(text1) + "\u5176\u4e2d\u5305\u542b\u7684\u4fe1\u606f\u663e\u793a" + targetName + "\u76ee\u524d" + located + "\u3002";
        String text1ForIntel = "\u5728\u63a2\u67e5\u4e00\u5904$nameInText\u7684\u8fc7\u7a0b\u4e2d\uff0c\u4f60\u7684\u8239\u5458\u53d1\u73b0\u4e86\u4e00\u4e2a\u4ecd\u90e8\u5206\u80fd\u6b63\u5e38\u8bbf\u95ee\u7684\u5b58\u50a8\u4f53\u3002\u5176\u4e2d\u5305\u542b\u7684\u4fe1\u606f\u663e\u793a" + targetName + "\u76ee\u524d" + located + "\u3002";
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "\u4f60\u7684\u6253\u635e\u4eba\u5458\u5728\u6b8b\u9ab8\u4e2d\u627e\u5230\u4e00\u4e2a\u8fd8\u80fd\u5de5\u4f5c\u7684\u5b58\u50a8\u4f53\u3002\u5b83\u5176\u4e2d\u5305\u542b\u7684\u4fe1\u606f\u663e\u793a" + targetName.toLowerCase() + "\u76ee\u524d" + located + "\u3002";
        }
        if (target.getCustomPlugin() instanceof DerelictShipEntityPlugin) {
            DerelictShipEntityPlugin dsep = (DerelictShipEntityPlugin)target.getCustomPlugin();
            ShipVariantAPI variant = dsep.getData().ship.variant;
            if (variant == null && dsep.getData().ship.variantId != null) {
                variant = Global.getSettings().getVariant(dsep.getData().ship.variantId);
            }
            if (variant != null) {
                String size = null;
                size = variant.getHullSize() == ShipAPI.HullSize.FRIGATE || variant.getHullSize() == ShipAPI.HullSize.DESTROYER ? "\u6839\u636e\u6240\u83b7\u4fe1\u606f\u8868\u660e\uff0c\u8fd9\u8258\u8239\u6700\u591a\u662f\u8258\u62a4\u536b\u8230\u6216\u9a71\u9010\u8230\u3002" : "\u8fd9\u8258\u8239\u81f3\u5c11\u662f\u8258\u5de1\u6d0b\u8230\u3002";
                if (size != null) {
                    text1 = String.valueOf(text1) + "\n\n" + size;
                    text1ForIntel = String.valueOf(text1ForIntel) + "\n\n" + size;
                }
            }
        }
        this.addText(text1);
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, target);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(text1ForIntel));
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    public static String getNameWithAOrAn(SectorEntityToken target, String override, boolean lowercaseDebris, boolean forTitle) {
        String targetAOrAn = "\u4e00\u4e2a";
        String targetName = override;
        if (targetName == null) {
            if (target instanceof CustomCampaignEntityAPI) {
                CustomCampaignEntityAPI custom = (CustomCampaignEntityAPI)target;
                targetName = custom.getCustomEntitySpec().getNameInText();
                if (forTitle) {
                    targetName = custom.getName();
                }
                targetAOrAn = custom.getCustomEntitySpec().getAOrAn();
            } else if (target instanceof PlanetAPI) {
                PlanetAPI planet = (PlanetAPI)target;
                targetName = planet.getTypeNameWithLowerCaseWorld().toLowerCase();
                if (forTitle) {
                    targetName = planet.getTypeNameWithWorld();
                }
                targetAOrAn = planet.getSpec().getAOrAn();
            } else {
                targetName = target.getName();
            }
        }
        if (lowercaseDebris && target.hasTag("debris")) {
            targetName = targetName.toLowerCase();
        }
        return String.valueOf(targetAOrAn) + " " + targetName;
    }

    public static String getLocatedString(SectorEntityToken target) {
        return BreadcrumbSpecial.getLocatedString(target, false);
    }

    public static String getLocatedString(SectorEntityToken target, boolean withSystem) {
        String terrainString;
        String loc = BreadcrumbSpecial.getLocationDescription(target, withSystem);
        String orbiting = "";
        boolean useTerrain = false;
        if (target.getOrbitFocus() != null) {
            if (target.getOrbitFocus() instanceof PlanetAPI) {
                boolean isPrimary;
                PlanetAPI focus = (PlanetAPI)target.getOrbitFocus();
                boolean bl = isPrimary = target.getContainingLocation() instanceof StarSystemAPI && focus == ((StarSystemAPI)target.getContainingLocation()).getStar();
                if (!focus.isStar() || !isPrimary) {
                    orbiting = "\u6b63\u6cbf\u8f68\u9053\u73af\u7ed5\u4e8e " + focus.getSpec().getAOrAn() + " " + focus.getTypeNameWithLowerCaseWorld().toLowerCase() + "\u9644\u8fd1";
                } else {
                    float dist = Misc.getDistance(focus.getLocation(), target.getLocation());
                    orbiting = dist < 3000.0f ? "\u6b63\u5728\u661f\u7cfb\u4e2d\u5fc3\u9644\u8fd1\u67d0\u5904" : (dist > 12000.0f ? "\u6b63\u5728\u661f\u7cfb\u5916\u56f4\u67d0\u5904" : "\u6b63\u5728\u8ddd\u661f\u7cfb\u4e2d\u5fc3\u6709\u4e00\u6bb5\u8ddd\u79bb\u7684\u67d0\u5904");
                    useTerrain = true;
                }
            } else if (target.getOrbitFocus() instanceof CustomCampaignEntityAPI) {
                CustomCampaignEntityAPI custom = (CustomCampaignEntityAPI)target.getOrbitFocus();
                orbiting = "\u6b63\u6cbf\u8f68\u9053\u73af\u7ed5\u4e8e " + custom.getCustomEntitySpec().getAOrAn() + " " + custom.getCustomEntitySpec().getNameInText() + "\u9644\u8fd1";
            } else if (target.getOrbitFocus() instanceof JumpPointAPI) {
                orbiting = "\u6b63\u5728\u6cbf\u8f68\u9053\u8fd0\u884c\u5728\u8df3\u8dc3\u70b9\u9644\u8fd1";
            } else if (target.getOrbitFocus() instanceof CampaignTerrainAPI) {
                CampaignTerrainAPI t = (CampaignTerrainAPI)target.getOrbitFocus();
                String n = t.getPlugin().getNameForTooltip().toLowerCase();
                String \u4e00\u4e2a = Misc.getAOrAnFor(n);
                orbiting = "\u6b63\u5728" + \u4e00\u4e2a + " " + n + " ";
                float dist = Misc.getDistance(new Vector2f(), target.getLocation());
                orbiting = dist < 3000.0f ? String.valueOf(orbiting) + "\u4e2d\u5fc3\u67d0\u5904" : (dist > 12000.0f ? String.valueOf(orbiting) + "\u5916\u56f4\u67d0\u5904" : String.valueOf(orbiting) + "\u4e2d\u5fc3\u4ee5\u5916\u6709\u4e00\u6bb5\u8ddd\u79bb\u7684\u67d0\u5904");
            } else {
                float dist = Misc.getDistance(new Vector2f(), target.getLocation());
                orbiting = dist < 3000.0f ? "\u6b63\u5728\u661f\u7cfb\u4e2d\u5fc3\u9644\u8fd1\u67d0\u5904" : (dist > 12000.0f ? "\u6b63\u5728\u661f\u7cfb\u5916\u56f4\u67d0\u5904" : "\u6b63\u5728\u8ddd\u661f\u7cfb\u4e2d\u5fc3\u6709\u4e00\u6bb5\u8ddd\u79bb\u7684\u67d0\u5904");
                useTerrain = true;
            }
        } else if (target.getContainingLocation() != null && target.getContainingLocation().isNebula()) {
            float dist = Misc.getDistance(new Vector2f(), target.getLocation());
            orbiting = dist < 3000.0f ? "\u6b63\u5728\u661f\u7cfb\u4e2d\u5fc3\u9644\u8fd1\u67d0\u5904" : (dist > 12000.0f ? "\u6b63\u5728\u661f\u7cfb\u5916\u56f4\u67d0\u5904" : "\u6b63\u5728\u8ddd\u661f\u7cfb\u4e2d\u5fc3\u6709\u4e00\u6bb5\u8ddd\u79bb\u7684\u67d0\u5904");
            useTerrain = true;
        }
        if (useTerrain && (terrainString = BreadcrumbSpecial.getTerrainString(target)) != null) {
            orbiting = "\u6b63\u5728" + terrainString + "\u9644\u8fd1";
        }
        if (orbiting == null || orbiting.isEmpty()) {
            orbiting = "\u6b63\u5728";
        }
        return String.valueOf(orbiting) + loc;
    }

    public static String getTerrainString(SectorEntityToken entity) {
        if (!(entity.getContainingLocation() instanceof StarSystemAPI)) {
            return null;
        }
        StarSystemAPI system = (StarSystemAPI)entity.getContainingLocation();
        for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
            if (!terrain.getPlugin().containsEntity(entity)) continue;
            String type = terrain.getType();
            if ("asteroid_belt".equals(type)) {
                return "\u67d0\u4e2a\u5c0f\u884c\u661f\u5e26";
            }
            if ("asteroid_field".equals(type)) {
                return "\u67d0\u4e2a\u5c0f\u884c\u661f\u7fa4";
            }
            if (terrain.hasTag("accretion_disk")) {
                return "\u67d0\u4e2a\u5438\u79ef\u76d8";
            }
            if (!"ring".equals(type)) continue;
            return "\u67d0\u4e2a\u884c\u661f\u73af";
        }
        return null;
    }

    public static String getLocationDescription(SectorEntityToken entity, boolean withSystem) {
        LocationAPI loc = entity.getContainingLocation();
        if (loc == null) {
            return "\u67d0\u4e2a\u672a\u77e5\u7684\u4f4d\u7f6e";
        }
        if (loc.isHyperspace()) {
            return "\u8d85\u7a7a\u95f4";
        }
        StarSystemAPI system = (StarSystemAPI)loc;
        if (withSystem || entity.getConstellation() == null || entity.getConstellation().getSystems().size() == 1 || entity.isInCurrentLocation()) {
            return "\uff0c\u4f4d\u4e8e " + system.getNameWithLowercaseType();
        }
        Constellation c = entity.getConstellation();
        String cText = "\uff0c\u5750\u843d\u4e8e " + c.getNameWithLowercaseType();
        if (c.getSystems().size() == 1) {
            return "\uff0c\u4f4d\u4e8e " + system.getNameWithLowercaseType();
        }
        if (system.isNebula()) {
            return "\uff0c\u4f4d\u4e8e\u4e00\u7247\u661f\u4e91\u5185" + cText;
        }
        if (system.getTertiary() != null) {
            return "\uff0c\u4f4d\u4e8e\u4e00\u4e2a\u4e09\u661f\u7cfb\u7edf\u5185" + cText;
        }
        if (system.getSecondary() != null) {
            return "\uff0c\u4f4d\u4e8e\u4e00\u4e2a\u53cc\u661f\u7cfb\u7edf\u5185" + cText;
        }
        PlanetAPI star = system.getStar();
        if (star != null) {
            if (star.getSpec().isBlackHole()) {
                return "\uff0c\u4f4d\u4e8e\u4e00\u4e2a\u9ed1\u6d1e\u661f\u7cfb\u5185" + cText;
            }
            String type = BreadcrumbSpecial.getStarTypeName(star);
            String color = BreadcrumbSpecial.getStarColorName(star);
            String sysText = null;
            CountingMap<String> counts = BreadcrumbSpecial.getTypeAndColorCounts(c);
            int cColor = counts.getCount(color);
            int cType = counts.getCount(type);
            if (cColor > 1 && cType > cColor) {
                sysText = "\uff0c\u4f4d\u4e8e\u4e00\u4e2a\u62e5\u6709" + star.getSpec().getAOrAn() + " " + color + "\u4e3b\u661f\u7684\u661f\u7cfb\u5185";
            } else if (cType > 0) {
                sysText = "\uff0c\u4f4d\u4e8e\u4e00\u4e2a\u62e5\u6709" + type + "\u4e3b\u661f\u7684\u661f\u7cfb\u5185";
            } else if (cColor > 0) {
                sysText = "\uff0c\u4f4d\u4e8e\u4e00\u4e2a\u62e5\u6709" + star.getSpec().getAOrAn() + " " + color + "\u4e3b\u661f\u7684\u661f\u7cfb\u5185";
            }
            if (sysText != null) {
                return String.valueOf(sysText) + cText;
            }
        }
        return "\uff0c\u4f4d\u4e8e " + system.getNameWithLowercaseType() + " " + cText;
    }

    public static CountingMap<String> getTypeAndColorCounts(Constellation c) {
        CountingMap<String> map = new CountingMap<String>();
        for (StarSystemAPI system : c.getSystems()) {
            PlanetAPI star = system.getStar();
            if (system.isNebula() || system.getSecondary() != null || system.getTertiary() != null) continue;
            String type = BreadcrumbSpecial.getStarTypeName(star);
            String color = BreadcrumbSpecial.getStarColorName(star);
            if (type != null) {
                map.add(type);
            }
            if (color == null) continue;
            map.add(color);
        }
        return map;
    }

    public static String getStarTypeName(PlanetAPI star) {
        String name = star.getSpec().getName().toLowerCase();
        if (name.contains(" \u77ee\u661f")) {
            return "\u77ee\u661f";
        }
        if (name.contains(" \u6052\u661f")) {
            return null;
        }
        if (name.contains(" \u5de8\u661f")) {
            return "\u5de8\u884c\u661f";
        }
        if (name.contains(" \u8d85\u5de8\u661f")) {
            return "\u8d85\u5de8\u661f";
        }
        return null;
    }

    public static String getStarColorName(PlanetAPI star) {
        String name = star.getSpec().getName().toLowerCase();
        if (name.contains(" \u77ee\u661f")) {
            name = name.replace(" \u77ee\u661f", "");
        } else if (name.contains(" \u6052\u661f")) {
            name = name.replace(" \u6052\u661f", "");
        } else if (name.contains(" \u5de8\u661f")) {
            name = name.replace(" \u5de8\u661f", "");
        } else if (name.contains(" \u8d85\u5de8\u661f")) {
            name = name.replace(" \u8d85\u5de8\u661f", "");
        }
        if (!name.equals(star.getSpec().getName().toLowerCase())) {
            return name;
        }
        return null;
    }

    @Override
    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public static class BreadcrumbSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public String targetId = null;
        public String targetName = null;

        public BreadcrumbSpecialData(String targetId) {
            this.targetId = targetId;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new BreadcrumbSpecial();
        }
    }
}

