/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;

public class CargoManifestSpecial
extends BaseSalvageSpecial {
    private CargoManifestSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (CargoManifestSpecialData)specialData;
        this.initManifest();
    }

    private void initManifest() {
        CommoditySpecAPI spec = Global.getSettings().getCommoditySpec(this.data.commodityId);
        if (spec == null) {
            this.initNothing();
            return;
        }
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        String name = "\u4e00\u6279\u9001\u5f80 $shortName \u7684\u8d27\u7269\u6e05\u5355\u4e2d\uff0c";
        if (debris) {
            name = "\u6253\u635e\u5e9f\u589f\u65f6\u53d1\u73b0\u4e86\u4e00\u4efd\u8d27\u7269\u6e05\u5355\uff0c";
        }
        if (this.entity instanceof PlanetAPI) {
            name = "\u4e00\u6279\u9001\u5f80\u5730\u8868\u7684\u8d27\u7269\u6e05\u5355\u4e2d\uff0c";
        }
        String text1 = "\u6253\u635e\u4eba\u5458\u5728" + name + "\u53d1\u73b0\u6709" + "\u4e00\u5b9a\u6570\u91cf\u7684 " + spec.getName().toLowerCase() + ", " + "\u5982\u679c\u8fdb\u884c\u9002\u5f53\u7684\u641c\u5bfb\u5de5\u4f5c\uff0c\u5c31\u5e94\u8be5\u53ef\u4ee5\u627e\u5230\u3002";
        this.addText(text1);
        CargoAPI extra = Global.getFactory().createCargo(true);
        float quantity = this.data.min + (this.data.max - this.data.min) * this.random.nextFloat();
        quantity = Math.round(quantity);
        extra.addCommodity(this.data.commodityId, quantity);
        this.addTempExtraSalvage(extra);
        this.setDone(true);
        this.setShowAgain(true);
    }

    public static class CargoManifestSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public String commodityId = null;
        public float min;
        public float max;

        public CargoManifestSpecialData(String commodityId, float min, float max) {
            this.commodityId = commodityId;
            this.min = min;
            this.max = max;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new CargoManifestSpecial();
        }
    }
}

