/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;

public class DomainSurveyDerelictSpecial
extends BaseSalvageSpecial {
    private DomainSurveyDerelictSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        SectorEntityToken entity;
        super.init(dialog, specialData);
        this.data = (DomainSurveyDerelictSpecialData)specialData;
        if (this.data.entityId != null && (entity = Global.getSector().getEntityById(this.data.entityId)) == null) {
            this.data.entityId = null;
            this.data.type = SpecialType.SCRAMBLED;
        }
        switch (this.data.type) {
            case SCRAMBLED: {
                this.initNothing();
                break;
            }
            case LOCATION_SURVEY_SHIP: {
                this.initSurveyParentEntity();
                break;
            }
            case LOCATION_MOTHERSHIP: {
                this.initSurveyParentEntity();
            }
        }
    }

    public boolean shouldShowAgain() {
        return this.data != null && (this.data.type == SpecialType.ACTIVATE_PROBE || this.data.type == SpecialType.ACTIVATE_SURVEY_SHIP);
    }

    private void initSurveyParentEntity() {
        if (this.data.entityId == null) {
            this.initNothing();
            return;
        }
        SectorEntityToken parent = Global.getSector().getEntityById(this.data.entityId);
        if (parent == null || !parent.hasSensorProfile()) {
            this.initNothing();
            return;
        }
        String text1 = " $shortName\u7684\u5b58\u50a8\u4f53\u4ecd\u6709\u4e00\u90e8\u5206\u53ef\u4ee5\u8bbf\u95ee\uff0c\u4e14";
        String text1ForIntel = "\u5728\u63a2\u7d22\u4e00\u5904$nameInText\u65f6\uff0c\u4f60\u7684\u8239\u5458\u53d1\u73b0\u4e86\u4e00\u4e2a\u4ecd\u90e8\u5206\u80fd\u6b63\u5e38\u8bbf\u95ee\u7684\u5b58\u50a8\u4f53\uff0c";
        String name = parent.getCustomEntitySpec().getNameInText();
        String nameForTitle = parent.getCustomEntitySpec().getDefaultName();
        String subject = this.getString("\u5e9f\u5f03\u7684" + nameForTitle + "\u7684\u4f4d\u7f6e");
        text1 = String.valueOf(text1) + "\u5176\u4e2d\u5305\u542b\u7684\u4fe1\u606f\u80fd\u5b9a\u4f4d\u67d0\u4e2a" + name + "\u3002";
        text1ForIntel = String.valueOf(text1ForIntel) + "\u5176\u4e2d\u5305\u542b\u7684\u4fe1\u606f\u80fd\u5b9a\u4f4d\u67d0\u4e2a" + name + "\u3002";
        String located = BreadcrumbSpecial.getLocatedString(parent, true);
        text1 = String.valueOf(text1) + "\u8be5$shortName\u5728\u6700\u540e\u4e00\u6b21\u53d1\u73b0\u5b83\u65f6" + located + "\u3002";
        text1ForIntel = String.valueOf(text1ForIntel) + "\u8be5$shortName\u5728\u6700\u540e\u4e00\u6b21\u53d1\u73b0\u5b83\u65f6" + located + "\u3002";
        text1 = this.getString(text1);
        this.addText(text1);
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, parent);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(text1ForIntel));
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    public void initNothing() {
        this.addText(" $shortName \u7684\u8bb0\u5fc6\u5e93\u88ab\u9ad8\u5f3a\u5ea6\u7535\u79bb\u8f90\u5c04\u6e05\u96f6\u4e86\uff0c\u800c\u4e14\u5927\u90e8\u5206\u7cfb\u7edf\u90fd\u5df2\u7ecf\u5931\u53bb\u529f\u80fd\u65e0\u6cd5\u8fd0\u4f5c\u3002");
        this.setDone(true);
    }

    public static String getLocationName(SectorEntityToken entity) {
        LocationAPI loc = entity.getContainingLocation();
        if (loc == null) {
            return "\u5728\u8ddd\u79bb\u8be5\u5904\u4e0d\u8fdc\u7684\u67d0\u4e2a\u4f4d\u7f6e";
        }
        if (loc.isHyperspace()) {
            return "\u5728\u8ddd\u79bb\u8be5\u5904\u4e0d\u8fdc\u7684\u8d85\u7a7a\u95f4\u5185";
        }
        StarSystemAPI system = (StarSystemAPI)loc;
        if (system == Global.getSector().getCurrentLocation()) {
            if (system.isNebula()) {
                return "\u8fd9\u4e2a\u661f\u4e91\u5185";
            }
            return "\u5728\u8fd9\u4e2a\u661f\u7cfb\u4e2d";
        }
        return "\uff0c\u4f4d\u4e8e" + system.getNameWithLowercaseType();
    }

    public static String getLocationDescription(SectorEntityToken entity) {
        LocationAPI loc = entity.getContainingLocation();
        if (loc == null) {
            return "\u5728\u8ddd\u79bb\u8be5\u5904\u4e0d\u8fdc\u7684\u67d0\u4e2a\u4f4d\u7f6e";
        }
        if (loc.isHyperspace()) {
            return "\u5728\u8ddd\u79bb\u8be5\u5904\u4e0d\u8fdc\u7684\u8d85\u7a7a\u95f4\u5185";
        }
        StarSystemAPI system = (StarSystemAPI)loc;
        if (system == Global.getSector().getCurrentLocation()) {
            if (system.isNebula()) {
                return "\u8fd9\u4e2a\u661f\u4e91\u5185";
            }
            return "\u5728\u8fd9\u4e2a\u661f\u7cfb\u4e2d";
        }
        if (entity.getConstellation() != null && entity.getConstellation() != Global.getSector().getCurrentLocation().getConstellation()) {
            Constellation c = entity.getConstellation();
            String cText = "\uff0c\u4f4d\u4e8e" + c.getNameWithLowercaseType();
            if (c.getSystems().size() == 1) {
                return "\u6b63\u6cbf\u8f68\u9053\u73af\u7ed5\u4e8e " + DomainSurveyDerelictSpecial.getStarDescription(system.getStar()) + "\uff0c\u5728\u8ddd\u6b64\u4e0d\u8fdc\u5904";
            }
            if (system.isNebula()) {
                return "\u5728\u4e00\u7247\u661f\u4e91\u5185 " + cText;
            }
            if (system.getTertiary() != null) {
                return "\u5728\u4e00\u4e2a\u4e09\u661f\u7cfb\u7edf\u4e2d " + cText;
            }
            if (system.getSecondary() != null) {
                return "\u5728\u4e00\u4e2a\u53cc\u661f\u7cfb\u7edf\u4e2d " + cText;
            }
            return "\u6b63\u6cbf\u8f68\u9053\u73af\u7ed5\u4e8e " + DomainSurveyDerelictSpecial.getStarDescription(system.getStar()) + " " + cText;
        }
        if (system.isNebula()) {
            return "\u9644\u8fd1\u7684\u4e00\u7247\u661f\u4e91\u5185";
        }
        if (system.getTertiary() != null) {
            return "\u5728\u9644\u8fd1\u7684\u4e00\u4e2a\u4e09\u661f\u7cfb\u7edf\u5185";
        }
        if (system.getSecondary() != null) {
            return "\u5728\u9644\u8fd1\u7684\u4e00\u4e2a\u53cc\u661f\u7cfb\u7edf\u5185";
        }
        return "\u6b63\u6cbf\u8f68\u9053\u73af\u7ed5\u4e8e " + DomainSurveyDerelictSpecial.getStarDescription(system.getStar()) + "\uff0c\u5728\u8ddd\u6b64\u4e0d\u8fdc\u5904";
    }

    public static String getStarDescription(PlanetAPI star) {
        String type = star.getTypeId();
        if (type.equals("black_hole")) {
            return "\u4e00\u4e2a\u9ed1\u6d1e";
        }
        if (type.equals("star_neutron")) {
            return "\u4e00\u9897\u4e2d\u5b50\u661f";
        }
        if (type.equals("star_orange") || type.equals("star_orange_giant")) {
            return "\u4e00\u9897\u6a59\u8272\u7684\u6052\u661f";
        }
        if (type.equals("star_red_dwarf") || type.equals("star_red_supergiant") || type.equals("star_red_giant")) {
            return "\u4e00\u9897\u7ea2\u8272\u7684\u6052\u661f";
        }
        if (type.equals("star_blue_giant") || type.equals("star_blue_supergiant")) {
            return "\u4e00\u9897\u84dd\u8272\u7684\u6052\u661f";
        }
        if (type.equals("star_browndwarf") || type.equals("star_white")) {
            return "\u4e00\u9897\u660f\u6697\u7684\u6052\u661f";
        }
        if (type.equals("star_yellow")) {
            return "\u4e00\u9897\u9ec4\u8272\u7684\u6052\u661f";
        }
        return "\u4e00\u9897\u672a\u77e5\u7c7b\u578b\u7684\u6052\u661f";
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
        if ("continue".equals(optionData)) {
            this.setDone(true);
        }
    }

    public boolean endWithContinue() {
        return super.endWithContinue();
    }

    public static class DomainSurveyDerelictSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SpecialType type = SpecialType.SCRAMBLED;
        public String entityId = null;
        public String secondaryId = null;

        public DomainSurveyDerelictSpecialData(SpecialType type) {
            this.type = type;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new DomainSurveyDerelictSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecialType {
        SCRAMBLED,
        LOCATION_SURVEY_SHIP,
        LOCATION_MOTHERSHIP,
        ACTIVATE_PROBE,
        ACTIVATE_SURVEY_SHIP;

    }
}

