/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetMemberPickerListener;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireBest;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;

public class ShipRecoverySpecial
extends BaseSalvageSpecial {
    public static final String RECOVER = "recover";
    public static final String NOT_NOW = "not_now";
    public static final String RECOVERY_FINISHED = "finished";
    public static final String ABORT_CONTINUE = "abort_continue";
    protected ShipRecoverySpecialData data;
    protected List<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>();
    protected List<FleetMemberAPI> recovered = new ArrayList<FleetMemberAPI>();
    protected FleetMemberAPI first = null;

    public static ShipRecoverySpecialData getSpecialData(SectorEntityToken entity, String desc, boolean create, boolean replace) {
        Object o = Misc.getSalvageSpecial(entity);
        ShipRecoverySpecialData data = null;
        if (o instanceof ShipRecoverySpecialData) {
            data = (ShipRecoverySpecialData)o;
        }
        if (data == null && !create) {
            return null;
        }
        if (o != null && data == null && !replace) {
            return null;
        }
        if (data == null) {
            data = new ShipRecoverySpecialData(desc);
            Misc.setSalvageSpecial(entity, data);
        }
        return data;
    }

    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (ShipRecoverySpecialData)specialData;
        if (this.data.ships.isEmpty()) {
            this.initNothing();
        } else {
            this.init();
        }
    }

    protected void init() {
        this.members.clear();
        for (PerShipData curr : this.data.ships) {
            this.addMember(curr);
        }
        if (this.members.isEmpty()) {
            this.initNothing();
            return;
        }
        CampaignFleetAPI recoverable = Global.getFactory().createEmptyFleet("neutral", "patrolSmall", true);
        for (FleetMemberAPI member : this.members) {
            recoverable.getFleetData().addFleetMember(member);
        }
        if (recoverable.getFleetData().getMembersListCopy().size() == 1) {
            this.visual.showFleetMemberInfo(recoverable.getFleetData().getMembersListCopy().get(0), true);
        } else {
            this.visual.showFleetInfo("\u4f60\u7684\u8230\u961f", this.playerFleet, "\u53ef\u6062\u590d\u8230\u8239", recoverable, null, true);
        }
        this.addInitialText();
        if (this.isStoryPointRecovery()) {
            this.addStoryOptions();
        } else {
            this.options.clearOptions();
            this.options.addOption("\u8003\u8651\u6062\u590d\u8230\u8239", RECOVER);
            if (this.data.notNowOptionExits != null && this.data.notNowOptionExits.booleanValue()) {
                this.options.addOption("\u79bb\u5f00", NOT_NOW);
                this.options.setShortcut(NOT_NOW, 1, false, false, false, true);
            } else {
                this.options.addOption("\u6682\u4e0d\u8003\u8651", NOT_NOW);
            }
        }
    }

    protected void addStoryOptions() {
        this.options.clearOptions();
        this.options.addOption("\u770b\u4e00\u4e0b\u603b\u5de5\u7a0b\u5e08\u7684\u62a5\u544a\u5e76\u505a\u51fa\u51b3\u5b9a", RECOVER);
        this.options.addOption("\"\u6211\u9700\u8981\u8003\u8651\u4e00\u4e0b\u3002\"", NOT_NOW);
        this.dialog.setOptionColor(RECOVER, Misc.getStoryOptionColor());
    }

    protected boolean isStoryPointRecovery() {
        return this.data != null && this.data.storyPointRecovery != null && this.data.storyPointRecovery != false;
    }

    protected void addInitialText() {
        boolean withDesc;
        if (this.data.noDescriptionText != null && this.data.noDescriptionText.booleanValue()) {
            return;
        }
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        boolean wreck = "wreck".equals(this.entity.getCustomEntityType());
        boolean bl = withDesc = !debris && !(wreck |= this.entity.hasTag("wreck"));
        if (this.isStoryPointRecovery()) {
            this.addText("\u4e00\u6bb5\u65f6\u95f4\u4ee5\u540e\uff0c\u4f60\u6536\u5230\u4e86\u603b\u5de5\u7a0b\u5e08\u7684\u56de\u590d\u3002\u5728\u6ce8\u610f\u5230\u4f60\u5df2\u7ecf\u63a5\u901a\u901a\u8baf\u524d\uff0c\u5176\u770b\u4e0a\u53bb\u5728\u8ddf\u5c4f\u5e55\u5916\u7684\u4ec0\u4e48\u4eba\u8ba8\u8bba\u7740\u521b\u9020\u5947\u8ff9\u4e4b\u7c7b\u7684\u8bdd\u3002");
            if (this.members.size() == 1) {
                this.addText("\"\u6307\u6325\u5b98\uff0c\u770b\u4e0a\u53bb\u6211\u4eec\u80fd\u5e72\u6210\u8fd9\u6d3b\u3002\u4f46\u662f\u6211\u5f97\u5148\u8bf4\u597d\uff0c\u63a5\u4e0b\u6765\u8981\u5e72\u7684\u4e8b\u60c5\u53ef\u4e0d\u5728\u4efb\u4f55\u6280\u672f\u6307\u5357\u91cc\u9762\u3002\u800c\u4e14\u8fd9\u4e5f\u522b\u60f3\u901a\u8fc7\u4efb\u4f55\u5ba1\u67e5\uff0c\u4f46\u6bd5\u7adf\u6211\u4eec\u4e5f\u4e0d\u662f\u4ec0\u4e48\u6b7b\u677f\u7684 \u9738\u4e3b \u8230\u961f\u3002\u603b\u800c\u8a00\u4e4b\uff0c\u80fd\u8ba9\u5b83\u91cd\u65b0\u98de\u8d77\u6765\u3002");
            } else {
                this.addText("\"\u6307\u6325\u5b98\uff0c\u770b\u4e0a\u53bb\u6211\u4eec\u80fd\u5e72\u6210\u8fd9\u6d3b\u3002\u4f46\u662f\u6211\u5f97\u5148\u8bf4\u597d\uff0c\u63a5\u4e0b\u6765\u8981\u5e72\u7684\u4e8b\u60c5\u53ef\u4e0d\u5728\u4efb\u4f55\u6280\u672f\u6307\u5357\u91cc\u9762\u3002\u800c\u4e14\u8fd9\u4e5f\u522b\u60f3\u901a\u8fc7\u4efb\u4f55\u5ba1\u67e5\uff0c\u4f46\u6bd5\u7adf\u6211\u4eec\u4e5f\u4e0d\u662f\u4ec0\u4e48\u6b7b\u677f\u7684 \u9738\u4e3b \u8230\u961f\u3002\u603b\u800c\u8a00\u4e4b\uff0c\u80fd\u8ba9\u5b83\u91cd\u65b0\u98de\u8d77\u6765\u3002");
            }
            return;
        }
        String ships = "\u51e0\u8258\u8230\u8239";
        String \u5b83\u4eec = "\u5b83\u4eec";
        if (this.members.size() == 1) {
            ships = "\u4e00\u8258\u8230\u8239";
            \u5b83\u4eec = "\u5b83";
        }
        if (wreck) {
            if (this.data.storyPointRecovery != null && this.data.storyPointRecovery.booleanValue()) {
                this.addText("\u88ab\u6d3e\u5f80\u6c89\u8239\u8fdb\u884c\u4f5c\u4e1a\u7684\u5de5\u7a0b\u5c0f\u7ec4\u62a5\u544a\u8bf4\uff1a\u4ed6\u4eec\u5df2\u7ecf\u6210\u529f\u5b8c\u6210\u6062\u590d\u3002");
            } else if (!FireBest.fire(null, this.dialog, this.memoryMap, "ShipRecoveryCustomText")) {
                this.addText("\u6253\u635e\u4eba\u5458\u767b\u4e0a\u6b8b\u8230\uff0c\u53d1\u73b0\u8bb8\u591a\u57fa\u672c\u7cfb\u7edf\u5747\u672a\u635f\u574f\uff0c\u4e14\u8230\u8239\u53ef\u4ee5\u6062\u590d\u4e9b\u57fa\u672c\u529f\u80fd\u3002");
                BaseSalvageSpecial.ExtraSalvage es = BaseSalvageSpecial.getExtraSalvage(this.entity);
                if (es != null && !es.cargo.isEmpty()) {
                    this.addText("\u4e5f\u6709\u8ff9\u8c61\u8868\u660e\u8be5\u8239\u4e0a\u53ef\u80fd\u6709\u67d0\u79cd\u8d27\u7269\u3002");
                }
            }
        } else if (debris) {
            this.addText("\u6b8b\u9ab8\u533a\u7684\u8fd1\u8ddd\u79bb\u626b\u63cf\u663e\u793a " + ships + " \u53ef\u4ee5\u6062\u590d\u5230\u57fa\u672c\u529f\u80fd\u3002");
        } else if (withDesc) {
            String desc = this.data.desc;
            if (desc == null) {
                desc = "\u4f4d\u4e8e\u9644\u8fd1";
            }
            if (this.entity instanceof PlanetAPI) {
                this.addText("\u6253\u635e\u4eba\u5458\u62a5\u544a\u6709" + ships + " " + desc + "\u3002" + "\u4ed4\u7ec6\u68c0\u67e5\u540e\u53d1\u73b0" + \u5b83\u4eec + "\u53ef\u4ee5\u6062\u590d\u81f3\u53ef\u7528\u72b6\u6001\u3002");
            } else {
                this.addText("\u6253\u635e\u4eba\u5458\u62a5\u544a\u6709" + ships + " " + desc + "\u4f4d\u7f6e $shortName\u3002" + "\u4ed4\u7ec6\u68c0\u67e5\u540e\u53d1\u73b0" + \u5b83\u4eec + "\u53ef\u4ee5\u6062\u590d\u81f3\u53ef\u7528\u72b6\u6001\u3002");
            }
        }
        if (this.members.size() == 1) {
            if (this.members.size() > 0 && Misc.getCurrSpecialMods(this.members.get(0).getVariant()) > 0) {
                this.text.addPara("\u6253\u635e\u5c0f\u961f\u957f\u8fd8\u62a5\u544a\u8bf4\uff0c\u7531\u4e8e\u8239\u4f53\u7ecf\u5386\u8fc7 %s}\uff0c\u6240\u4ee5\u624d\u80fd\u4fdd\u6301\u73b0\u72b6\u3002", Misc.getStoryOptionColor(), "\u7279\u6b8a\u6539\u9020");
            }
            this.addText("\u5982\u679c\u6ca1\u6709\u6062\u590d\uff0c\u8230\u8239\u5c06\u88ab\u6467\u6bc1\uff0c\u6240\u88c5\u5907\u7684\u6b66\u5668\u548c\u6218\u6597\u673a LPC \u5c06\u88ab\u6536\u56de\u3002");
        } else {
            this.addText("\u4efb\u4f55\u672a\u6062\u590d\u7684\u8230\u8239\u90fd\u5c06\u88ab\u6467\u6bc1\uff0c\u4e14\u6240\u88c5\u5907\u7684\u6b66\u5668\u548c\u6218\u673a LPC \u5c06\u88ab\u6536\u56de\u3002");
        }
    }

    protected void addMember(PerShipData shipData) {
        if (shipData.variant == null && shipData.variantId == null) {
            return;
        }
        FleetMemberAPI member = null;
        member = shipData.variantId != null ? Global.getFactory().createFleetMember(FleetMemberType.SHIP, shipData.variantId) : Global.getFactory().createFleetMember(FleetMemberType.SHIP, shipData.variant);
        if (Misc.isUnboardable(member)) {
            return;
        }
        this.members.add(member);
        if (this.first == null) {
            this.first = member;
        }
        member.setOwner(1);
        if (shipData.fleetMemberId != null) {
            member.setId(shipData.fleetMemberId);
        }
        if (ShipRecoverySpecial.isNameKnown(shipData.condition) || shipData.nameAlwaysKnown != null && shipData.nameAlwaysKnown.booleanValue()) {
            member.setShipName(shipData.shipName);
        } else {
            member.setShipName("<\u8239\u540d\u4e0d\u8be6>");
        }
        this.prepareMember(member, shipData);
    }

    public static boolean isNameKnown(ShipCondition condition) {
        return condition == ShipCondition.PRISTINE || condition == ShipCondition.GOOD;
    }

    public void prepareMember(FleetMemberAPI member, PerShipData shipData) {
        int hits = this.getHitsForCondition(member, shipData.condition);
        int dmods = this.getDmodsForCondition(shipData.condition);
        int reduction = (int)this.playerFleet.getStats().getDynamic().getValue("ship_dmod_reduction_mod", 0.0f);
        reduction = this.random.nextInt(reduction + 1);
        dmods -= reduction;
        member.getStatus().setRandom(this.random);
        int i = 0;
        while (i < hits) {
            member.getStatus().applyDamage(1000000.0f);
            ++i;
        }
        member.getStatus().setHullFraction(this.getHullForCondition(shipData.condition));
        member.getRepairTracker().setCR(0.0f);
        ShipVariantAPI variant = member.getVariant();
        variant = variant.clone();
        variant.setOriginalVariant(null);
        int dModsAlready = DModManager.getNumDMods(variant);
        dmods = Math.max(0, dmods - dModsAlready);
        if (dmods > 0 && shipData.addDmods) {
            DModManager.setDHull(variant);
        }
        member.setVariant(variant, false, true);
        if (dmods > 0 && shipData.addDmods) {
            DModManager.addDMods(member, true, dmods, this.random);
        }
        if (shipData.sModProb > 0.0f && this.random.nextFloat() < shipData.sModProb) {
            int num = 1;
            float r = this.random.nextFloat();
            if (r > 0.85f) {
                num = 3;
            } else if (r > 0.5f) {
                num = 2;
            }
            WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(this.random);
            for (String id : variant.getHullMods()) {
                HullModSpecAPI spec = Global.getSettings().getHullModSpec(id);
                if (spec.isHidden() || spec.isHiddenEverywhere() || spec.hasTag("dmod") || spec.hasTag("no_build_in") || variant.getPermaMods().contains(spec.getId())) continue;
                picker.add(id, spec.getCapitalCost());
            }
            int i2 = 0;
            while (i2 < num && !picker.isEmpty()) {
                String id = (String)picker.pickAndRemove();
                variant.addPermaMod(id, true);
                ++i2;
            }
        }
        if (shipData.pruneWeapons) {
            float retain = this.getFighterWeaponRetainProb(shipData.condition);
            FleetEncounterContext.prepareShipForRecovery(member, false, false, false, retain, retain, this.random);
            member.getVariant().autoGenerateWeaponGroups();
        }
    }

    protected float getHullForCondition(ShipCondition condition) {
        switch (condition) {
            case PRISTINE: {
                return 1.0f;
            }
            case GOOD: {
                return 0.6f + this.random.nextFloat() * 0.2f;
            }
            case AVERAGE: {
                return 0.4f + this.random.nextFloat() * 0.2f;
            }
            case BATTERED: {
                return 0.2f + this.random.nextFloat() * 0.2f;
            }
            case WRECKED: {
                return this.random.nextFloat() * 0.1f;
            }
        }
        return 1.0f;
    }

    protected int getDmodsForCondition(ShipCondition condition) {
        if (condition == ShipCondition.PRISTINE) {
            return 0;
        }
        switch (condition) {
            case GOOD: {
                return 1;
            }
            case AVERAGE: {
                return 1 + this.random.nextInt(2);
            }
            case BATTERED: {
                return 2 + this.random.nextInt(2);
            }
            case WRECKED: {
                return 3 + this.random.nextInt(2);
            }
        }
        return 1;
    }

    protected float getFighterWeaponRetainProb(ShipCondition condition) {
        switch (condition) {
            case PRISTINE: {
                return 1.0f;
            }
            case GOOD: {
                return 0.67f;
            }
            case AVERAGE: {
                return 0.5f;
            }
            case BATTERED: {
                return 0.33f;
            }
            case WRECKED: {
                return 0.2f;
            }
        }
        return 0.0f;
    }

    protected int getHitsForCondition(FleetMemberAPI member, ShipCondition condition) {
        if (condition == ShipCondition.PRISTINE) {
            return 0;
        }
        if (condition == ShipCondition.WRECKED) {
            return 20;
        }
        switch (member.getHullSpec().getHullSize()) {
            case CAPITAL_SHIP: {
                switch (condition) {
                    case GOOD: {
                        return 2 + this.random.nextInt(2);
                    }
                    case AVERAGE: {
                        return 4 + this.random.nextInt(3);
                    }
                    case BATTERED: {
                        return 7 + this.random.nextInt(6);
                    }
                }
                break;
            }
            case CRUISER: {
                switch (condition) {
                    case GOOD: {
                        return 1 + this.random.nextInt(2);
                    }
                    case AVERAGE: {
                        return 2 + this.random.nextInt(3);
                    }
                    case BATTERED: {
                        return 4 + this.random.nextInt(4);
                    }
                }
                break;
            }
            case DESTROYER: {
                switch (condition) {
                    case GOOD: {
                        return 1 + this.random.nextInt(2);
                    }
                    case AVERAGE: {
                        return 2 + this.random.nextInt(2);
                    }
                    case BATTERED: {
                        return 3 + this.random.nextInt(3);
                    }
                }
                break;
            }
            case FRIGATE: {
                switch (condition) {
                    case GOOD: {
                        return 1;
                    }
                    case AVERAGE: {
                        return 2;
                    }
                    case BATTERED: {
                        return 3;
                    }
                }
            }
        }
        return 1;
    }

    public void optionSelected(String optionText, Object optionData) {
        if (RECOVER.equals(optionData)) {
            if (this.isStoryPointRecovery()) {
                this.addStoryOptions();
            } else {
                this.options.clearOptions();
                this.options.addOption("\u8003\u8651\u6062\u590d\u8230\u8239", RECOVER);
                if (this.data.notNowOptionExits != null && this.data.notNowOptionExits.booleanValue()) {
                    this.options.addOption("\u79bb\u5f00", NOT_NOW);
                    this.options.setShortcut(NOT_NOW, 1, false, false, false, true);
                } else {
                    this.options.addOption("\u6682\u4e0d\u8003\u8651", NOT_NOW);
                }
            }
            List<FleetMemberAPI> pool = this.members;
            List<FleetMemberAPI> storyPool = new ArrayList<FleetMemberAPI>();
            if (this.isStoryPointRecovery()) {
                pool = storyPool;
                storyPool = this.members;
            }
            this.dialog.showFleetMemberRecoveryDialog("\u9009\u62e9\u8230\u8239\u8fdb\u884c\u6062\u590d", pool, storyPool, new FleetMemberPickerListener(){

                @Override
                public void pickedFleetMembers(List<FleetMemberAPI> selected) {
                    if (selected.isEmpty()) {
                        return;
                    }
                    new ShowDefaultVisual().execute(null, ShipRecoverySpecial.this.dialog, Misc.tokenize(""), ShipRecoverySpecial.this.memoryMap);
                    for (FleetMemberAPI member : selected) {
                        int index = ShipRecoverySpecial.this.members.indexOf(member);
                        if (index < 0) continue;
                        PerShipData shipData = ShipRecoverySpecial.this.data.ships.get(index);
                        ShipRecoverySpecial.this.data.ships.remove(index);
                        ShipRecoverySpecial.this.members.remove(index);
                        member.setShipName(shipData.shipName);
                        if (shipData.fleetMemberId != null) {
                            member.setId(shipData.fleetMemberId);
                        }
                        float minHull = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_hull_min", 0.0f);
                        float maxHull = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_hull_max", 0.0f);
                        float minCR = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_cr_min", 0.0f);
                        float maxCR = ShipRecoverySpecial.this.playerFleet.getStats().getDynamic().getValue("ship_recovery_cr_max", 0.0f);
                        float hull = (float)Math.random() * (maxHull - minHull) + minHull;
                        hull = Math.max(hull, member.getStatus().getHullFraction());
                        member.getStatus().setHullFraction(hull);
                        float cr = (float)Math.random() * (maxCR - minCR) + minCR;
                        member.getRepairTracker().setCR(cr);
                        ShipRecoverySpecial.this.playerFleet.getFleetData().addFleetMember(member);
                        ShipRecoverySpecial.this.recovered.add(member);
                    }
                    if (ShipRecoverySpecial.this.dialog.getPlugin() instanceof SalvageSpecialInteraction.SalvageSpecialDialogPlugin) {
                        SalvageSpecialInteraction.SalvageSpecialDialogPlugin plugin = (SalvageSpecialInteraction.SalvageSpecialDialogPlugin)ShipRecoverySpecial.this.dialog.getPlugin();
                        plugin.optionSelected(null, ShipRecoverySpecial.RECOVERY_FINISHED);
                    } else {
                        ShipRecoverySpecial.this.dialog.dismiss();
                    }
                }

                @Override
                public void cancelledFleetMemberPicking() {
                }
            });
        } else if (NOT_NOW.equals(optionData)) {
            if (this.data.notNowOptionExits != null && this.data.notNowOptionExits.booleanValue()) {
                this.dialog.dismiss();
            } else {
                if (this.isStoryPointRecovery()) {
                    Misc.setSalvageSpecial(this.entity, Misc.getPrevSalvageSpecial(this.entity));
                }
                new ShowDefaultVisual().execute(null, this.dialog, Misc.tokenize(""), this.memoryMap);
                if (!this.isStoryPointRecovery()) {
                    this.addExtraSalvageFromUnrecoveredShips();
                }
                this.setDone(true);
                this.setEndWithContinue(false);
                this.setShowAgain(true);
            }
        } else if (RECOVERY_FINISHED.equals(optionData)) {
            new ShowDefaultVisual().execute(null, this.dialog, Misc.tokenize(""), this.memoryMap);
            boolean wreck = "wreck".equals(this.entity.getCustomEntityType());
            if (wreck |= this.entity.hasTag("wreck")) {
                CargoAPI extra = BaseSalvageSpecial.getCombinedExtraSalvage(this.entity);
                if (extra != null && !extra.isEmpty()) {
                    this.addText("\u4f60\u7684\u8239\u5458\u5728\u6062\u590d\u64cd\u4f5c\u671f\u95f4\u53d1\u73b0\u4e00\u4e9b\u6ca1\u6709\u635f\u574f\u7684\u8d27\u7269\u3002");
                    extra.sort();
                    this.playerFleet.getCargo().addAll(extra);
                    for (CargoStackAPI stack : extra.getStacksCopy()) {
                        AddRemoveCommodity.addStackGainText(stack, this.text);
                    }
                    ShipRecoverySpecial.clearExtraSalvage(this.entity);
                    ListenerUtil.reportSpecialCargoGainedFromRecoveredDerelict(extra, this.dialog);
                }
                this.addText("\u8be5 " + this.first.getShipName() + " \u73b0\u52a0\u5165\u4e86\u4f60\u7684\u8230\u961f\u3002");
                this.setShouldAbortSalvageAndRemoveEntity(true);
                this.options.clearOptions();
                this.options.addOption("\u79bb\u5f00", ABORT_CONTINUE);
                this.options.setShortcut(ABORT_CONTINUE, 1, false, false, false, true);
                ListenerUtil.reportShipsRecovered(this.recovered, this.dialog);
                for (FleetMemberAPI member : this.recovered) {
                    this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$srs_memberId", member.getId(), 0.0f);
                    this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$srs_hullId", member.getHullId(), 0.0f);
                    this.dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$srs_baseHullId", member.getHullSpec().getBaseHullId(), 0.0f);
                    FireAll.fire(null, this.dialog, this.memoryMap, "PostShipRecoverySpecial");
                }
            } else {
                this.addExtraSalvageFromUnrecoveredShips();
                this.setEndWithContinue(false);
                this.setDone(true);
                this.setShowAgain(!this.data.ships.isEmpty());
            }
        } else if (ABORT_CONTINUE.equals(optionData)) {
            this.setDone(true);
            this.setEndWithContinue(false);
        }
    }

    protected void addExtraSalvageFromUnrecoveredShips() {
        if (this.members.isEmpty()) {
            return;
        }
        CargoAPI extra = Global.getFactory().createCargo(true);
        for (FleetMemberAPI member : this.members) {
            this.addStuffFromMember(extra, member);
        }
        this.addTempExtraSalvage(extra);
    }

    protected void addStuffFromMember(CargoAPI cargo, FleetMemberAPI member) {
        cargo.addCommodity("supplies", member.getRepairTracker().getSuppliesFromScuttling());
        cargo.addCommodity("fuel", member.getRepairTracker().getFuelFromScuttling());
        cargo.addCommodity("heavy_machinery", member.getRepairTracker().getHeavyMachineryFromScuttling());
        ShipVariantAPI variant = member.getVariant();
        for (String slotId : variant.getNonBuiltInWeaponSlots()) {
            cargo.addWeapons(variant.getWeaponId(slotId), 1);
        }
        int index = 0;
        for (String wingId : variant.getWings()) {
            if (wingId != null && !wingId.isEmpty() && !variant.getHullSpec().isBuiltInWing(index)) {
                cargo.addFighters(wingId, 1);
            }
            ++index;
        }
    }

    public static class PerShipData
    implements Cloneable {
        public ShipCondition condition = ShipCondition.AVERAGE;
        public String variantId = null;
        public ShipVariantAPI variant = null;
        public String shipName = null;
        public String fleetMemberId = null;
        public boolean addDmods = true;
        public boolean pruneWeapons = true;
        public Boolean nameAlwaysKnown = null;
        public float sModProb = 0.0f;

        public PerShipData(String variantId, ShipCondition condition) {
            this(variantId, condition, 0.0f);
        }

        public PerShipData(String variantId, ShipCondition condition, float sModProb) {
            this(variantId, condition, "independent", sModProb);
        }

        public PerShipData(ShipVariantAPI variant, ShipCondition condition, String shipName, String factionIdForShipName, float sModProb) {
            this.variant = variant;
            this.condition = condition;
            if (shipName != null) {
                this.shipName = shipName;
            } else {
                FactionAPI faction = Global.getSector().getFaction(factionIdForShipName);
                this.shipName = faction.pickRandomShipName();
            }
            this.sModProb = sModProb;
        }

        public PerShipData(String variantId, ShipCondition condition, String factionIdForShipName, float sModProb) {
            this.variantId = variantId;
            this.condition = condition;
            FactionAPI faction = Global.getSector().getFaction(factionIdForShipName);
            this.shipName = faction.pickRandomShipName();
            this.sModProb = sModProb;
        }

        public ShipVariantAPI getVariant() {
            ShipVariantAPI result = this.variant;
            if (result == null && this.variantId != null) {
                result = Global.getSettings().getVariant(this.variantId);
            }
            return result;
        }

        public PerShipData clone() {
            try {
                return (PerShipData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShipCondition {
        PRISTINE,
        GOOD,
        AVERAGE,
        BATTERED,
        WRECKED;

    }

    public static class ShipRecoverySpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public List<PerShipData> ships = new ArrayList<PerShipData>();
        public String desc = null;
        public Boolean storyPointRecovery = null;
        public Boolean notNowOptionExits = null;
        public Boolean noDescriptionText = null;

        public ShipRecoverySpecialData(String desc) {
            this.desc = desc;
        }

        public void addShip(PerShipData ship) {
            this.ships.add(ship);
        }

        public void addShip(String variantId, ShipCondition condition, float sModProb) {
            this.ships.add(new PerShipData(variantId, condition, sModProb));
        }

        public void addShip(String variantId, ShipCondition condition, String factionIdForShipName, float sModProb) {
            this.ships.add(new PerShipData(variantId, condition, factionIdForShipName, sModProb));
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new ShipRecoverySpecial();
        }
    }
}

