/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;

public class SleeperPodsSpecial
extends BaseSalvageSpecial {
    public static final String OPEN = "open";
    public static final String NOT_NOW = "not_now";
    private SleeperPodsSpecialData data;
    private int quantity = 1;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        SleeperSpecialType type;
        CampaignFleetAPI player;
        int crewBerths;
        super.init(dialog, specialData);
        this.data = (SleeperPodsSpecialData)specialData;
        this.quantity = this.data.min + this.random.nextInt(this.data.max - this.data.min + 1);
        if (this.data.type == SleeperSpecialType.ORGANS && this.quantity < 1) {
            this.quantity = 1;
        }
        if ((crewBerths = (int)((player = Global.getSector().getPlayerFleet()).getCargo().getMaxPersonnel() - (float)player.getCargo().getTotalPersonnel())) < 0) {
            crewBerths = 0;
        }
        if ((type = this.data.type) == SleeperSpecialType.CREW) {
            this.quantity = Math.min(crewBerths, this.quantity);
        }
        if (type == SleeperSpecialType.MARINES) {
            this.quantity = Math.min(crewBerths, this.quantity);
        }
        if (type == SleeperSpecialType.ADMIN || type == SleeperSpecialType.OFFICER) {
            this.quantity = 1;
        }
        switch (type) {
            case CREW: {
                this.initCrew();
                break;
            }
            case MARINES: {
                this.initMarines();
                break;
            }
            case OFFICER: {
                this.initOfficer();
                break;
            }
            case ADMIN: {
                this.initOfficer();
                break;
            }
            case ORGANS: {
                this.initOrgans();
            }
        }
    }

    protected void initCrew() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("\u5728\u8fdb\u884c\u521d\u6b65\u8bc4\u4f30\u65f6\uff0c\u4f60\u7684\u6253\u635e \u4eba\u5458\u53d1\u73b0\u4e00\u4e9b\u88ab\u5360\u7528\u7684\u51b7\u51bb\u8231\u4ecd\u5728\u8fd0\u884c\u5907\u7528\u7535\u6e90\u3002");
            this.options.clearOptions();
            this.options.addOption("\u5c1d\u8bd5\u6253\u5f00\u540a\u8231", OPEN);
            this.options.addOption("\u6682\u4e0d\u8003\u8651", NOT_NOW);
        }
    }

    protected void initMarines() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("\u5728\u8fdb\u884c\u521d\u6b65\u8bc4\u4f30\u65f6\uff0c\u4f60\u7684\u6253\u635e\u4eba\u5458\u53d1\u73b0\u4e00\u4e2a\u88ab\u5360\u7528\u7684\u519b\u7528\u51b7\u51bb\u8231\u4ecd\u5728\u8fd0\u884c\u5907\u7528\u7535\u6e90\u3002");
            this.options.clearOptions();
            this.options.addOption("\u5c1d\u8bd5\u6253\u5f00\u540a\u8231", OPEN);
            this.options.addOption("\u6682\u4e0d\u8003\u8651", NOT_NOW);
        }
    }

    protected void initOfficer() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("\u5728\u8fdb\u884c\u521d\u6b65\u8bc4\u4f30\u65f6\uff0c\u4f60\u7684\u6253\u635e\u4eba\u5458\u53d1\u73b0\u4e00\u4e2a\u88ab\u5360\u7528\u7684\u51b7\u51bb\u8231\u4ecd\u5728\u8fd0\u884c\u5907\u7528\u7535\u6e90\u3002");
            this.options.clearOptions();
            this.options.addOption("\u5c1d\u8bd5\u6253\u5f00\u540a\u8231", OPEN);
            this.options.addOption("\u6682\u4e0d\u8003\u8651", NOT_NOW);
        }
    }

    protected void initOrgans() {
        if (this.quantity <= 0) {
            this.initNothing();
        } else {
            this.addText("\u5728\u8fdb\u884c\u521d\u6b65\u8bc4\u4f30\u65f6\uff0c\u4f60\u7684\u6253\u635e \u4eba\u5458\u53d1\u73b0\u4e00\u4e9b\u88ab\u5360\u7528\u7684\u51b7\u51bb\u8231\u4ecd\u5728\u8fd0\u884c\u5907\u7528\u7535\u6e90\u3002");
            this.options.clearOptions();
            this.options.addOption("\u5c1d\u8bd5\u6253\u5f00\u540a\u8231", OPEN);
            this.options.addOption("\u6682\u4e0d\u8003\u8651", NOT_NOW);
        }
    }

    public void optionSelected(String optionText, Object optionData) {
        if (OPEN.equals(optionData)) {
            switch (this.data.type) {
                case CREW: {
                    this.addText("\u968f\u7740\u89e3\u51bb\u8fc7\u7a0b\u9010\u6b65\u5b8c\u6210\uff0c\u51b7\u51bb\u8231\u7ec8\u4e8e\u6253\u5f00\u3002\u5f88\u5e78\u8fd0\uff0c\u5927\u90e8\u5206\u4eba\u5458\u9664\u4e86\u6709\u70b9\u832b\u7136\u4ee5\u5916\uff0c\u90fd\u8fd8\u6d3b\u7740\u3002");
                    this.playerFleet.getCargo().addCommodity("crew", this.quantity);
                    AddRemoveCommodity.addCommodityGainText("crew", this.quantity, this.text);
                    break;
                }
                case MARINES: {
                    this.addText("\u968f\u7740\u89e3\u51bb\u8fc7\u7a0b\u9010\u6b65\u5b8c\u6210\uff0c\u51b7\u51bb\u8231\u7ec8\u4e8e\u6253\u5f00\u3002\u5f88\u5e78\u8fd0\uff0c\u5927\u90e8\u5206\u4eba\u5458\u9664\u4e86\u6709\u70b9\u832b\u7136\u4ee5\u5916\uff0c\u90fd\u8fd8\u6d3b\u7740\u3002");
                    this.playerFleet.getCargo().addCommodity("marines", this.quantity);
                    AddRemoveCommodity.addCommodityGainText("marines", this.quantity, this.text);
                    break;
                }
                case OFFICER: {
                    this.addText("\u968f\u7740\u89e3\u51bb\u8fc7\u7a0b\u9010\u6b65\u5b8c\u6210\uff0c\u51b7\u51bb\u8231\u7ec8\u4e8e\u6253\u5f00\u3002\u91cc\u9762\u5c45\u7136\u662f\u4e00\u4f4d\u7ecf\u9a8c\u4e30\u5bcc\u7684\u519b\u5b98\uff0c\u51fa\u4e8e\u6551\u547d\u4e4b\u6069\uff0c\u4ed6\u51b3\u5b9a\u52a0\u5165\u4f60\u7684\u8230\u961f\u3002");
                    this.playerFleet.getFleetData().addOfficer(this.data.officer);
                    AddRemoveCommodity.addOfficerGainText(this.data.officer, this.text);
                    break;
                }
                case ADMIN: {
                    this.addText("\u89e3\u51bb\u6d41\u7a0b\u5df2\u5b8c\u6210\uff0c\u51b7\u51bb\u4ed3\u6253\u5f00\u4e86\u3002\u5176\u4e2d\u6709\u4ee5\u4e3a\u6709\u7ecf\u9a8c\u7684\u884c\u661f\u7ba1\u7406\u8005\u4e3a\u4e86\u62a5\u7b54\u6551\u547d\u4e4b\u6069\u800c\u52a0\u5165\u4e86\u4f60\u3002");
                    Global.getSector().getCharacterData().addAdmin(this.data.officer);
                    AddRemoveCommodity.addAdminGainText(this.data.officer, this.text);
                    break;
                }
                case ORGANS: {
                    this.addText("\u51b7\u51bb\u4ed3\u95e8\u4e00\u4e2a\u63a5\u4e00\u4e2a\u968f\u7740\u89e3\u51bb\u6d41\u7a0b\u7684\u5b8c\u6210\u5f00\u59cb\u6253\u5f00\u3002\u7136\u800c\u5df2\u7ecf\u8fc7\u4e86\u592a\u4e45\u4e86\uff0c\u8fd9\u671f\u95f4\u6709\u4ec0\u4e48\u5730\u65b9\u51fa\u4e86\u6545\u969c\uff0c\u6240\u4ee5\u4e00\u4e2a\u5e78\u5b58\u8005\u90fd\u6ca1\u6709 \u2014\u2014 \u81f3\u5c11\u6ca1\u6709\u4efb\u4f55\u8fd8\u6709\u8111\u6d3b\u52a8\u7684\u3002");
                    this.playerFleet.getCargo().addCommodity("organs", this.quantity);
                    AddRemoveCommodity.addCommodityGainText("organs", this.quantity, this.text);
                }
            }
            this.setDone(true);
            this.setShowAgain(false);
        } else if (NOT_NOW.equals(optionData)) {
            this.setDone(true);
            this.setEndWithContinue(false);
            this.setShowAgain(true);
        }
    }

    public static class SleeperPodsSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SleeperSpecialType type;
        public int min;
        public int max;
        public PersonAPI officer;

        public SleeperPodsSpecialData(SleeperSpecialType type, PersonAPI officer) {
            this.type = type;
            this.officer = officer;
            this.max = 1;
            this.min = 1;
        }

        public SleeperPodsSpecialData(SleeperSpecialType type, int min, int max) {
            this.type = type;
            this.min = min;
            this.max = max;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new SleeperPodsSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SleeperSpecialType {
        CREW,
        MARINES,
        OFFICER,
        ADMIN,
        ORGANS;

    }
}

