/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.MarketConditionSpecAPI;
import com.fs.starfarer.api.impl.campaign.intel.misc.BreadcrumbIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BreadcrumbSpecial;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;

public class SurveyDataSpecial
extends BaseSalvageSpecial {
    public static float MAX_RANGE = 16000.0f;
    private SurveyDataSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        StarSystemAPI system;
        super.init(dialog, specialData);
        this.data = (SurveyDataSpecialData)specialData;
        if (this.data.type == SurveyDataSpecialType.AUTO_PICK || this.data.type == SurveyDataSpecialType.AUTO_PICK_NOT_SYSTEM) {
            List<StarSystemAPI> systems;
            WeightedRandomPicker<SurveyDataSpecialType> picker = new WeightedRandomPicker<SurveyDataSpecialType>(this.random);
            picker.add(SurveyDataSpecialType.PLANET_INTERESTING_PROPERTY, 50.0f);
            picker.add(SurveyDataSpecialType.PLANET_SURVEY_DATA, 20.0f);
            if (this.data.type == SurveyDataSpecialType.AUTO_PICK) {
                picker.add(SurveyDataSpecialType.SYSTEM_PRELIMINARY_SURVEY, 5.0f);
            }
            this.data.type = (SurveyDataSpecialType)((Object)picker.pick());
            this.data.entityId = null;
            if (this.data.type == SurveyDataSpecialType.PLANET_INTERESTING_PROPERTY) {
                systems = Misc.getSystemsInRange(this.entity, null, true, MAX_RANGE);
                PlanetAPI planet = DerelictThemeGenerator.findInterestingPlanet(systems, null, false, this.data.includeRuins, this.random);
                String conditionId = DerelictThemeGenerator.getInterestingCondition(planet, this.data.includeRuins);
                if (planet != null && conditionId != null) {
                    this.data.entityId = planet.getId();
                    this.data.secondaryId = conditionId;
                }
            } else if (this.data.type == SurveyDataSpecialType.PLANET_SURVEY_DATA) {
                systems = Misc.getSystemsInRange(this.entity, null, true, MAX_RANGE);
                PlanetAPI planet = DerelictThemeGenerator.findInterestingPlanet(systems, null, false, this.data.includeRuins, this.random);
                if (planet != null) {
                    this.data.entityId = planet.getId();
                }
            } else if (this.data.type == SurveyDataSpecialType.SYSTEM_PRELIMINARY_SURVEY && (system = DerelictThemeGenerator.findNearbySystem(this.entity, null, this.random, MAX_RANGE)) != null) {
                this.data.entityId = system.getId();
            }
        }
        if (this.data.entityId != null) {
            SectorEntityToken entity = Global.getSector().getEntityById(this.data.entityId);
            system = Global.getSector().getStarSystem(this.data.entityId);
            if (entity == null && system == null) {
                this.data.entityId = null;
                this.data.type = SurveyDataSpecialType.SCRAMBLED;
            }
        } else {
            this.data.type = SurveyDataSpecialType.SCRAMBLED;
        }
        switch (this.data.type) {
            case SCRAMBLED: {
                this.initNothing();
                break;
            }
            case PLANET_INTERESTING_PROPERTY: {
                this.initInterestingProperty();
                break;
            }
            case PLANET_SURVEY_DATA: {
                this.initPlanetSurveyData();
                break;
            }
            case SYSTEM_PRELIMINARY_SURVEY: {
                this.initPreliminarySystemSurvey();
            }
        }
    }

    public void initNothing() {
        this.addText("$shortName\u7684\u5b58\u50a8\u4f53\u88ab\u9ad8\u5f3a\u5ea6\u7535\u79bb\u8f90\u5c04\u6e05\u96f6\u4e86\uff0c\u800c\u4e14\u5927\u90e8\u5206\u7cfb\u7edf\u90fd\u5df2\u7ecf\u5931\u53bb\u529f\u80fd\u65e0\u6cd5\u8fd0\u4f5c\u3002");
        this.setDone(true);
    }

    protected void initInterestingProperty() {
        if (this.data.entityId == null || this.data.secondaryId == null) {
            this.initNothing();
            return;
        }
        PlanetAPI planet = (PlanetAPI)Global.getSector().getEntityById(this.data.entityId);
        if (planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
            this.initNothing();
            return;
        }
        String text1 = this.getString("$shortName\u7684\u5b58\u50a8\u4f53\u4ecd\u6709\u4e00\u90e8\u5206\u53ef\u4ee5\u8bbf\u95ee\uff0c\u4e14\u5176\u4e2d\u7684\u6570\u636e");
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "\u4f60\u7684\u6253\u635e\u4eba\u5458\u5728\u5e9f\u589f\u4e2d\u627e\u5230\u4e00\u4e2a\u5b58\u50a8\u4f53\u3002\u5176\u4e2d\u7684\u6570\u636e";
        }
        String desc = "";
        String world = String.valueOf(planet.getSpec().getAOrAn()) + " " + planet.getTypeNameWithWorld().toLowerCase();
        String loc = BreadcrumbSpecial.getLocatedString(planet, true);
        loc = loc.replaceFirst("\u6b63", "");
        String subject = "";
        MarketConditionSpecAPI spec = Global.getSettings().getMarketConditionSpec(this.data.secondaryId);
        if (spec.getId().equals("habitable")) {
            subject = "\u5b9c\u5c45\u884c\u661f";
            desc = "\u6307\u51fa\u4e86" + world + "\u7684\u5b58\u5728\u3002\u5b83\u7684\u5371\u9669\u7b49\u7ea7\u8f83\u4f4e\uff0c" + loc;
        } else {
            subject = String.valueOf(Misc.ucFirst(spec.getName())) + " \u7684\u4f4d\u7f6e";
            desc = "\u8bb0\u5f55\u4e86\u5173\u4e8e" + spec.getName().toLowerCase() + "\u7684\u4fe1\u606f\u3002\u5b83\u4f4d\u4e8e" + world + " " + loc;
        }
        desc = String.valueOf(desc) + "\u3002";
        this.addText(String.valueOf(text1) + desc);
        String text1ForIntel = "\u5728\u63a2\u7d22\u4e00\u4e2a$nameInText\u65f6\uff0c\u4f60\u7684\u6253\u635e\u4eba\u5458\u53d1\u73b0\u4e86\u90e8\u5206\u4ecd\u53ef\u8bbf\u95ee\u7684\u50a8\u5b58\u4f53\uff0c";
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, planet);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(String.valueOf(text1ForIntel) + desc));
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    protected void initPlanetSurveyData() {
        MarketConditionSpecAPI spec;
        String conditionId;
        if (this.data.entityId == null) {
            this.initNothing();
            return;
        }
        PlanetAPI planet = (PlanetAPI)Global.getSector().getEntityById(this.data.entityId);
        if (planet.getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
            this.initNothing();
            return;
        }
        String name = planet.getName();
        String world = String.valueOf(planet.getSpec().getAOrAn()) + " " + planet.getTypeNameWithWorld().toLowerCase();
        String loc = BreadcrumbSpecial.getLocatedString(planet, true);
        loc = loc.replaceFirst("\u6b63", "");
        String text1 = "$shortName\u7684\u5b58\u50a8\u4f53\u4ecd\u6709\u4e00\u90e8\u5206\u53ef\u4ee5\u8bbf\u95ee\uff0c\u5176\u4e2d\u5305\u542b\u4e86\u4e00\u4efd\u5b8c\u6574\u8c03\u67e5\u6570\u636e\u3002\u52d8\u63a2\u5bf9\u8c61\u4e3a" + name + "\uff0c" + world + "\uff0c" + loc + "\u3002";
        String text1ForIntel = "\u5728\u63a2\u7d22\u4e00\u5904$nameInText\u65f6\uff0c\u4f60\u7684\u8239\u5458\u53d1\u73b0\u4e86\u4e00\u4e2a\u4ecd\u90e8\u5206\u80fd\u6b63\u5e38\u8bbf\u95ee\u7684\u5b58\u50a8\u4f53\uff0c\u5176\u4e2d\u5305\u542b\u4e86\u4e00\u4efd\u5b8c\u6574\u8c03\u67e5\u6570\u636e\u3002\u52d8\u63a2\u5bf9\u8c61\u4e3a" + name + "\uff0c" + world + "\uff0c" + loc + "\u3002";
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "\u4f60\u7684\u6253\u635e\u4eba\u5458\u5728\u5e9f\u589f\u4e2d\u627e\u5230\u4e00\u4e2a\u5b58\u50a8\u4f53\u3002\u5176\u4e2d\u5305\u542b\u4e86\u4e00\u4efd\u5b8c\u6574\u7684\u8c03\u67e5\u6570\u636e\u3002\u52d8\u63a2\u5bf9\u8c61\u4e3a" + name + "\uff0c" + world + "\uff0c" + loc + "\u3002";
        }
        if ((conditionId = DerelictThemeGenerator.getInterestingCondition(planet, this.data.includeRuins)) != null && (spec = Global.getSettings().getMarketConditionSpec(conditionId)) != null) {
            text1 = String.valueOf(text1) + "\u8be5\u884c\u661f\u7684\u663e\u8457\u7279\u5f81\u4e3a";
            text1ForIntel = String.valueOf(text1ForIntel) + "\u8be5\u884c\u661f\u7684\u663e\u8457\u7279\u5f81\u4e3a";
            if (conditionId.equals("habitable")) {
                text1 = String.valueOf(text1) + "\u62e5\u6709\u5b9c\u5c45\u5730\u8c8c\u3002";
                text1ForIntel = String.valueOf(text1ForIntel) + "\u62e5\u6709\u5b9c\u5c45\u5730\u8c8c\u3002";
            } else {
                text1 = String.valueOf(text1) + "\u5176\u7279\u8d28 " + spec.getName().toLowerCase() + "\u3002";
                text1ForIntel = String.valueOf(text1ForIntel) + "\u5176\u7279\u8d28 " + spec.getName().toLowerCase() + "\u3002";
            }
        }
        String subject = "\u5b8c\u6574\u8c03\u67e5\u6570\u636e\uff1a" + name;
        this.addText(text1);
        Misc.setFullySurveyed(planet.getMarket(), null, false);
        Misc.addSurveyDataFor(planet, this.text);
        SurveyPlugin plugin = (SurveyPlugin)Global.getSettings().getNewPluginInstance("surveyPlugin");
        plugin.init(Global.getSector().getPlayerFleet(), planet);
        long xp = plugin.getXP();
        if (xp > 0L) {
            Global.getSector().getPlayerPerson().getStats().addXP(xp, this.text);
        }
        BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, planet);
        intel.setTitle(this.getString(subject));
        intel.setText(this.getString(text1ForIntel));
        intel.setShowSpecificEntity(true);
        Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        this.setDone(true);
    }

    protected void initPreliminarySystemSurvey() {
        if (this.data.entityId == null) {
            this.initNothing();
            return;
        }
        StarSystemAPI system = Global.getSector().getStarSystem(this.data.entityId);
        if (system == null) {
            this.initNothing();
            return;
        }
        String name = system.getNameWithLowercaseType();
        String text1 = "$shortName\u7684\u5b58\u50a8\u4f53\u4ecd\u6709\u4e00\u90e8\u5206\u53ef\u4ee5\u8bbf\u95ee\uff0c\u5176\u4e2d\u5305\u542b\u4e86\u4e00\u4efd\u57fa\u672c\u7684\u521d\u6b65\u8c03\u67e5\u6570\u636e\u3002\u52d8\u63a2\u5bf9\u8c61\u4e3a" + name + "\u3002";
        String text1ForIntel = "\u5728\u63a2\u7d22\u4e00\u5904$nameInText\u65f6\uff0c\u4f60\u7684\u8239\u5458\u53d1\u73b0\u4e86\u4e00\u4e2a\u4ecd\u90e8\u5206\u80fd\u6b63\u5e38\u8bbf\u95ee\u7684\u5b58\u50a8\u4f53\uff0c\u5176\u4e2d\u5305\u542b\u4e86\u4e00\u4efd\u57fa\u672c\u7684\u521d\u6b65\u8c03\u67e5\u6570\u636e\u3002\u52d8\u63a2\u5bf9\u8c61\u4e3a" + name + "\u3002";
        boolean debris = "debris_field_shared".equals(this.entity.getCustomEntityType());
        if (debris) {
            text1 = "\u4f60\u7684\u6253\u635e\u4eba\u5458\u5728\u5e9f\u589f\u4e2d\u627e\u5230\u4e00\u4e2a\u5b58\u50a8\u4f53\u3002\u5176\u4e2d\u5305\u542b\u4e86\u4e00\u4efd\u57fa\u672c\u7684\u521d\u6b65\u8c03\u67e5\u6570\u636e\u3002\u52d8\u63a2\u5bf9\u8c61\u4e3a" + name + "\u3002";
        }
        String subject = "\u521d\u6b65\u8c03\u67e5\u6570\u636e\uff1a" + system.getName();
        this.addText(text1);
        String data = "";
        Highlights h = new Highlights();
        for (PlanetAPI planet : system.getPlanets()) {
            if (planet.isStar() || planet.getMarket() == null || !planet.getMarket().isPlanetConditionMarketOnly() || planet.getMarket().getSurveyLevel().ordinal() > MarketAPI.SurveyLevel.PRELIMINARY.ordinal()) continue;
            String curr = String.valueOf(planet.getName()) + "\uff0c" + planet.getTypeNameWithWorld().toLowerCase();
            data = String.valueOf(data) + "    " + curr + "\n";
            h.append(curr, planet.getSpec().getIconColor());
            planet.getMarket().setSurveyLevel(MarketAPI.SurveyLevel.PRELIMINARY);
        }
        if (!data.isEmpty()) {
            this.text.setFontSmallInsignia();
            this.text.addParagraph("\u521d\u6b65\u8c03\u67e5\u6570\u636e\uff1a", Misc.getTooltipTitleAndLightHighlightColor());
            data = "    " + data.trim();
            this.text.addParagraph(data);
            this.text.setHighlightsInLastPara(h);
            this.text.setFontInsignia();
            BreadcrumbIntel intel = new BreadcrumbIntel(this.entity, system.getCenter());
            intel.setTitle(this.getString(subject));
            intel.setText(this.getString(text1ForIntel));
            Global.getSector().getIntelManager().addIntel(intel, false, this.text);
        } else {
            this.text.addParagraph("\u53ef\u60dc\u4f60\u5df2\u7ecf\u901a\u8fc7\u5176\u4ed6\u65b9\u5f0f\u83b7\u53d6\u8fc7\u8fd9\u4e9b\u6570\u636e\u3002");
        }
        this.setDone(true);
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public static class SurveyDataSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public SurveyDataSpecialType type = null;
        public String entityId = null;
        public String secondaryId = null;
        public boolean includeRuins = true;

        public SurveyDataSpecialData(SurveyDataSpecialType type) {
            this.type = type;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new SurveyDataSpecial();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SurveyDataSpecialType {
        SCRAMBLED,
        PLANET_INTERESTING_PROPERTY,
        PLANET_SURVEY_DATA,
        SYSTEM_PRELIMINARY_SURVEY,
        AUTO_PICK,
        AUTO_PICK_NOT_SYSTEM;

    }
}

