/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageSpecialInteraction;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TransmitterTrapSpecial
extends BaseSalvageSpecial {
    private TransmitterTrapSpecialData data;

    public void init(InteractionDialogAPI dialog, Object specialData) {
        super.init(dialog, specialData);
        this.data = (TransmitterTrapSpecialData)specialData;
        this.initEntityLocation();
    }

    private void initEntityLocation() {
        if (this.random.nextFloat() > this.data.prob) {
            if (this.random.nextFloat() > 0.5f) {
                this.addText("\u4f60\u7684\u6253\u635e\u4eba\u5458\u53d1\u73b0\u4e86\u4e00\u4e2a\u548c\u8b66\u62a5\u5668\u94fe\u63a5\u7684\u53d1\u4fe1\u5668\uff0c\u4f46\u662f\u5176\u597d\u50cf\u5df2\u4e0d\u5728\u8fd0\u4f5c\u3002\u4ed4\u7ec6\u68c0\u67e5\u540e\uff0c\u8fd9\u4f3c\u4e4e\u662f\u5f88\u591a \u661f\u5386\u5e74 \u524d\u88ab\u8bbe\u7f6e\u7684\u3002");
            } else {
                this.addText("\u4f60\u7684\u6253\u635e\u4eba\u5458\u53d1\u73b0\u4e86\u4e00\u4e2a\u548c\u8b66\u62a5\u5668\u94fe\u63a5\u7684\u53d1\u4fe1\u5668\uff0c\u867d\u7136\u8b66\u62a5\u5982\u671f\u53d1\u4f5c\uff0c\u4f46\u662f\u53d1\u4fe1\u5668\u5374\u5728\u53d1\u51fa\u8b66\u544a\u524d\u88ab\u80fd\u91cf\u6ce2\u52a8\u70e7\u6bc1\u4e86\u3002");
            }
            this.setDone(true);
            this.setEndWithContinue(true);
            this.setShowAgain(false);
            return;
        }
        if (this.entity instanceof PlanetAPI) {
            this.addText("\u5f53\u4f60\u7684\u6253\u635e\u4eba\u5458\u5f00\u59cb\u5de5\u4f5c\u65f6\uff0c\u67d0\u4e2a\u9690\u85cf\u7684\u5728\u884c\u661f\u4e0a\u7684\u53d1\u4fe1\u5668\u53d1\u51fa\u4e86\u4e00\u9053\u52a0\u5bc6\u7684\u5bbd\u9891\u4fe1\u606f\u3002\u4e0d\u8bba\u4fe1\u606f\u7684\u76ee\u7684\u5730\u4f4d\u4e8e\u4f55\u5904\uff0c\u90fd\u5e94\u8be5\u79bb\u6b64\u4e0d\u8fdc\u3002");
        } else {
            this.addText("\u5f53\u4f60\u7684\u6253\u635e\u4eba\u5458\u5f00\u59cb\u5de5\u4f5c\u65f6\uff0c\u67d0\u4e2a\u9690\u85cf\u5728 $shortName \u4e2d\u7684\u53d1\u4fe1\u5668\u53d1\u51fa\u4e86\u4e00\u9053\u52a0\u5bc6\u7684\u5bbd\u9891\u4fe1\u606f\u3002\u4e0d\u8bba\u4fe1\u606f\u7684\u76ee\u7684\u5730\u4f4d\u4e8e\u4f55\u5904\uff0c\u90fd\u5e94\u8be5\u79bb\u6b64\u4e0d\u8fdc\u3002");
        }
        this.transmitterActivated();
        this.setDone(true);
        this.setEndWithContinue(true);
        this.setShowAgain(false);
    }

    public void transmitterActivated() {
        if (this.data == null) {
            return;
        }
        if (this.entity == null) {
            return;
        }
        if (this.data.fleetId != null) {
            SectorEntityToken found = Global.getSector().getEntityById(this.data.fleetId);
            if (found instanceof CampaignFleetAPI) {
                CampaignFleetAPI fleet = (CampaignFleetAPI)found;
                FleetMemberAPI flagship = fleet.getFlagship();
                boolean makeAggressive = false;
                if (flagship != null) {
                    makeAggressive = flagship.getVariant().hasHullMod("automated");
                }
                TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, true, 30.0f);
            }
            return;
        }
        if (this.data.useAllFleetsInRange != null && this.data.useAllFleetsInRange.booleanValue()) {
            boolean foundSomeFleets = false;
            for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                float dist;
                if (this.data.nearbyFleetFaction != null && !this.data.nearbyFleetFaction.equals(fleet.getFaction().getId()) || fleet.isStationMode() || fleet.getMemoryWithoutUpdate().is("$isTradeFleet", true) || !((dist = Misc.getDistance(fleet.getLocation(), this.entity.getLocation())) < this.data.maxRange)) continue;
                FleetMemberAPI flagship = fleet.getFlagship();
                boolean makeAggressive = false;
                if (flagship != null) {
                    makeAggressive = flagship.getVariant().hasHullMod("automated");
                }
                TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, true, 30.0f);
                foundSomeFleets = true;
            }
            if (foundSomeFleets) {
                return;
            }
        }
        if (this.data.useClosestFleetInRange != null && this.data.useClosestFleetInRange.booleanValue()) {
            CampaignFleetAPI closest = null;
            float minDist = Float.MAX_VALUE;
            for (CampaignFleetAPI fleet : this.entity.getContainingLocation().getFleets()) {
                float dist;
                if (this.data.nearbyFleetFaction != null && !this.data.nearbyFleetFaction.equals(fleet.getFaction().getId()) || fleet.isStationMode() || fleet.getMemoryWithoutUpdate().is("$isTradeFleet", true) || !((dist = Misc.getDistance(fleet.getLocation(), this.entity.getLocation())) < this.data.maxRange) || !(dist < minDist)) continue;
                closest = fleet;
                minDist = dist;
            }
            if (closest != null) {
                FleetMemberAPI flagship = closest.getFlagship();
                boolean makeAggressive = false;
                if (flagship != null) {
                    makeAggressive = flagship.getVariant().hasHullMod("automated");
                }
                TransmitterTrapSpecial.makeFleetInterceptPlayer(closest, makeAggressive, true, 30.0f);
                return;
            }
        }
        if (this.data.params != null) {
            CampaignFleetAPI fleet = FleetFactoryV3.createFleet(this.data.params);
            if (fleet == null || fleet.isEmpty()) {
                return;
            }
            if ("remnant".equals(fleet.getFaction().getId())) {
                RemnantSeededFleetManager.initRemnantFleetProperties(null, fleet, false);
            } else {
                fleet.setTransponderOn(false);
                fleet.getMemoryWithoutUpdate().set("$isPirate", true);
                Misc.makeNoRepImpact(fleet, "tTrap");
            }
            float range = this.data.minRange + this.random.nextFloat() * (this.data.maxRange - this.data.minRange);
            Vector2f loc = Misc.getPointAtRadius(this.entity.getLocation(), range);
            this.entity.getContainingLocation().addEntity(fleet);
            fleet.setLocation(loc.x, loc.y);
            FleetMemberAPI flagship = fleet.getFlagship();
            boolean makeAggressive = false;
            if (flagship != null) {
                makeAggressive = flagship.getVariant().hasHullMod("automated");
            }
            TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, true, 30.0f);
            Misc.giveStandardReturnToSourceAssignments(fleet, false);
            return;
        }
    }

    public static void makeFleetInterceptPlayer(CampaignFleetAPI fleet, boolean makeAggressive, boolean makeLowRepImpact, float interceptDays) {
        TransmitterTrapSpecial.makeFleetInterceptPlayer(fleet, makeAggressive, makeLowRepImpact, true, interceptDays);
    }

    public static void makeFleetInterceptPlayer(CampaignFleetAPI fleet, boolean makeAggressive, boolean makeLowRepImpact, boolean makeHostile, float interceptDays) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (fleet.getAI() == null) {
            fleet.setAI(Global.getFactory().createFleetAI(fleet));
            fleet.setLocation(fleet.getLocation().x, fleet.getLocation().y);
        }
        if (makeAggressive) {
            float expire2 = fleet.getMemoryWithoutUpdate().getExpire("$cfai_makeAggressive");
            fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", true, Math.max(expire2, interceptDays));
            fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressiveLastsOneBattle", true, Math.max(expire2, interceptDays));
        }
        if (makeHostile) {
            fleet.getMemoryWithoutUpdate().unset("$cfai_makeAllowDisengage");
            fleet.getMemoryWithoutUpdate().set("$cfai_makeHostile", true, interceptDays);
        }
        fleet.getMemoryWithoutUpdate().set("$ai_placeToLook", new Vector2f((ReadableVector2f)playerFleet.getLocation()), interceptDays);
        if (makeLowRepImpact) {
            Misc.makeLowRepImpact(fleet, "ttSpecial");
        }
        if (fleet.getAI() instanceof ModularFleetAIAPI) {
            ((ModularFleetAIAPI)fleet.getAI()).getTacticalModule().setTarget(playerFleet);
        }
        fleet.addAssignmentAtStart(FleetAssignment.INTERCEPT, playerFleet, interceptDays, null);
    }

    public void optionSelected(String optionText, Object optionData) {
        super.optionSelected(optionText, optionData);
    }

    public static void main(String[] args) {
        Boolean b = null;
        System.out.println(b);
    }

    public static class TransmitterTrapSpecialData
    implements SalvageSpecialInteraction.SalvageSpecialData {
        public float prob = 0.5f;
        public String fleetId;
        public String nearbyFleetFaction = null;
        public Boolean useClosestFleetInRange = null;
        public Boolean useAllFleetsInRange = null;
        public FleetParamsV3 params;
        public float minRange = 2500.0f;
        public float maxRange = 5000.0f;

        public TransmitterTrapSpecialData() {
        }

        public TransmitterTrapSpecialData(FleetParamsV3 params) {
            this.params = params;
        }

        public TransmitterTrapSpecialData(float prob, FleetParamsV3 params) {
            this.prob = prob;
            this.params = params;
        }

        public SalvageSpecialInteraction.SalvageSpecialPlugin createSpecialPlugin() {
            return new TransmitterTrapSpecial();
        }
    }
}

