/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlayerTradeProfitabilityData {
    public static Logger log = Global.getLogger(PlayerTradeProfitabilityData.class);
    private Map<String, CommodityData> dataBought = new LinkedHashMap<String, CommodityData>();
    private IntervalUtil tracker = Misc.createEconIntervalTracker();
    private long accruedXP = 0L;

    public void reportNetBought(String commodityId, float quantity, float totalPrice) {
        CommodityData data = this.getBoughtDataFor(commodityId);
        data.setQuantity(data.getQuantity() + quantity);
        data.setTotalPrice(data.getTotalPrice() + totalPrice);
    }

    public void reportNetSold(String commodityId, float quantity, float totalPrice) {
        CommodityData data = this.getBoughtDataFor(commodityId);
        if (data.getQuantity() < 1.0f || quantity < 1.0f) {
            return;
        }
        float avgBuyPrice = data.getTotalPrice() / data.getQuantity();
        float net = quantity;
        if (quantity > data.getQuantity()) {
            net = data.getQuantity();
        }
        data.setQuantity(data.getQuantity() - net);
        if (net < 1.0f) {
            return;
        }
        float paidForNet = avgBuyPrice * net;
        data.setTotalPrice(Math.max(0.0f, data.getTotalPrice() - paidForNet));
        float receivedForNet = net * totalPrice / quantity;
        float profit = receivedForNet - paidForNet;
        if (profit <= 0.0f) {
            return;
        }
        float xpPerCredit = Global.getSettings().getFloat("economyPlayerXPPerCreditOfProfit");
        long xp = (long)(profit * xpPerCredit);
        this.accruedXP += xp;
        log.info((Object)("\u56e0\u8d38\u6613\u800c\u7d2f\u79ef\u83b7\u5f97 " + xp + " \u70b9\u7ecf\u9a8c " + commodityId + " (\u5355\u4f4d\u5229\u6da6\uff1a" + (int)(profit / net) + ")"));
    }

    public void advance(float days) {
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            float factor = Misc.getGenericRollingAverageFactor();
            for (CommodityData cd : new ArrayList<CommodityData>(this.dataBought.values())) {
                cd.setQuantity(cd.getQuantity() * factor);
                cd.setTotalPrice(cd.getTotalPrice() * factor);
                if (!(cd.getQuantity() < 1.0f)) continue;
                this.dataBought.remove(cd.getCommodityId());
            }
        }
    }

    public CommodityData getBoughtDataFor(String commodityId) {
        CommodityData cd = this.dataBought.get(commodityId);
        if (cd == null) {
            cd = new CommodityData(commodityId);
            this.dataBought.put(commodityId, cd);
        }
        return cd;
    }

    public long getAccruedXP() {
        return this.accruedXP;
    }

    public void setAccruedXP(long accruedXP) {
        this.accruedXP = accruedXP;
    }

    public static class CommodityData {
        private String commodityId;
        private float totalPrice;
        private float quantity;

        public float getQuantity() {
            return this.quantity;
        }

        public void setQuantity(float quantity) {
            this.quantity = quantity;
        }

        public CommodityData(String commodityId) {
            this.commodityId = commodityId;
        }

        public String getCommodityId() {
            return this.commodityId;
        }

        public void setCommodityId(String commodityId) {
            this.commodityId = commodityId;
        }

        public float getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(float totalPrice) {
            this.totalPrice = totalPrice;
        }
    }
}

