/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.impl.campaign.shared.PersonBountyEventData;
import com.fs.starfarer.api.impl.campaign.shared.PlayerActivityTracker;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedData {
    protected TimeoutTracker<String> marketsThatSentRelief = new TimeoutTracker();
    protected TimeoutTracker<String> marketsThatSentTradeFleet = new TimeoutTracker();
    protected Map<String, TimeoutTracker<String>> starSystemCustomsTimeout = new LinkedHashMap<String, TimeoutTracker<String>>();
    protected PlayerActivityTracker playerActivityTracker = new PlayerActivityTracker();
    protected Set<String> marketsWithoutTradeFleetSpawn = new HashSet<String>();
    private PersonBountyEventData personBountyEventData = new PersonBountyEventData();
    protected float playerPreLosingBattleFP = -1.0f;
    protected float playerPreLosingBattleCrew = -1.0f;
    protected long playerLosingBattleTimestamp = 0L;
    protected MonthlyReport previousReport = new MonthlyReport();
    protected MonthlyReport currentReport = new MonthlyReport();
    protected UniqueEncounterData uniqueEncounterData = new UniqueEncounterData();

    public MonthlyReport getPreviousReport() {
        if (this.previousReport == null) {
            this.previousReport = new MonthlyReport();
        }
        return this.previousReport;
    }

    public MonthlyReport getCurrentReport() {
        if (this.currentReport == null) {
            this.currentReport = new MonthlyReport();
        }
        return this.currentReport;
    }

    public void setCurrentReport(MonthlyReport currentReport) {
        this.currentReport = currentReport;
    }

    public void setPreviousReport(MonthlyReport previousReport) {
        this.previousReport = previousReport;
    }

    public void rollOverReport() {
        this.previousReport = this.currentReport;
        this.currentReport = new MonthlyReport();
    }

    public long getPlayerLosingBattleTimestamp() {
        return this.playerLosingBattleTimestamp;
    }

    public void setPlayerLosingBattleTimestamp(long playerLosingBattleTimestamp) {
        this.playerLosingBattleTimestamp = playerLosingBattleTimestamp;
    }

    public float getPlayerPreLosingBattleFP() {
        return this.playerPreLosingBattleFP;
    }

    public void setPlayerPreLosingBattleFP(float playerPreLosingBattleFP) {
        this.playerPreLosingBattleFP = playerPreLosingBattleFP;
    }

    public float getPlayerPreLosingBattleCrew() {
        return this.playerPreLosingBattleCrew;
    }

    public void setPlayerPreLosingBattleCrew(float playerPreLosingBattleCrew) {
        this.playerPreLosingBattleCrew = playerPreLosingBattleCrew;
    }

    public UniqueEncounterData getUniqueEncounterData() {
        return this.uniqueEncounterData;
    }

    protected Object readResolve() {
        if (this.starSystemCustomsTimeout == null) {
            this.starSystemCustomsTimeout = new LinkedHashMap<String, TimeoutTracker<String>>();
        }
        if (this.personBountyEventData == null) {
            this.personBountyEventData = new PersonBountyEventData();
        }
        if (this.uniqueEncounterData == null) {
            this.uniqueEncounterData = new UniqueEncounterData();
        }
        return this;
    }

    public PersonBountyEventData getPersonBountyEventData() {
        return this.personBountyEventData;
    }

    public void advance(float amount) {
        SectorAPI sector = Global.getSector();
        if (sector.isPaused()) {
            return;
        }
        float days = sector.getClock().convertToDays(amount);
        this.marketsThatSentRelief.advance(days);
        this.marketsThatSentTradeFleet.advance(days);
        for (TimeoutTracker<String> curr : this.starSystemCustomsTimeout.values()) {
            curr.advance(days);
        }
        this.playerActivityTracker.advance(days);
    }

    public TimeoutTracker<String> getMarketsThatSentRelief() {
        return this.marketsThatSentRelief;
    }

    public TimeoutTracker<String> getMarketsThatSentTradeFleet() {
        return this.marketsThatSentTradeFleet;
    }

    public PlayerActivityTracker getPlayerActivityTracker() {
        return this.playerActivityTracker;
    }

    public static SharedData getData() {
        Object data = Global.getSector().getPersistentData().get("core_CEFSSharedDataKey");
        if (data == null) {
            data = new SharedData();
            Global.getSector().getPersistentData().put("core_CEFSSharedDataKey", data);
        }
        return (SharedData)data;
    }

    public Set<String> getMarketsWithoutTradeFleetSpawn() {
        return this.marketsWithoutTradeFleetSpawn;
    }

    public void resetCustomsTimeouts() {
        this.starSystemCustomsTimeout.clear();
    }

    public TimeoutTracker<String> getStarSystemCustomsTimeout(String factionId) {
        TimeoutTracker<String> tracker = this.starSystemCustomsTimeout.get(factionId);
        if (tracker == null) {
            tracker = new TimeoutTracker();
            this.starSystemCustomsTimeout.put(factionId, tracker);
        }
        return tracker;
    }

    public static class UniqueEncounterData {
        public List<String> interactedWith = new ArrayList<String>();
        public List<String> historianBlurbsShown = new ArrayList<String>();

        public boolean wasInteractedWith(String id) {
            return this.interactedWith.contains(id);
        }

        public void setWasInteractedWith(String id) {
            this.interactedWith.add(id);
        }

        protected Object readResolve() {
            if (this.historianBlurbsShown == null) {
                this.historianBlurbsShown = new ArrayList<String>();
            }
            return this;
        }
    }
}

