/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.RollingAverageTracker;
import com.fs.starfarer.api.util.TimeoutTracker;
import org.apache.log4j.Logger;

public class StarSystemActivityTracker
extends BaseCampaignEventListener {
    public static Logger log = Global.getLogger(StarSystemActivityTracker.class);
    public static final float ROLLING_AVG_FACTOR = 0.5f;
    private float econInterval = Global.getSettings().getFloat("economyIntervalnGameDays");
    private IntervalUtil timer = new IntervalUtil(0.25f, 0.75f);
    private TimeoutTracker<String> seen = new TimeoutTracker();
    private StarSystemAPI system;
    private RollingAverageTracker points;
    private RollingAverageTracker fleets;
    private RollingAverageTracker ships;

    public StarSystemActivityTracker(StarSystemAPI system) {
        super(false);
        this.system = system;
        this.points = new RollingAverageTracker(this.econInterval - Math.min(this.econInterval * 0.5f, 2.0f), this.econInterval + -Math.min(this.econInterval * 0.5f, 2.0f), 0.5f);
        this.fleets = new RollingAverageTracker(this.econInterval - Math.min(this.econInterval * 0.5f, 2.0f), this.econInterval + -Math.min(this.econInterval * 0.5f, 2.0f), 0.5f);
        this.ships = new RollingAverageTracker(this.econInterval - Math.min(this.econInterval * 0.5f, 2.0f), this.econInterval + -Math.min(this.econInterval * 0.5f, 2.0f), 0.5f);
    }

    Object readResolve() {
        return this;
    }

    Object writeReplace() {
        return this;
    }

    public void advance(float days) {
        this.seen.advance(days);
        this.timer.advance(days);
        if (this.timer.intervalElapsed()) {
            for (CampaignFleetAPI fleet : this.system.getFleets()) {
                if (this.seen.contains(fleet.getId())) continue;
                this.seen.set(fleet.getId(), this.econInterval);
                this.points.add(fleet.getFleetPoints());
                this.ships.add(fleet.getFleetData().getMembersListCopy().size());
                this.fleets.add(1.0f);
            }
            for (CampaignFleetAPI fleet : Global.getSector().getHyperspace().getFleets()) {
                float dist = Misc.getDistance(fleet.getLocation(), this.system.getLocation());
                if (this.seen.contains(fleet.getId()) || !(dist < Global.getSettings().getFloat("commRelayRangeAroundSystem"))) continue;
                this.seen.set(fleet.getId(), this.econInterval);
                this.points.add(fleet.getFleetPoints());
                this.ships.add(fleet.getFleetData().getMembersListCopy().size());
                this.fleets.add(1.0f);
            }
        }
        this.points.advance(days);
        this.fleets.advance(days);
        this.ships.advance(days);
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    public float getPointsSeen() {
        return this.points.getAverage();
    }

    public float getFleetsSeen() {
        return this.fleets.getAverage();
    }

    public float getShipsSeen() {
        return this.ships.getAverage();
    }

    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }
}

