/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WormholeManager {
    public static String KEY = "$core_wormholeManager";
    public static String WORMHOLE = "$wormhole";
    public static String LIMBO_STABLE_LOCATION = "$limboStableLocation";
    public static String GOT_WORMHOLE_CALIBRATION_DATA = "$gotWormholeCalibrationData";
    public static float UNSTABLE_DURATION_MIN = 135.0f;
    public static float UNSTABLE_DURATION_MAX = 225.0f;
    protected List<WormholeData> deployed = new ArrayList<WormholeData>();

    public static WormholeManager get() {
        Object obj = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        if (obj != null) {
            return (WormholeManager)obj;
        }
        WormholeManager data = new WormholeManager();
        Global.getSector().getMemoryWithoutUpdate().set(KEY, data);
        return data;
    }

    public static boolean willWormholeBecomeUnstable(SectorEntityToken stableLocation) {
        boolean makeUnstable = true;
        if (stableLocation.getMemoryWithoutUpdate().getBoolean(LIMBO_STABLE_LOCATION) && Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(GOT_WORMHOLE_CALIBRATION_DATA)) {
            makeUnstable = false;
        }
        return makeUnstable;
    }

    public void updateWormholeDestinations() {
        ArrayList<WormholeData> sorted = new ArrayList<WormholeData>(this.deployed);
        Collections.sort(sorted, new Comparator<WormholeData>(){

            @Override
            public int compare(WormholeData o1, WormholeData o2) {
                return o1.itemData.name.compareTo(o2.itemData.name);
            }
        });
        for (WormholeData data : this.deployed) {
            JumpPointAPI jp = data.jumpPoint;
            jp.clearDestinations();
            boolean added = false;
            for (WormholeData other : sorted) {
                if (other == data || !data.itemData.category.equals(other.itemData.category)) continue;
                jp.addDestination(new JumpPointAPI.JumpDestination(other.jumpPoint, "\u866b\u6d1e\u8282\u70b9" + other.itemData.name));
                added = true;
            }
            if (added) {
                jp.setStandardWormholeToStarfieldVisual();
                continue;
            }
            jp.setStandardWormholeToNothingVisual();
        }
    }

    public JumpPointAPI addWormhole(SpecialItemData item, SectorEntityToken stableLocation, InteractionDialogAPI dialog) {
        WormholeItemData itemData = new WormholeItemData(item.getData());
        WormholeData data = this.getDeployed(itemData.id);
        if (data != null) {
            return data.jumpPoint;
        }
        boolean makeUnstable = WormholeManager.willWormholeBecomeUnstable(stableLocation);
        LocationAPI loc = stableLocation.getContainingLocation();
        JumpPointAPI wormhole = Global.getFactory().createJumpPoint(null, "\u866b\u6d1e\u8282\u70b9" + itemData.name);
        wormhole.setRadius(75.0f);
        wormhole.getMemoryWithoutUpdate().set(WORMHOLE, true);
        if (makeUnstable) {
            float dur = UNSTABLE_DURATION_MIN + (UNSTABLE_DURATION_MAX - UNSTABLE_DURATION_MIN) * (float)Math.random();
            if (Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode")) {
                dur *= 0.01f;
            }
            wormhole.getMemoryWithoutUpdate().set("$unstable", true, dur);
        }
        loc.addEntity(wormhole);
        if (stableLocation.getOrbit() != null) {
            wormhole.setOrbit(stableLocation.getOrbit().makeCopy());
        }
        wormhole.setLocation(stableLocation.getLocation().x, stableLocation.getLocation().y);
        loc.removeEntity(stableLocation);
        this.deployed.add(new WormholeData(item, wormhole, itemData));
        if (dialog != null && dialog.getTextPanel() != null) {
            Global.getSector().getPlayerFleet().getCargo().removeItems(CargoAPI.CargoItemType.SPECIAL, item, 1.0f);
            AddRemoveCommodity.addItemLossText(item, 1, dialog.getTextPanel());
        }
        this.updateWormholeDestinations();
        return wormhole;
    }

    public void removeWormhole(JumpPointAPI jp, InteractionDialogAPI dialog) {
        for (WormholeData data : this.deployed) {
            if (data.jumpPoint != jp) continue;
            LocationAPI loc = jp.getContainingLocation();
            CustomCampaignEntityAPI stableLocation = loc.addCustomEntity(null, null, "stable_location", "neutral");
            if (jp.getOrbit() != null) {
                stableLocation.setOrbit(jp.getOrbit().makeCopy());
            }
            loc.removeEntity(jp);
            if (dialog != null && dialog.getTextPanel() != null) {
                Global.getSector().getPlayerFleet().getCargo().addItems(CargoAPI.CargoItemType.SPECIAL, data.item, 1.0f);
                AddRemoveCommodity.addItemGainText(data.item, 1, dialog.getTextPanel());
            }
            this.deployed.remove(data);
            this.updateWormholeDestinations();
            break;
        }
    }

    public boolean isDeployed(String id) {
        if (id == null) {
            return false;
        }
        for (WormholeData data : this.deployed) {
            if (!id.equals(data.itemData.id)) continue;
            return true;
        }
        return false;
    }

    public WormholeData getDeployed(String id) {
        if (id == null) {
            return null;
        }
        for (WormholeData data : this.deployed) {
            if (!id.equals(data.itemData.id)) continue;
            return data;
        }
        return null;
    }

    public static SpecialItemData createWormholeAnchor(String id, String name) {
        return WormholeManager.createWormholeAnchor("standard", id, name);
    }

    public static SpecialItemData createWormholeAnchor(String category, String id, String name) {
        WormholeItemData itemData = new WormholeItemData(category, id, name);
        SpecialItemData item = new SpecialItemData("wormhole_anchor", itemData.toJsonStr());
        return item;
    }

    public static class WormholeData {
        public SpecialItemData item;
        public JumpPointAPI jumpPoint;
        public WormholeItemData itemData;

        public WormholeData(SpecialItemData item, JumpPointAPI jumpPoint, WormholeItemData itemData) {
            this.item = item;
            this.jumpPoint = jumpPoint;
            this.itemData = itemData;
        }
    }

    public static class WormholeItemData {
        public String category;
        public String id;
        public String name;

        public WormholeItemData(String jsonStr) {
            try {
                JSONObject json = new JSONObject(jsonStr);
                this.category = json.getString("cat");
                this.id = json.getString("id");
                this.name = json.getString("name");
            }
            catch (JSONException e) {
                throw new RuntimeException("Unable to parse Wormhole Anchor data [" + jsonStr + "]", e);
            }
        }

        public WormholeItemData(String category, String id, String name) {
            this.category = category;
            this.id = id;
            this.name = name;
        }

        public String toJsonStr() {
            try {
                JSONObject json = new JSONObject();
                json.put("cat", (Object)this.category);
                json.put("id", (Object)this.id);
                json.put("name", (Object)this.name);
                return json.toString();
            }
            catch (JSONException e) {
                return null;
            }
        }
    }
}

