/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.AICoreOfficerPluginImpl;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.hullmods.Automated;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class AutomatedShips {
    public static float MAX_CR_BONUS = 100.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            int alpha = Math.round(AICoreOfficerPluginImpl.ALPHA_MULT);
            int beta = Math.round(AICoreOfficerPluginImpl.BETA_MULT);
            int gamma = Math.round(AICoreOfficerPluginImpl.GAMMA_MULT);
            return "* \u603b \"\u65e0\u4eba\u8230\u70b9\u6570\" \u7b49\u4e8e\u8230\u961f\u4e2d\u6240\u6709\u81ea\u52a8\u5316\u8230\u8239\u90e8\u7f72\u70b9\u7684\u603b\u548c\uff0c\u4f46\u8fd8\u9700\u6839\u636e\u5b89\u88c5\u7684 AI \u6838\u5fc3\u4e58\u4ee5\u4fee\u6b63\u500d\u7387 - " + alpha + " \u500d" + " (Alpha \u6838\u5fc3)\uff0c" + beta + " \u500d" + " (Beta \u6838\u5fc3)\uff0c" + gamma + " \u500d" + " (Gamma \u6838\u5fc3)\u3002" + "\u56e0\u5b89\u5168\u8fde\u9501\u7cfb\u7edf\u7684\u9650\u5236\uff0c\u5e26\u6709 AI \u6838\u5fc3\u7684\u8230\u8239\uff0c\u5176 \u90e8\u7f72\u70b9 \u4e0d\u4f1a\u53d7\u5230\u4efb\u4f55\u6548\u679c\u7684\u5f71\u54cd\u3002";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            Color bad = Misc.getNegativeHighlightColor();
            return new Color[]{h, h, h, bad};
        }

        public String[] getHighlights() {
            int alpha = Math.round(AICoreOfficerPluginImpl.ALPHA_MULT);
            int beta = Math.round(AICoreOfficerPluginImpl.BETA_MULT);
            int gamma = Math.round(AICoreOfficerPluginImpl.GAMMA_MULT);
            return new String[]{alpha + " \u500d", beta + " \u500d", gamma + " \u500d", "\u4e0d\u4f1a\u53d7\u5230\u4efb\u4f55\u6548\u679c\u7684\u5f71\u54cd"};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getAutomatedPointsTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (Misc.isAutomated(stats) && !Automated.isAutomatedNoPenalty(stats)) {
                float crBonus = this.computeAndCacheThresholdBonus(stats, "auto_cr", MAX_CR_BONUS, BaseSkillEffectDescription.ThresholdBonusType.AUTOMATED_POINTS);
                SkillSpecAPI skill = Global.getSettings().getSkillSpec("automated_ships");
                stats.getMaxCombatReadiness().modifyFlat(id, crBonus * 0.01f, String.valueOf(skill.getName()) + " \u6280\u80fd");
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float crBonus = this.computeAndCacheThresholdBonus(data, stats, "auto_cr", MAX_CR_BONUS, BaseSkillEffectDescription.ThresholdBonusType.AUTOMATED_POINTS);
            String partially = "";
            String penalty = Math.round(Automated.MAX_CR_PENALTY * 100.0f) + "%%";
            if ((float)((int)crBonus) < 100.0f) {
                partially = "\u90e8\u5206\u5730";
            }
            info.addPara("+%s \u6218\u5907\u503c (CR)(\u6700\u9ad8\uff1a%s)\uff0c" + partially + "\u7528\u4ee5\u62b5\u6d88\u5185\u7f6e\u8230\u8239\u63d2\u4ef6\u964d\u4f4e " + penalty + " \u6218\u5907\u503c (CR) \u7684\u60e9\u7f5a", 0.0f, this.hc, this.hc, (int)crBonus + "%", (int)MAX_CR_BONUS + "%");
            this.addAutomatedThresholdInfo(info, data, stats);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            if (stats.isPlayerStats()) {
                Misc.getAllowedRecoveryTags().add("auto_rec");
            }
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            if (stats.isPlayerStats()) {
                Misc.getAllowedRecoveryTags().remove("auto_rec");
            }
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("\u5141\u8bb8\u6062\u590d\u81ea\u52a8\u5316\u8230\u8239\uff0c\u5982\u635f\u574f\u7684\u65e0\u4eba\u673a", this.hc, 0.0f);
            info.addPara("\u81ea\u52a8\u5316\u8230\u8239\u53ea\u80fd\u7531 AI \u6838\u5fc3\u64cd\u63a7", this.hc, 0.0f);
            info.addSpacer(5.0f);
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

