/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class BallisticMastery {
    public static float PROJ_SPEED_BONUS = 33.0f;
    public static float DAMAGE_BONUS = 10.0f;
    public static float DAMAGE_ELITE = 5.0f;
    public static float RANGE_BONUS = 10.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getBallisticWeaponDamageMult().modifyPercent(id, DAMAGE_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponDamageMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)DAMAGE_BONUS + "% \u5b9e\u5f39\u6b66\u5668\u6240\u9020\u6210\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponRangeBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)RANGE_BONUS + "% \u5b9e\u5f39\u6b66\u5668\u7684\u5c04\u7a0b";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getBallisticProjectileSpeedMult().modifyPercent(id, PROJ_SPEED_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticProjectileSpeedMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)PROJ_SPEED_BONUS + "% \u5b9e\u5f39\u6b66\u5668\u7684\u5f39\u4f53\u98de\u884c\u901f\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getBallisticWeaponDamageMult().modifyPercent(id, DAMAGE_ELITE);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponDamageMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)DAMAGE_ELITE + "% \u5b9e\u5f39\u6b66\u5668\u6240\u9020\u6210\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

