/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;

public class BulkTransport {
    public static float CARGO_CAPACITY_MAX_PERCENT = 50.0f;
    public static float CARGO_CAPACITY_THRESHOLD = 2000.0f;
    public static float FUEL_CAPACITY_MAX_PERCENT = 50.0f;
    public static float FUEL_CAPACITY_THRESHOLD = 2000.0f;
    public static float PERSONNEL_CAPACITY_MAX_PERCENT = 50.0f;
    public static float PERSONNEL_CAPACITY_THRESHOLD = 5000.0f;
    public static float BURN_BONUS = 2.0f;

    public static abstract class BaseCapacityModifierEffect
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        protected abstract String getModifierId();

        protected abstract String getCacheKey();

        protected abstract String getCapacityString();

        protected abstract float getCapacity(FleetMemberAPI var1);

        protected abstract float getMaxPercent();

        protected abstract float getThreshold();

        protected abstract StatBonus getShipStat(MutableShipStatsAPI var1);

        protected abstract boolean withSpacerAfter();

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = this.getModifierId();
            float capBonus = this.getCapacityBonus(id, BaseCapacityModifierEffect.getFleetData(stats));
            this.getShipStat(stats).modifyMult(id, 1.0f + capBonus / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = this.getModifierId();
            this.getShipStat(stats).unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        protected float getCapacityBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float cap = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                cap += this.getCapacityBase(id, curr);
            }
            return cap;
        }

        protected float getCapacityBase(String id, FleetMemberAPI curr) {
            StatBonus stat = this.getShipStat(curr.getStats());
            MutableStat.StatMod mod = stat.getMultBonus(id);
            if (mod != null) {
                stat.unmodifyMult(mod.source);
            }
            float cap = this.getCapacity(curr);
            if (mod != null) {
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return cap;
        }

        protected float getCapacityBonus(String id, FleetDataAPI data) {
            if (data == null) {
                return this.getMaxPercent();
            }
            String key = this.getCacheKey();
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float base = this.getCapacityBase(id, data);
            bonus = Float.valueOf(this.getThresholdBasedRoundedBonus(this.getMaxPercent(), base, this.getThreshold()));
            data.getCacheClearedOnSync().put(key, bonus);
            return bonus.floatValue();
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = BaseCapacityModifierEffect.getFleetData(null);
            float capBonus = this.getCapacityBonus(this.getModifierId(), data);
            info.addPara("+%s " + this.getCapacityString().toLowerCase() + " (\u6700\u9ad8\uff1a%s) ", 0.0f, this.hc, this.hc, Math.round(capBonus) + "%", (int)this.getMaxPercent() + "%");
            if (BaseCapacityModifierEffect.isInCampaign()) {
                float baseCap = this.getCapacityBase(this.getModifierId(), data);
                info.addPara(String.valueOf(this.indent) + "\u5177\u4f53\u52a0\u6210\u5c06\u5728\u8230\u961f\u62e5\u6709\u8d85\u8fc7 %s \u7684 " + this.getCapacityString().toLowerCase() + " \u4e4b\u540e\u5f00\u59cb\u8870\u51cf\u3002\u800c\u5f53\u524d\u6709 %s \u7684" + this.getCapacityString().toLowerCase(), 0.0f, this.tc, this.hc, "" + (int)this.getThreshold(), "" + Math.round(baseCap));
            } else {
                info.addPara(String.valueOf(this.indent) + "\u5177\u4f53\u52a0\u6210\u5c06\u5728\u8230\u961f\u62e5\u6709\u8d85\u8fc7 %s \u7684 " + this.getCapacityString().toLowerCase() + " \u4e4b\u540e\u5f00\u59cb\u8870\u51cf\u3002", 0.0f, this.tc, this.hc, "" + (int)this.getThreshold());
            }
            if (this.withSpacerAfter()) {
                info.addSpacer(5.0f);
            }
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1
    extends BaseCapacityModifierEffect {
        public String getModifierId() {
            return "bt_cargo_cap_mod";
        }

        public String getCacheKey() {
            return "bt_cargo_cap";
        }

        public StatBonus getShipStat(MutableShipStatsAPI stats) {
            return stats.getCargoMod();
        }

        public float getCapacity(FleetMemberAPI member) {
            return member.getCargoCapacity();
        }

        public String getCapacityString() {
            return "\u8f7d\u8d27\u91cf";
        }

        public float getMaxPercent() {
            return CARGO_CAPACITY_MAX_PERCENT;
        }

        public float getThreshold() {
            return CARGO_CAPACITY_THRESHOLD;
        }

        public boolean withSpacerAfter() {
            return true;
        }
    }

    public static class Level2
    extends BaseCapacityModifierEffect {
        public String getModifierId() {
            return "bt_fuel_cap_mod";
        }

        public String getCacheKey() {
            return "bt_fuel_cap";
        }

        public StatBonus getShipStat(MutableShipStatsAPI stats) {
            return stats.getFuelMod();
        }

        public float getCapacity(FleetMemberAPI member) {
            return member.getFuelCapacity();
        }

        public String getCapacityString() {
            return "\u71c3\u6599\u5bb9\u91cf";
        }

        public float getMaxPercent() {
            return FUEL_CAPACITY_MAX_PERCENT;
        }

        public float getThreshold() {
            return FUEL_CAPACITY_THRESHOLD;
        }

        public boolean withSpacerAfter() {
            return true;
        }
    }

    public static class Level3
    extends BaseCapacityModifierEffect {
        public String getModifierId() {
            return "bt_crew_cap_mod";
        }

        public String getCacheKey() {
            return "bt_crew_cap";
        }

        public StatBonus getShipStat(MutableShipStatsAPI stats) {
            return stats.getMaxCrewMod();
        }

        public float getCapacity(FleetMemberAPI member) {
            return member.getMaxCrew();
        }

        public String getCapacityString() {
            return "\u6700\u5927\u8f7d\u5458\u91cf";
        }

        public float getMaxPercent() {
            return PERSONNEL_CAPACITY_MAX_PERCENT;
        }

        public float getThreshold() {
            return PERSONNEL_CAPACITY_THRESHOLD;
        }

        public boolean withSpacerAfter() {
            return true;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (Level4.isCivilian(stats)) {
                stats.getMaxBurnLevel().modifyFlat(id, BURN_BONUS);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxBurnLevel().unmodifyFlat(id);
        }

        public boolean hasCustomDescription() {
            return false;
        }

        public String getEffectDescription(float level) {
            return "\u6240\u6709\u975e\u519b\u4e8b\u5316\u6c11\u7528\u8239\u4f53\u7684\u5b87\u5b99\u822a\u884c\u901f\u5ea6 +" + (int)BURN_BONUS;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

