/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class CombatEndurance {
    public static float PEAK_TIME_BONUS = 60.0f;
    public static float DEGRADE_REDUCTION_PERCENT = 25.0f;
    public static float MAX_CR_BONUS = 15.0f;
    public static float MAX_REGEN_LEVEL = 1.0f;
    public static float REGEN_RATE = 0.005f;
    public static float TOTAL_REGEN_MAX_POINTS = 2000.0f;
    public static float TOTAL_REGEN_MAX_HULL_FRACTION = 0.5f;

    public static class CombatEnduranceRegen
    implements DamageTakenModifier,
    AdvanceableListener {
        protected ShipAPI ship;
        protected boolean inited = false;
        protected float limit = 0.0f;
        protected float repaired = 0.0f;
        protected String repKey1;
        protected String repKey2;

        public CombatEnduranceRegen(ShipAPI ship) {
            this.ship = ship;
        }

        protected void init() {
            this.inited = true;
            float maxHull = this.ship.getMaxHitpoints();
            this.limit = Math.max(TOTAL_REGEN_MAX_POINTS, TOTAL_REGEN_MAX_HULL_FRACTION * maxHull);
            this.repKey1 = "CombatEnduranceRegen_ " + this.ship.getId() + "_repaired";
            this.repKey2 = "CombatEnduranceRegen_ " + this.ship.getCaptain().getId() + "_repaired";
            float r1 = this.getRepaired(this.repKey1);
            float r2 = this.getRepaired(this.repKey2);
            this.repaired = Math.max(this.repaired, r1);
            this.repaired = Math.max(this.repaired, r2);
        }

        protected float getRepaired(String key) {
            Float r = (Float)Global.getCombatEngine().getCustomData().get(key);
            if (r == null) {
                r = Float.valueOf(0.0f);
            }
            return r.floatValue();
        }

        public void advance(float amount) {
            if (!this.inited) {
                this.init();
            }
            if (this.repaired >= this.limit) {
                return;
            }
            if (this.ship.getHullLevel() >= MAX_REGEN_LEVEL) {
                return;
            }
            if (this.ship.isHulk()) {
                return;
            }
            float maxHull = this.ship.getMaxHitpoints();
            float currHull = this.ship.getHitpoints();
            float maxPoints = maxHull * MAX_REGEN_LEVEL;
            float repairAmount = Math.min(this.limit - this.repaired, maxHull * REGEN_RATE * amount);
            if (repairAmount > maxPoints - currHull) {
                repairAmount = maxPoints - currHull;
            }
            if (repairAmount > 0.0f) {
                this.ship.setHitpoints(this.ship.getHitpoints() + repairAmount);
                this.repaired += repairAmount;
                Global.getCombatEngine().getCustomData().put(this.repKey1, Float.valueOf(this.repaired));
                Global.getCombatEngine().getCustomData().put(this.repKey2, Float.valueOf(this.repaired * 0.5f));
            }
        }

        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            return null;
        }
    }

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPeakCRDuration().modifyFlat(id, PEAK_TIME_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)PEAK_TIME_BONUS + " \u79d2\u5cf0\u503c\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCRLossPerSecondPercent().modifyMult(id, 1.0f - DEGRADE_REDUCTION_PERCENT / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCRLossPerSecondPercent().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)DEGRADE_REDUCTION_PERCENT + "% \u5cf0\u503c\u65f6\u95f4\u8017\u5c3d\u540e\u6574\u5907\u503c\u8870\u51cf\u7684\u901f\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, MAX_CR_BONUS * 0.01f, "\u6218\u6597\u8010\u529b");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MAX_CR_BONUS + "% \u6218\u5907\u503c (CR) \u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    AfterShipCreationSkillEffect {
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new CombatEnduranceRegen(ship));
        }

        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.removeListenerOfClass(CombatEnduranceRegen.class);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.initElite(stats, skill);
            info.addPara("\u5f53\u8239\u4f53\u7ed3\u6784\u503c\u4f4e\u4e8e %s \u65f6\uff0c\u6bcf\u79d2\u4fee\u590d %s \u7ed3\u6784\u503c\uff0c\u6700\u5927\u603b\u4fee\u590d\u91cf\u4e3a %s \u70b9\u7ed3\u6784\u503c\u6216 %s \u7684\u603b\u7ed3\u6784\u503c\uff0c\u6309\u4e24\u8005\u4e2d\u8f83\u9ad8\u8005\u8ba1\u7b97", 0.0f, this.hc, this.hc, Math.round(MAX_REGEN_LEVEL * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(REGEN_RATE * 100.0f) + "%", "" + Math.round(TOTAL_REGEN_MAX_POINTS), Math.round(TOTAL_REGEN_MAX_HULL_FRACTION * 100.0f) + "%");
        }
    }
}

