/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommRelayScript
extends BaseEveryFrameCombatPlugin {
    public static final float RATE_BONUS_PER_COMM_RELAY = 25.0f;
    public static final Object KEY_STATUS = new Object();
    public static final String BONUS_ID = "comm_relay_script_bonus";
    private CombatEngineAPI engine;
    private ShipAPI prevPlayerShip = null;
    private int skipFrames = 0;
    private Set<CombatFleetManagerAPI> needsCleanup = new HashSet<CombatFleetManagerAPI>();

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        ShipAPI playerShip = this.engine.getPlayerShip();
        if (playerShip != this.prevPlayerShip) {
            this.prevPlayerShip = playerShip;
            this.skipFrames = 20;
        }
        if (this.skipFrames > 0) {
            --this.skipFrames;
            return;
        }
        this.updateForSide(this.engine.getFleetManager(0));
        this.updateForSide(this.engine.getFleetManager(1));
    }

    private void updateForSide(CombatFleetManagerAPI manager) {
        PersonAPI commander = manager.getFleetCommander();
        if (commander == null) {
            manager.getTaskManager(false).getCPRateModifier().unmodify(BONUS_ID);
            return;
        }
        float total = 0.0f;
        float modifier = commander.getStats().getDynamic().getValue("command_point_rate");
        boolean relaysOnly = modifier == 1.0f;
        List<DeployedFleetMemberAPI> deployed = manager.getDeployedCopyDFM();
        for (DeployedFleetMemberAPI member : deployed) {
            if (member.isFighterWing()) continue;
            float curr = member.getShip().getMutableStats().getDynamic().getValue("command_point_rate_flat", 0.0f);
            total += curr;
        }
        if (total > 0.0f) {
            relaysOnly = false;
        }
        int numRelays = 0;
        for (BattleObjectiveAPI obj : this.engine.getObjectives()) {
            if (obj.getOwner() != manager.getOwner() || !"comm_relay".equals(obj.getType())) continue;
            total += 0.25f;
            ++numRelays;
        }
        manager.getTaskManager(false).getCPRateModifier().modifyFlat(BONUS_ID, total);
        modifier += manager.getTaskManager(false).getCPRateModifier().getModifiedValue();
        modifier -= 1.0f;
        if (manager.getOwner() == 0) {
            float withMult = manager.getTaskManager(false).getCPRateMult();
            String icon = Global.getSettings().getSpriteName("ui", "icon_tactical_coordinated_maneuvers");
            String title = "\u547d\u4ee4\u7f51\u7edc";
            String data = "+" + Math.round((withMult - 1.0f) * 100.0f) + "% \u547d\u4ee4\u70b9\u6062\u590d\u7387";
            boolean debuff = false;
            if (withMult < 1.0f) {
                data = Math.round((withMult - 1.0f) * 100.0f) + "% \u547d\u4ee4\u70b9\u6062\u590d\u7387";
                debuff = true;
            }
            if (withMult != 1.0f) {
                this.engine.maintainStatusForPlayerShip(KEY_STATUS, icon, title, data, debuff);
            }
        }
    }

    protected void cleanUpIfNeeded(CombatFleetManagerAPI manager) {
        if (this.needsCleanup.contains(manager)) {
            this.needsCleanup.remove(manager);
            List<DeployedFleetMemberAPI> deployed = manager.getDeployedCopyDFM();
            for (DeployedFleetMemberAPI member : deployed) {
                if (member.isFighterWing() || member.getShip() == null) continue;
                member.getShip().getMutableStats().getMaxSpeed().unmodify(BONUS_ID);
            }
        }
    }

    @Override
    public void renderInUICoords(ViewportAPI viewport) {
    }

    @Override
    public void renderInWorldCoords(ViewportAPI viewport) {
    }

    public boolean hasInputPriority() {
        return false;
    }
}

