/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;

public class CommandAndControl {
    public static final float BASE_SECONDS_PER_POINT = Global.getSettings().getFloat("baseSecondsPerCommandPoint");
    public static final float RATE_BONUS = 50.0f;
    public static final float CP_BONUS = 3.0f;
    public static final float CM_BONUS = 5.0f;
    public static final float EW_BONUS = 5.0f;

    public static class Level1A
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getCommandPoints().modifyFlat(id, 3.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getCommandPoints().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+3 \u6307\u6325\u70b9";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1B
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("command_point_rate").modifyFlat(id, 0.5f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getStat("command_point_rate").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+50% \u6307\u6325\u70b9\u6062\u590d\u901f\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3A
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("coord_maneuvers_max").modifyFlat(id, 5.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("coord_maneuvers_max").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+5% [\u534f\u8c03\u673a\u52a8] \u6280\u80fd\u6700\u5927\u6548\u679c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }

    public static class Level3B
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("electronic_warfare_max").modifyFlat(id, 5.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("electronic_warfare_max").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+5% [\u7535\u5b50\u6218] \u6280\u80fd\u6700\u5927\u6548\u679c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }
}

