/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ContainmentProcedures {
    public static float FUEL_PROD_BONUS = 1.0f;
    public static float CREW_LOSS_REDUCTION = 50.0f;
    public static float FUEL_SALVAGE_BONUS = 25.0f;
    public static float FUEL_USE_REDUCTION_MAX_PERCENT = 25.0f;
    public static float FUEL_USE_REDUCTION_MAX_FUEL = 25.0f;
    public static String FUEL_EFFECT_ID = "sp_fuel_use_mod";

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getOPTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float lossPercent = this.computeAndCacheThresholdBonus(stats, "sp_crewloss", CREW_LOSS_REDUCTION, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            stats.getCrewLossMult().modifyMult(id, 1.0f - lossPercent * 0.01f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCrewLossMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float damBonus = this.computeAndCacheThresholdBonus(data, stats, "sp_crewloss", CREW_LOSS_REDUCTION, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            info.addPara("-%s \u6218\u6597\u4e2d\u56e0\u8239\u4f53\u7ed3\u6784\u53d7\u635f\u800c\u9020\u6210\u7684\u8239\u5458\u4f24\u4ea1 (\u6700\u9ad8\uff1a%s) ", 0.0f, this.hc, this.hc, (int)damBonus + "%", (int)CREW_LOSS_REDUCTION + "%");
            this.addOPThresholdAll(info, data, stats, OP_ALL_THRESHOLD);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("emergency_burn_mult").modifyMult(id, 0.0f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("emergency_burn_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\"\u7d27\u6025\u52a0\u901f\" \u80fd\u529b\u4e0d\u518d\u964d\u4f4e\u6218\u5907\u503c (CR) ";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").modifyFlat(id, FUEL_SALVAGE_BONUS * 0.01f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").unmodify(id);
        }

        public String getEffectDescription(float level) {
            float max = 0.0f;
            return "+" + (int)(max += FUEL_SALVAGE_BONUS) + "% \u71c3\u6599\u6253\u635e";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            id = FUEL_EFFECT_ID;
            float useMult = this.getFuelUseMult(id, Level4.getFleetData(stats));
            stats.getFuelUseMod().modifyMult(id, useMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            id = FUEL_EFFECT_ID;
            stats.getFuelUseMod().unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        protected float getFuelUseBase(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            float fuelUse = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                StatBonus stat = curr.getStats().getFuelUseMod();
                MutableStat.StatMod mod = stat.getMultBonus(id);
                if (mod != null) {
                    stat.unmodifyMult(mod.source);
                }
                fuelUse += curr.getFuelUse();
                if (mod == null) continue;
                stat.modifyMult(mod.source, mod.value, mod.desc);
            }
            return fuelUse;
        }

        protected float getFuelUseMult(String id, FleetDataAPI data) {
            if (data == null) {
                return 0.0f;
            }
            String key = "conproc1";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float fuelUse = this.getFuelUseBase(id, data);
            float useMult = 0.0f;
            if (fuelUse > 0.0f) {
                float maxReduced = Math.min(fuelUse * (FUEL_USE_REDUCTION_MAX_PERCENT * 0.01f), FUEL_USE_REDUCTION_MAX_FUEL);
                useMult = 1.0f - maxReduced / fuelUse;
            }
            data.getCacheClearedOnSync().put(key, Float.valueOf(useMult));
            return useMult;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addSpacer(5.0f);
            info.addPara("-%s \u6216 %s \u5355\u4f4d\u7684\u71c3\u6599\u6d88\u8017\uff0c\u6309\u4e24\u8005\u4e2d\u8f83\u4f4e\u8005\u8ba1\u7b97", 0.0f, this.hc, this.hc, (int)FUEL_USE_REDUCTION_MAX_PERCENT + "%", "" + (int)FUEL_USE_REDUCTION_MAX_FUEL);
            if (Level4.isInCampaign()) {
                FleetDataAPI data = Global.getSector().getPlayerFleet().getFleetData();
                String id = FUEL_EFFECT_ID;
                float fuelUse = this.getFuelUseBase(id, data);
                float useMult = this.getFuelUseMult(id, data);
                float reduction = fuelUse * (1.0f - useMult);
                boolean has = stats.getSkillLevel(skill.getId()) > 0.0f;
                String string = ", ";
                if (!has) {
                    string = ", ";
                }
                info.addPara(String.valueOf(this.indent) + "\u4f60\u7684\u8230\u961f\u5f53\u524d\u71c3\u6599\u6d88\u8017\u4e3a %s" + string + "\u73b0\u5728\u964d\u4f4e %s}\uff0c\u5373 %s \u5355\u4f4d", 0.0f, this.tc, this.hc, Misc.getRoundedValueMaxOneAfterDecimal(fuelUse), Math.round((1.0f - useMult) * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(reduction));
                info.addSpacer(5.0f);
            }
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level5
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("fuel_supply_bonus").modifyFlat(id, FUEL_PROD_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("fuel_supply_bonus").unmodifyFlat(id);
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "governed colony");
            info.addSpacer(opad);
            info.addPara("+%s \u71c3\u6599\u4ea7\u91cf", 0.0f, this.hc, this.hc, "" + (int)FUEL_PROD_BONUS);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }
}

