/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CoordinatedManeuvers {
    public static final float CP_BONUS = 3.0f;
    public static float NAV_FRIGATES = 6.0f;
    public static float NAV_DESTROYERS = 3.0f;
    public static float NAV_OTHER = 1.0f;
    public static float CP_REGEN_FRIGATES = 50.0f;
    public static float CP_REGEN_DESTROYERS = 25.0f;

    public static boolean isFrigateOrDestroyerAndOfficer(MutableShipStatsAPI stats) {
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            String max = "20%";
            return "* \u5bfc\u822a\u6548\u7387\u53ef\u63d0\u9ad8\u5df2\u90e8\u7f72\u8230\u8239\u7684\u6700\u9ad8\u822a\u901f\uff0c\u6700\u9ad8\u63d0\u9ad8 " + max + "\u3002\u4f46\u5bf9\u6218\u673a\u65e0\u6548\u3002";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h};
        }

        public String[] getHighlights() {
            String max = "20%";
            String jammer = "+5%";
            return new String[]{jammer, max};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1A
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (CoordinatedManeuvers.isFrigateOrDestroyerAndOfficer(stats)) {
                float bonus = 0.0f;
                if (hullSize == ShipAPI.HullSize.FRIGATE) {
                    bonus = NAV_FRIGATES;
                }
                if (hullSize == ShipAPI.HullSize.DESTROYER) {
                    bonus = NAV_DESTROYERS;
                }
                if (hullSize == ShipAPI.HullSize.CRUISER || hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
                    bonus = NAV_OTHER;
                }
                if (bonus > 0.0f) {
                    stats.getDynamic().getMod("coord_maneuvers_flat").modifyFlat(id, bonus);
                }
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("coord_maneuvers_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            info.addPara("+%s \u5df2\u90e8\u7f72\u62a4\u536b\u8230\u7684 \u5bfc\u822a\u6548\u7387*\uff0c\u9a71\u9010\u8230 +%s}\uff0c\u800c\u5de1\u6d0b\u3001\u4e3b\u529b\u8230\u5219 +%s", 0.0f, this.hc, this.hc, (int)NAV_FRIGATES + "%", (int)NAV_DESTROYERS + "%", (int)NAV_OTHER + "%");
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level1B
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getCommandPoints().modifyFlat(id, 3.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getCommandPoints().unmodify(id);
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("+%s \u6307\u6325\u70b9", 0.0f, this.hc, this.hc, "3");
        }

        public String getEffectDescription(float level) {
            return "+3 \u6307\u6325\u70b9";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1C
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (CoordinatedManeuvers.isFrigateOrDestroyerAndOfficer(stats)) {
                float bonus = 0.0f;
                if (hullSize == ShipAPI.HullSize.FRIGATE) {
                    bonus = CP_REGEN_FRIGATES;
                }
                if (hullSize == ShipAPI.HullSize.DESTROYER) {
                    bonus = CP_REGEN_DESTROYERS;
                }
                if (bonus > 0.0f) {
                    stats.getDynamic().getMod("command_point_rate_flat").modifyFlat(id, bonus * 0.01f);
                }
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("command_point_rate_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("+%s \u6307\u6325\u70b9\u6062\u590d\u901f\u5ea6 (\u6bcf\u90e8\u7f72\u4e00\u4e2a\u62a4\u536b\u8230)\uff0c\u800c\u9a71\u9010\u8230\u5219 +%s", 0.0f, this.hc, this.hc, (int)CP_REGEN_FRIGATES + "%", (int)CP_REGEN_DESTROYERS + "%");
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

