/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CyberneticAugmentation {
    public static float MAX_ELITE_SKILLS_BONUS = 1.0f;
    public static float ECCM_BONUS = 5.0f;
    public static float BONUS_PER_ELITE_SKILL = 1.0f;

    public static boolean isOfficer(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (ship.getCaptain().isAICore()) {
                return false;
            }
            return !ship.getCaptain().isDefault();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        if (member.getCaptain().isAICore()) {
            return false;
        }
        return !member.getCaptain().isDefault();
    }

    public static boolean isFlagship(MutableShipStatsAPI stats) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (ship.getFleetMember() != null && ship.getFleetMember().getFleetCommander() == ship.getCaptain()) {
                return true;
            }
            return ship.getCaptain().isPlayer();
        }
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null) {
            return false;
        }
        if (member.isFlagship()) {
            return true;
        }
        return member.getCaptain().isPlayer();
    }

    public static float getNumEliteSkillsOfFleetCommander(MutableShipStatsAPI stats) {
        FleetMemberAPI member = stats.getFleetMember();
        if (member == null && stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            member = ship.getFleetMember();
        }
        if (member == null) {
            return 0.0f;
        }
        PersonAPI person = member.getFleetCommanderForStats();
        if (person == null) {
            person = member.getFleetCommander();
        }
        if (person == null) {
            return 0.0f;
        }
        MutableCharacterStatsAPI fcStats = person.getStats();
        if (fcStats == null) {
            return 0.0f;
        }
        return CyberneticAugmentation.getNumEliteSkills(fcStats);
    }

    public static float getNumEliteSkills(MutableCharacterStatsAPI stats) {
        float count = 0.0f;
        for (MutableCharacterStatsAPI.SkillLevelAPI sl : stats.getSkillsCopy()) {
            if (!(sl.getLevel() >= 2.0f) || !sl.getSkill().isElite()) continue;
            count += 1.0f;
        }
        return count;
    }

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            int base = Global.getSettings().getInt("officerMaxEliteSkills");
            return "\n* \u6bcf\u4e2a\u519b\u5b98\u57fa\u7840\u53ef\u62e5\u6709\u7cbe\u82f1\u6280\u80fd\u7684\u4e0a\u9650\u4e3a " + base + "\u3002";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        public String[] getHighlights() {
            int base = Global.getSettings().getInt("officerMaxEliteSkills");
            return new String[]{"" + base};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("officer_max_elite_skills_mod").modifyFlat(id, MAX_ELITE_SKILLS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("officer_max_elite_skills_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MAX_ELITE_SKILLS_BONUS + " \u519b\u5b98\u53ef\u62e5\u6709 \u7cbe\u82f1\u6280\u80fd* \u7684\u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.NONE;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u6240\u6709\u914d\u5907\u519b\u5b98\u7684\u8230\u8239\uff0c\u5305\u62ec\u65d7\u8230");
            info.addSpacer(opad);
            info.addPara("\u964d\u4f4e\u56e0\u7535\u5b50\u6218\u5931\u5229\u800c\u5bfc\u81f4\u7684\u6b66\u5668\u5c04\u7a0b\u60e9\u7f5a\uff0c\u6700\u9ad8\u964d\u4f4e\u767e\u5206\u4e4b %s", 0.0f, this.hc, this.hc, "" + (int)ECCM_BONUS);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (CyberneticAugmentation.isOfficer(stats)) {
                stats.getDynamic().getMod("electronic_warfare_penalty_mod").modifyFlat(id, -ECCM_BONUS);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("electronic_warfare_penalty_mod").unmodifyFlat(id);
        }
    }

    public static class Level3
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u6240\u6709\u914d\u5907\u519b\u5b98 (\u4e0d\u5305\u62ec AI \u6838\u5fc3) \u7684\u8230\u8239\uff0c\u5305\u62ec\u65d7\u8230");
            info.addSpacer(opad);
            float count = CyberneticAugmentation.getNumEliteSkills(stats);
            float bonus = count * BONUS_PER_ELITE_SKILL;
            info.addPara("%s \u9020\u6210\u7684\u4f24\u5bb3\u5e76 %s \u53d7\u5230\u7684\u4f24\u5bb3 (\u8be5\u6570\u636e\u4e3a\u5b9e\u65f6\u8ba1\u7b97\u5f97\u51fa\uff0c\u4f60\u6bcf\u62e5\u6709\u4e00\u4e2a \u7cbe\u82f1\u6280\u80fd \u90fd\u5c06\u63d0\u9ad8\u5176 %s)", 0.0f, this.hc, this.hc, "+" + Math.round(bonus) + "%", "-" + Math.round(bonus) + "%", Math.round(BONUS_PER_ELITE_SKILL) + "%");
            info.addPara("\u65d7\u8230\u6240\u53d7\u5230\u7684\u4e0a\u8ff0 '\u63d0\u9ad8\u9020\u6210\u7684\u4f24\u5bb3' \u76f8\u5173\u589e\u76ca\u7ffb\u500d", this.hc, 0.0f);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (CyberneticAugmentation.isOfficer(stats)) {
                float count = CyberneticAugmentation.getNumEliteSkillsOfFleetCommander(stats);
                float bonusDealt = count * BONUS_PER_ELITE_SKILL;
                float bonusTaken = count * BONUS_PER_ELITE_SKILL;
                if (CyberneticAugmentation.isFlagship(stats)) {
                    bonusDealt *= 2.0f;
                }
                stats.getArmorDamageTakenMult().modifyMult(id, 1.0f - bonusTaken / 100.0f);
                stats.getHullDamageTakenMult().modifyMult(id, 1.0f - bonusTaken / 100.0f);
                stats.getShieldDamageTakenMult().modifyMult(id, 1.0f - bonusTaken / 100.0f);
                stats.getBallisticWeaponDamageMult().modifyPercent(id, bonusDealt);
                stats.getEnergyWeaponDamageMult().modifyPercent(id, bonusDealt);
                stats.getMissileWeaponDamageMult().modifyPercent(id, bonusDealt);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getArmorDamageTakenMult().unmodifyMult(id);
            stats.getHullDamageTakenMult().unmodifyMult(id);
            stats.getShieldDamageTakenMult().unmodifyMult(id);
            stats.getBallisticWeaponDamageMult().unmodify(id);
            stats.getEnergyWeaponDamageMult().unmodify(id);
            stats.getMissileWeaponDamageMult().unmodify(id);
        }
    }
}

