/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class DamageControl {
    public static float SECONDS_PER_PROC = 2.0f;
    public static float INSTA_REPAIR = 0.25f;
    public static float CREW_LOSS_REDUCTION = 50.0f;
    public static float MODULE_REPAIR_BONUS = 50.0f;
    public static float HULL_DAMAGE_REDUCTION = 25.0f;
    public static float EMP_DAMAGE_REDUCTION = 25.0f;
    public static float ELITE_DAMAGE_THRESHOLD = 500.0f;
    public static float ELITE_DAMAGE_REDUCTION_PERCENT = 60.0f;
    public static float ELITE_DAMAGE_TO_HULL_PERCENT = 15.0f;

    public static class DamageControlDamageTakenMod
    implements DamageTakenModifier,
    AdvanceableListener {
        protected ShipAPI ship;
        protected float sinceProc = SECONDS_PER_PROC + 1.0f;

        public DamageControlDamageTakenMod(ShipAPI ship) {
            this.ship = ship;
        }

        public void advance(float amount) {
            this.sinceProc += amount;
        }

        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            if (!shieldHit && this.sinceProc > SECONDS_PER_PROC) {
                float mult = 1.0f - ELITE_DAMAGE_REDUCTION_PERCENT / 100.0f;
                this.ship.setNextHitHullDamageThresholdMult(ELITE_DAMAGE_THRESHOLD, mult);
                this.sinceProc = 0.0f;
            }
            return null;
        }
    }

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").modifyFlat(id, 1000.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("individual_ship_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u5982\u679c\u8be5\u8230\u5728\u6218\u6597\u4e2d\u88ab\u51fb\u6c89\uff0c\u5c06\u51e0\u4e4e\u603b\u662f\u53ef\u5728\u6218\u540e\u88ab\u6253\u635e\u5e76\u4fee\u590d\u3002";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCrewLossMult().modifyMult(id, 1.0f - CREW_LOSS_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCrewLossMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)CREW_LOSS_REDUCTION + "% \u7531\u4e8e\u7ed3\u6784\u53d7\u635f\u9020\u6210\u7684\u4eba\u5458\u4f24\u4ea1";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float timeMult = 1.0f / ((100.0f + MODULE_REPAIR_BONUS) / 100.0f);
            stats.getCombatWeaponRepairTimeMult().modifyMult(id, timeMult);
            stats.getCombatEngineRepairTimeMult().modifyMult(id, timeMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCombatWeaponRepairTimeMult().unmodify(id);
            stats.getCombatEngineRepairTimeMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return (int)MODULE_REPAIR_BONUS + "% \u7684\u6b66\u5668\u548c\u5f15\u64ce\u6218\u65f6\u4fee\u590d\u901f\u5ea6\u63d0\u5347";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHullDamageTakenMult().modifyMult(id, 1.0f - HULL_DAMAGE_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHullDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)HULL_DAMAGE_REDUCTION + "% \u8239\u4f53\u7ed3\u6784\u53d7\u5230\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("insta_repair_fraction").modifyFlat(id, INSTA_REPAIR);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("insta_repair_fraction").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return Math.round(INSTA_REPAIR * 100.0f) + "% \u7684\u7ed3\u6784\u548c\u88c5\u7532\u635f\u4f24\u5c06\u5728\u6218\u540e\u81ea\u52a8\u4fee\u590d\uff0c\u4e14\u4e0d\u6d88\u8017\u8865\u7ed9";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level6
    extends BaseSkillEffectDescription
    implements AfterShipCreationSkillEffect {
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new DamageControlDamageTakenMod(ship));
        }

        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.removeListenerOfClass(DamageControlDamageTakenMod.class);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            Color c = this.hc;
            float level = stats.getSkillLevel(skill.getId());
            if (level < 2.0f) {
                c = this.dhc;
            }
            String seconds = (int)SECONDS_PER_PROC + " \u79d2";
            if (SECONDS_PER_PROC == 1.0f) {
                seconds = "second";
            }
            info.addPara("\u6bcf " + seconds + "\u6700\u591a\u89e6\u53d1\u4e00\u6b21\uff0c\u5f53\u8239\u4f53\u7ed3\u6784\u53d7\u5230\u4e00\u6b21\u8d85\u8fc7 %s \u70b9\u7684\u4f24\u5bb3\u65f6\uff0c\u5176\u8d85\u8fc7 %s \u70b9\u7684\u90e8\u5206\u5c06\u964d\u4f4e %s", 0.0f, c, c, "" + (int)ELITE_DAMAGE_THRESHOLD, "" + (int)ELITE_DAMAGE_THRESHOLD, (int)ELITE_DAMAGE_REDUCTION_PERCENT + "%");
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level7
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToTargetHullMult().modifyPercent(id, ELITE_DAMAGE_TO_HULL_PERCENT);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToTargetHullMult().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)ELITE_DAMAGE_TO_HULL_PERCENT + "% \u5bf9\u8239\u4f53\u9020\u6210\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level8
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("can_repair_modules_under_fire").modifyFlat(id, 1.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("can_repair_modules_under_fire").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "\u5373\u4f7f\u6b63\u53d7\u5230\u6301\u7eed\u706b\u529b\uff0c\u4e5f\u80fd \u6301\u7eed\u4fee\u590d* \u53d7\u635f\u4f46\u672a\u4e0b\u7ebf\u7684\u6b66\u5668\u548c\u5f15\u64ce\u3002";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level8Desc
    implements DescriptionSkillEffect {
        public String getString() {
            return "\n\n*\u901a\u5e38\u800c\u8a00\uff0c\u53d7\u635f\u4f46\u672a\u4e0b\u7ebf\u7684\u6b66\u5668\u548c\u5f15\u64ce\u5c06\u5728\u8230\u8239\u4e0d\u53d7\u5230\u706b\u529b 5 \u79d2\u540e\u624d\u5f00\u59cb\u7ef4\u4fee\u3002";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        public String[] getHighlights() {
            return new String[]{"5"};
        }

        public Color getTextColor() {
            return null;
        }
    }
}

