/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class DefensiveSystems {
    public static final float FLUX_UPKEEP_REDUCTION = 25.0f;
    public static final float SHIELD_DAMAGE_REDUCTION = 20.0f;
    public static final float PHASE_COOLDOWN_REDUCTION = 25.0f;
    public static final float FLUX_SHUNT_DISSIPATION = 10.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getShieldUpkeepMult().modifyMult(id, 0.75f);
            stats.getPhaseCloakUpkeepCostBonus().modifyMult(id, 0.75f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getShieldUpkeepMult().unmodify(id);
            stats.getPhaseCloakUpkeepCostBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-25% \u7ef4\u6301\u62a4\u76fe\u548c\u8fdb\u5165\u76f8\u4f4d\u72b6\u6001\u65f6\u4ea7\u751f\u7684\u5e45\u80fd";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getShieldDamageTakenMult().modifyMult(id, 0.8f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getShieldDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-20% \u62a4\u76fe\u53d7\u5230\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2B
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPhaseCloakCooldownBonus().modifyMult(id, 0.75f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPhaseCloakCooldownBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-25% \u518d\u6b21\u8fdb\u5165\u76f8\u4f4d\u72b6\u6001\u7684\u51b7\u5374\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHardFluxDissipationFraction().modifyFlat(id, 0.1f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHardFluxDissipationFraction().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u5373\u4fbf\u62a4\u76fe\u5904\u4e8e\u6fc0\u6d3b\u72b6\u6001\uff0c\u4e5f\u80fd\u4ee5 10% \u7684\u901f\u7387\u8017\u6563\u786c\u5e45\u80fd";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3B
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getStat("phase_time_mult").modifyFlat(id, 0.5f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getStat("phase_time_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u8fdb\u5165\u76f8\u4f4d\u72b6\u6001\u7684\u65f6\u95f4\u52a0\u901f\u6548\u679c\u4ece 3 \u500d\u901f\u63d0\u9ad8\u5230 4 \u500d\u901f";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

