/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class DerelictContingent {
    public static float MAX_DMODS = 5.0f;
    public static float MINUS_CR_PER_DMOD = 0.0f;
    public static float MINUS_DP_PERCENT_PER_DMOD = 6.0f;
    public static float EXTRA_DMODS = 4.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            return "* \u8fbe\u5230\u589e\u76ca\u4e0a\u9650\u7684 D-\u63d2\u4ef6 \u6570\u91cf\u4e3a " + (int)MAX_DMODS + "\u3002";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        public String[] getHighlights() {
            return new String[]{"" + (int)MAX_DMODS};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            FleetMemberAPI member = stats.getFleetMember();
            float dmods = 0.0f;
            if (member != null && (dmods = (float)DModManager.getNumDMods(member.getVariant())) > MAX_DMODS) {
                dmods = MAX_DMODS;
            }
            if (dmods > 0.0f) {
                float depBonus = dmods * MINUS_DP_PERCENT_PER_DMOD;
                stats.getDynamic().getMod("deployment_points_mod").modifyMult(id, 1.0f - depBonus / 100.0f);
                stats.getDynamic().getMod("dmod_reduce_maintenance").modifyFlat(id, 1.0f);
                if (MINUS_CR_PER_DMOD > 0.0f) {
                    float crPenalty = MINUS_CR_PER_DMOD * dmods;
                    stats.getMaxCombatReadiness().modifyFlat(id, -crPenalty * 0.01f, "\u5e9f\u8239\u8230\u961f");
                }
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("deployment_points_mod").unmodify(id);
            stats.getDynamic().getMod("dmod_reduce_maintenance").unmodify(id);
            if (MINUS_CR_PER_DMOD > 0.0f) {
                stats.getMaxCombatReadiness().unmodify(id);
            }
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            info.addPara("\u6bcf\u62e5\u6709\u4e00\u4e2a D-\u63d2\u4ef6* \u5c31 -%s \u90e8\u7f72\u70b9", 0.0f, this.hc, this.hc, (int)MINUS_DP_PERCENT_PER_DMOD + "%");
            if (MINUS_CR_PER_DMOD > 0.0f) {
                info.addPara("\u964d\u4f4e (D) \u8230\u8239\u90e8\u7f72\u6210\u672c\u7684\u540c\u65f6\u4e5f\u4f1a\u964d\u4f4e\u5176\u7ef4\u62a4\u6210\u672c\uff0c\u4f46\u6bcf\u4e2a D-\u63d2\u4ef6* \u4f1a\u8ba9\u6218\u5907\u503c (CR) \u4e0a\u9650 -%s", 0.0f, this.hc, this.hc, (int)MINUS_CR_PER_DMOD + "%");
            } else {
                info.addPara("\u964d\u4f4e (D) \u8230\u8239\u90e8\u7f72\u6210\u672c\u540c\u65f6\u4e5f\u964d\u4f4e\u5176\u7ef4\u62a4\u6210\u672c", this.hc, 0.0f);
            }
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").modifyFlat(id, -EXTRA_DMODS);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u63d0\u9ad8\u4fee\u590d\u505c\u673a\u8230\u8239\u65f6\u51fa\u73b0  D-\u63d2\u4ef6 \u7684\u6982\u7387";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

