/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.campaign.skills.ElectronicWarfareScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ElectronicWarfare {
    public static float PER_SHIP_BONUS = 1.0f;
    public static float CAP_RANGE = 1000.0f;
    public static float CAP_RATE = 5.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        public String getString() {
            String max = String.valueOf((int)ElectronicWarfareScript.BASE_MAXIMUM) + "%";
            return "* \u654c\u4eba\u6b66\u5668\u5c04\u7a0b\u4f1a\u6839\u636e\u4f60\u90e8\u7f72\u8230\u8239\u7684 \u7535\u5b50\u6218\u5f3a\u5ea6 \u88ab\u964d\u4f4e\u81f3\u591a " + max + "\u3002\u8be5\u51cf\u76ca\u4f1a\u6839\u636e\u5bf9\u65b9" + "\u7535\u5b50\u6218\u5f3a\u5ea6 \u5bf9\u5df1\u65b9 \u7535\u5b50\u6218\u5f3a\u5ea6 \u7684\u6bd4\u4f8b\u51cf\u5f31\u3002" + "\u5bf9\u6218\u673a\u65e0\u6548\uff0c\u5f71\u54cd\u5305\u62ec\u5bfc\u5f39\u5185\u7684\u6240\u6709\u6b66\u5668\u3002";
        }

        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h, h};
        }

        public String[] getHighlights() {
            String max = String.valueOf((int)ElectronicWarfareScript.BASE_MAXIMUM) + "%";
            return new String[]{max};
        }

        public Color getTextColor() {
            return null;
        }
    }

    public static class Level0WithNewline
    extends Level0 {
        public String getString() {
            return "\n" + super.getString();
        }
    }

    public static class Level1A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!BaseSkillEffectDescription.isCivilian(stats)) {
                stats.getDynamic().getMod("electronic_warfare_flat").modifyFlat(id, PER_SHIP_BONUS);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("electronic_warfare_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u6bcf\u8258\u90e8\u7f72\u7684\u8230\u8239\u90fd\u53ef\u63d0\u4f9b " + (int)PER_SHIP_BONUS + "% \u7684 \u7535\u5b50\u6218\u5f3a\u5ea6*";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level1B
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!BaseSkillEffectDescription.isCivilian(stats)) {
                stats.getDynamic().getMod("ship_objective_cap_range_mod").modifyFlat(id, CAP_RANGE);
                stats.getDynamic().getStat("ship_objective_cap_rate_mult").modifyMult(id, CAP_RATE);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("ship_objective_cap_range_mod").unmodifyFlat(id);
            stats.getDynamic().getStat("ship_objective_cap_rate_mult").unmodifyMult(id);
        }

        public String getEffectDescription(float level) {
            return "\u53ef\u5728\u66f4\u8fdc\u7684\u8ddd\u79bb\u4e4b\u5916\u4ee5\u66f4\u5feb\u7684\u901f\u5ea6\u5360\u9886\u6218\u573a\u4e0a\u7684\u76ee\u6807\u70b9";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level1C
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("ship_belongs_to_fleet_that_can_counter_ew").modifyFlat(id, 1.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("ship_belongs_to_fleet_that_can_counter_ew").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            String excess = "" + Math.round(ElectronicWarfareScript.BASE_MAXIMUM * 2.0f);
            return "\u4f60\u603b\u7535\u5b50\u6218\u5f3a\u5ea6\u4e4b\u4e2d\u8d85\u8fc7 " + excess + "% \u7684\u90e8\u5206\uff0c\u5c06\u4ee5 2:1 \u7684\u6bd4\u7387\u62b5\u6d88\u654c\u65b9\u7684\u7535\u5b50\u6218\u5f3a\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

