/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class FieldModulation {
    public static float SHIELD_DAMAGE_REDUCTION = 15.0f;
    public static float FLUX_SHUNT_DISSIPATION = 20.0f;
    public static float PHASE_FLUX_UPKEEP_REDUCTION = 25.0f;
    public static float PHASE_COOLDOWN_REDUCTION = 50.0f;
    public static float ELITE_DAMAGE_TO_SHIELDS_PERCENT = 5.0f;
    public static float OVERLOAD_REDUCTION = 25.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getShieldDamageTakenMult().modifyMult(id, 1.0f - SHIELD_DAMAGE_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getShieldDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)SHIELD_DAMAGE_REDUCTION + "% \u62a4\u76fe\u6240\u53d7\u5230\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPhaseCloakUpkeepCostBonus().modifyMult(id, 1.0f - PHASE_FLUX_UPKEEP_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPhaseCloakUpkeepCostBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)PHASE_FLUX_UPKEEP_REDUCTION + "% \u6fc0\u6d3b\u76f8\u4f4d\u9690\u5f62\u6240\u4ea7\u751f\u7684\u5e45\u80fd";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHardFluxDissipationFraction().modifyFlat(id, FLUX_SHUNT_DISSIPATION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHardFluxDissipationFraction().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return (int)FLUX_SHUNT_DISSIPATION + "% \u7684\u901f\u7387\u8017\u6563\u786c\u5e45\u80fd (\u62a4\u76fe\u5904\u4e8e\u6fc0\u6d3b\u72b6\u6001\u4e0b) ";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPhaseCloakCooldownBonus().modifyMult(id, 1.0f - PHASE_COOLDOWN_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPhaseCloakCooldownBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)PHASE_COOLDOWN_REDUCTION + "% \u6fc0\u6d3b\u76f8\u4f4d\u9690\u5f62\u7684\u51b7\u5374\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level5
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToTargetShieldsMult().modifyPercent(id, ELITE_DAMAGE_TO_SHIELDS_PERCENT);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToTargetShieldsMult().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)ELITE_DAMAGE_TO_SHIELDS_PERCENT + "% \u5bf9\u62a4\u76fe\u9020\u6210\u7684\u4f24\u5bb3";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level6
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getOverloadTimeMod().modifyMult(id, 1.0f - OVERLOAD_REDUCTION / 100.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getOverloadTimeMod().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)OVERLOAD_REDUCTION + "% \u8fc7\u8f7d\u65f6\u95f4";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

