/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;

public class FieldRepairs {
    public static final float MIN_HULL = 30.0f;
    public static final float MAX_HULL = 40.0f;
    public static final float MIN_CR = 30.0f;
    public static final float MAX_CR = 40.0f;
    public static final float REPAIR_RATE_BONUS = 50.0f;
    public static final float INSTA_REPAIR_PERCENT = 25.0f;

    public static class Level1
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getOPTotal();
        }

        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            FleetDataAPI data = null;
            if (stats != null && stats.getFleet() != null) {
                data = stats.getFleet().getFleetData();
            }
            float repBonus = this.computeAndCacheThresholdBonus(data, stats, "fr_repRate", 50.0f, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            stats.getRepairRateMult().modifyPercent(id, repBonus);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getRepairRateMult().unmodify(id);
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = null;
            if (stats != null && stats.getFleet() != null) {
                data = stats.getFleet().getFleetData();
            }
            float damBonus = this.computeAndCacheThresholdBonus(data, stats, "fr_repRate", 50.0f, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            info.addPara("+%s \u6218\u6597\u5916\u7684\u7ef4\u4fee\u901f\u7387 (\u6700\u9ad8\uff1a%s) ", 0.0f, this.hc, this.hc, (int)damBonus + "%", "50%");
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getOPTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float instaRep = this.computeAndCacheThresholdBonus(stats, "fr_instaRep", 25.0f, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            stats.getDynamic().getMod("insta_repair_fraction").modifyFlat(id, instaRep * 0.01f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("insta_repair_fraction").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level2.getFleetData(null);
            float instaRep = this.computeAndCacheThresholdBonus(data, stats, "fr_instaRep", 25.0f, BaseSkillEffectDescription.ThresholdBonusType.OP_ALL);
            info.addPara("\u6218\u6597\u7ed3\u675f\u540e\uff0c\u514d\u8d39\u4fee\u590d %s \u7684\u7ed3\u6784\u548c\u88c5\u7532\u635f\u4f24 (\u6700\u9ad8\uff1a%s) ", 0.0f, this.hc, this.hc, (int)instaRep + "%", "25%");
            this.addOPThresholdAll(info, data, stats, OP_ALL_THRESHOLD);
            info.addSpacer(5.0f);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level5A
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_recovery_hull_min").modifyFlat(id, 0.29999998f);
            stats.getDynamic().getMod("ship_recovery_hull_max").modifyFlat(id, 0.39999998f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_recovery_hull_min").unmodify(id);
            stats.getDynamic().getMod("ship_recovery_hull_max").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u88ab\u6253\u635e\u7684\u8230\u8239\u5c06\u7acb\u523b\u6062\u590d 30-40% \u7684\u8239\u4f53\u7ed3\u6784\u503c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level5B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_recovery_cr_min").modifyFlat(id, 0.29999998f);
            stats.getDynamic().getMod("ship_recovery_cr_max").modifyFlat(id, 0.39999998f);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_recovery_cr_min").unmodify(id);
            stats.getDynamic().getMod("ship_recovery_cr_max").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u88ab\u6253\u635e\u7684\u8230\u8239\u5c06\u7acb\u523b\u6062\u590d 30-40% \u7684\u6574\u5907\u503c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

