/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.LinkedHashSet;
import java.util.Random;

public class FieldRepairsScript
implements EveryFrameScript {
    public static int MONTHS_PER_DMOD_REMOVAL = 1;
    public static float RATE_DP_MAX = 40.0f;
    public static float RATE_DP_MIN = 4.0f;
    public static float MAX_RATE_MULT = 3.0f;
    public static boolean REMOVE_DMOD_FROM_NEW_SHIPS = true;
    public static float MIN_NEW_REMOVE_PROB = 0.2f;
    public static float NEW_REMOVE_PROB_PER_DMOD = 0.2f;
    protected IntervalUtil tracker = new IntervalUtil(10.0f, 20.0f);
    protected IntervalUtil tracker2 = new IntervalUtil(3.0f, 5.0f);
    protected FleetMemberAPI pickedNew = null;
    protected String dmodNew = null;
    protected Random newRandom = new Random(Misc.genRandomSeed());
    protected LinkedHashSet<String> seen = new LinkedHashSet();
    protected FleetMemberAPI picked = null;
    protected String dmod = null;

    Object readResolve() {
        if (this.seen == null) {
            this.seen = new LinkedHashSet();
        }
        if (this.tracker2 == null) {
            this.tracker2 = new IntervalUtil(3.0f, 5.0f);
        }
        if (this.newRandom == null) {
            this.newRandom = new Random(Misc.genRandomSeed());
        }
        return this;
    }

    public void advance(float amount) {
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        if (fleet == null) {
            return;
        }
        if (Global.getSector().getPlayerStats().getSkillLevel("hull_restoration") <= 0.0f) {
            this.picked = null;
            this.dmod = null;
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        float rateMult = 1.0f / (float)MONTHS_PER_DMOD_REMOVAL;
        if (this.picked != null) {
            float dp = this.picked.getDeploymentPointsCost();
            float f = (dp - RATE_DP_MIN) / (RATE_DP_MAX - RATE_DP_MIN);
            if ((f = 1.0f - f) > 1.0f) {
                f = 1.0f;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            rateMult *= 1.0f + (MAX_RATE_MULT - 1.0f) * f;
        }
        this.tracker.advance(days * rateMult * 0.5f);
        if (this.tracker.intervalElapsed()) {
            if (this.picked == null || this.dmod == null) {
                this.pickNext();
            } else {
                if (fleet.getFleetData().getMembersListCopy().contains(this.picked) && DModManager.getNumDMods(this.picked.getVariant()) > 0) {
                    DModManager.removeDMod(this.picked.getVariant(), this.dmod);
                    HullModSpecAPI spec = DModManager.getMod(this.dmod);
                    MessageIntel intel = new MessageIntel(String.valueOf(this.picked.getShipName()) + " - \u4fee\u590d " + spec.getDisplayName(), Misc.getBasePlayerColor());
                    intel.setIcon(Global.getSettings().getSpriteName("intel", "repairs_finished"));
                    Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.REFIT_TAB, this.picked);
                    int dmods = DModManager.getNumDMods(this.picked.getVariant());
                    if (dmods <= 0) {
                        FieldRepairsScript.restoreToNonDHull(this.picked.getVariant());
                    }
                }
                this.picked = null;
                this.pickNext();
            }
        }
        this.tracker2.advance(days);
        if (this.tracker2.intervalElapsed() && REMOVE_DMOD_FROM_NEW_SHIPS) {
            if (this.pickedNew == null || this.dmodNew == null) {
                this.pickNextNew();
            } else {
                this.seen.add(this.pickedNew.getId());
                float numDmods = DModManager.getNumDMods(this.pickedNew.getVariant());
                if (fleet.getFleetData().getMembersListCopy().contains(this.pickedNew) && numDmods > 0.0f) {
                    float probRemove = MIN_NEW_REMOVE_PROB + numDmods * NEW_REMOVE_PROB_PER_DMOD;
                    if (this.newRandom.nextFloat() < probRemove) {
                        DModManager.removeDMod(this.pickedNew.getVariant(), this.dmodNew);
                        HullModSpecAPI spec = DModManager.getMod(this.dmodNew);
                        MessageIntel intel = new MessageIntel(String.valueOf(this.pickedNew.getShipName()) + " - \u4fee\u590d " + spec.getDisplayName(), Misc.getBasePlayerColor());
                        intel.setIcon(Global.getSettings().getSpriteName("intel", "repairs_finished"));
                        Global.getSector().getCampaignUI().addMessage(intel, CommMessageAPI.MessageClickAction.REFIT_TAB, this.pickedNew);
                        int dmods = DModManager.getNumDMods(this.pickedNew.getVariant());
                        if (dmods <= 0) {
                            FieldRepairsScript.restoreToNonDHull(this.pickedNew.getVariant());
                        }
                    }
                }
                this.pickedNew = null;
                this.pickNextNew();
            }
        }
    }

    public void pickNext() {
        this.picked = null;
        this.dmod = null;
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>();
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            int dmods;
            if (member.getVariant().isStockVariant() || member.isMothballed() || member.getHullSpec().hasTag("unrestorable") || member.getVariant().hasTag("unrestorable") || (dmods = DModManager.getNumNonBuiltInDMods(member.getVariant())) <= 0) continue;
            picker.add(member, 1.0f);
        }
        this.picked = (FleetMemberAPI)picker.pick();
        if (this.picked != null) {
            ShipVariantAPI variant = this.picked.getVariant();
            WeightedRandomPicker<String> modPicker = new WeightedRandomPicker<String>();
            for (String id : variant.getHullMods()) {
                if (!DModManager.getMod(id).hasTag("dmod") || variant.getHullSpec().getBuiltInMods().contains(id)) continue;
                modPicker.add(id);
            }
            this.dmod = (String)modPicker.pick();
            if (this.dmod == null) {
                this.picked = null;
            }
        }
    }

    public void pickNextNew() {
        this.pickedNew = null;
        this.dmodNew = null;
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>();
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.getVariant().isStockVariant() || member.isMothballed() || member.getHullSpec().hasTag("unrestorable") || member.getVariant().hasTag("unrestorable")) {
                this.seen.add(member.getId());
                continue;
            }
            if (this.seen.contains(member.getId())) continue;
            int dmods = DModManager.getNumNonBuiltInDMods(member.getVariant());
            if (dmods > 0) {
                picker.add(member, 1.0f);
                continue;
            }
            this.seen.add(member.getId());
        }
        this.pickedNew = (FleetMemberAPI)picker.pick();
        if (this.pickedNew != null) {
            ShipVariantAPI variant = this.pickedNew.getVariant();
            WeightedRandomPicker<String> modPicker = new WeightedRandomPicker<String>();
            for (String id : variant.getHullMods()) {
                if (!DModManager.getMod(id).hasTag("dmod") || variant.getHullSpec().getBuiltInMods().contains(id)) continue;
                modPicker.add(id);
            }
            this.dmodNew = (String)modPicker.pick();
            if (this.dmodNew == null) {
                this.pickedNew = null;
            }
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static void restoreToNonDHull(ShipVariantAPI v) {
        ShipHullSpecAPI base = v.getHullSpec().getDParentHull();
        if (!v.getHullSpec().isDefaultDHull() && !v.getHullSpec().isRestoreToBase()) {
            base = v.getHullSpec();
        }
        if (base == null && v.getHullSpec().isRestoreToBase()) {
            base = v.getHullSpec().getBaseHull();
        }
        if (base != null) {
            v.setHullSpecAPI(base);
        }
    }
}

