/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CustomSkillDescription;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class FighterDoctrine {
    public static final float FIGHTER_CREW_LOSS_REDUCTION = 15.0f;
    public static final float FIGHTER_RAMAGE_REDUCTION = 15.0f;
    public static final float FIGHTER_REPLACEMENT_RATE_BONUS = 15.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getStat("fighter_crew_loss_mult").modifyMult(id, 0.85f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getStat("fighter_crew_loss_mult").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-15% \u56e0\u6218\u673a\u51fb\u843d\u800c\u5bfc\u81f4\u7684\u4eba\u5458\u4f24\u4ea1";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getHullDamageTakenMult().modifyMult(id, 0.85f);
            stats.getArmorDamageTakenMult().modifyMult(id, 0.85f);
            stats.getShieldDamageTakenMult().modifyMult(id, 0.85f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getHullDamageTakenMult().unmodify(id);
            stats.getArmorDamageTakenMult().unmodify(id);
            stats.getShieldDamageTakenMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-15% \u8239\u4f53\u7ed3\u6784\u635f\u4f24";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_FIGHTERS;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float timeMult = 0.86956525f;
            stats.getFighterRefitTimeMult().modifyMult(id, timeMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFighterRefitTimeMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "15% \u6218\u673a\u6574\u5907\u901f\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Test
    implements ShipSkillEffect,
    CustomSkillDescription {
        protected float getReplacementRateBonus(MutableShipStatsAPI stats) {
            FleetMemberAPI member = stats.getFleetMember();
            if (member == null) {
                return 0.0f;
            }
            FleetDataAPI data = member.getFleetDataForStats();
            if (data == null) {
                data = member.getFleetData();
            }
            if (data == null) {
                return 0.0f;
            }
            return this.getReplacementRateBonus(data);
        }

        protected float getReplacementRateBonus(FleetDataAPI data) {
            String key = "fd1";
            Float bonus = (Float)data.getCacheClearedOnSync().get(key);
            if (bonus != null) {
                return bonus.floatValue();
            }
            float bays = 0.0f;
            for (FleetMemberAPI curr : data.getMembersListCopy()) {
                bays += (float)curr.getNumFlightDecks();
            }
            bonus = Float.valueOf(Math.round(300.0f / Math.max(bays, 6.0f)));
            data.getCacheClearedOnSync().put(key, bonus);
            return bonus.floatValue();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float bonus = this.getReplacementRateBonus(stats);
            float timeMult = 1.0f / ((100.0f + bonus) / 100.0f);
            stats.getFighterRefitTimeMult().modifyMult(id, timeMult);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFighterRefitTimeMult().unmodify(id);
        }

        public boolean hasCustomDescription() {
            return true;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            Color textColor = Misc.getTextColor();
            Color highlightColor = Misc.getHighlightColor();
            Color darkHighlightColor = Misc.setAlpha(highlightColor, 155);
            int alpha = 255;
            float level = stats.getSkillLevel(skill.getId());
            if (level <= 0.0f) {
                textColor = Misc.getGrayColor();
                highlightColor = darkHighlightColor;
                alpha = 155;
            }
            if (Global.getCurrentState() == GameState.CAMPAIGN) {
                float bonus = this.getReplacementRateBonus(Global.getSector().getPlayerFleet().getFleetData());
                info.addPara("%s \u6218\u673a\u6574\u5907\u901f\u5ea6 (\u57fa\u4e8e\u8230\u961f\u7684\u98de\u884c\u7532\u677f\u6570\u91cf) ", 0.0f, textColor, highlightColor, (int)bonus + "%");
            }
        }

        public String getEffectDescription(float level) {
            float bonus = this.getReplacementRateBonus(Global.getSector().getPlayerFleet().getFleetData());
            return (int)bonus + "% \u6218\u673a\u6574\u5907\u901f\u5ea6 (\u57fa\u4e8e\u8230\u961f\u7684\u98de\u884c\u7532\u677f\u6570\u91cf) ";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

