/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class FluxRegulation {
    public static int VENTS_BONUS = 5;
    public static int CAPACITORS_BONUS = 5;
    public static float DISSIPATION_PERCENT = 10.0f;
    public static float CAPACITY_PERCENT = 10.0f;

    public static class Level1
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    FleetTotalSource {
        public FleetTotalItem getFleetTotalItem() {
            return this.getCombatOPTotal();
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (!Level1.isCivilian(stats)) {
                float disBonus = this.computeAndCacheThresholdBonus(stats, "fr_dis", DISSIPATION_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
                float capBonus = this.computeAndCacheThresholdBonus(stats, "fr_cap", CAPACITY_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
                stats.getFluxDissipation().modifyPercent(id, disBonus);
                stats.getFluxCapacity().modifyPercent(id, capBonus);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxDissipation().unmodifyPercent(id);
            stats.getFluxCapacity().unmodifyPercent(id);
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            FleetDataAPI data = Level1.getFleetData(null);
            float disBonus = this.computeAndCacheThresholdBonus(data, stats, "fr_dis", DISSIPATION_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
            float capBonus = this.computeAndCacheThresholdBonus(data, stats, "fr_cap", CAPACITY_PERCENT, BaseSkillEffectDescription.ThresholdBonusType.OP);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u6240\u6709\u6218\u6597\u8230\u8239\uff0c\u5305\u62ec\u822a\u6bcd\u548c\u914d\u5907\u4e86 \u519b\u4e8b\u5316\u5b50\u7cfb\u7edf \u7684\u6c11\u7528\u8239\u4f53");
            info.addPara("+%s \u4f5c\u6218\u8230\u8239\u7684\u5e45\u80fd\u8017\u6563 (\u6700\u9ad8\uff1a%s) ", opad, this.hc, this.hc, (int)disBonus + "%", (int)DISSIPATION_PERCENT + "%");
            info.addPara("+%s \u4f5c\u6218\u8230\u8239\u7684\u5e45\u80fd\u5bb9\u91cf (\u6700\u9ad8\uff1a%s) ", 0.0f, this.hc, this.hc, (int)capBonus + "%", (int)CAPACITY_PERCENT + "%");
            this.addOPThresholdInfo(info, data, stats);
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxCapacitorsBonus().modifyFlat(id, CAPACITORS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxCapacitorsBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + CAPACITORS_BONUS + " \u5e45\u80fd\u5bc4\u5b58\u5668\u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxVentsBonus().modifyFlat(id, VENTS_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxVentsBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + VENTS_BONUS + " \u8017\u6563\u901a\u9053\u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

