/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ForceConcentration {
    public static float ZERO_FLUX_SPEED_BONUS_SMALL = 25.0f;
    public static float ZERO_FLUX_SPEED_BONUS;
    public static float ZERO_FLUX_ACCEL_BONUS;
    public static float ZERO_FLUX_TURN_BONUS;
    public static float ZERO_FLUX_TURN_ACCEL_BONUS;
    public static float COMMAND_POINT_REGEN_PERCENT;

    static {
        ZERO_FLUX_ACCEL_BONUS = ZERO_FLUX_SPEED_BONUS = 100.0f;
        ZERO_FLUX_TURN_BONUS = 20.0f;
        ZERO_FLUX_TURN_ACCEL_BONUS = ZERO_FLUX_TURN_BONUS * 2.0f;
        COMMAND_POINT_REGEN_PERCENT = 100.0f;
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
        }

        public String getEffectDescription(float level) {
            return "+" + (int)ZERO_FLUX_SPEED_BONUS + " \u96f6\u5e45\u80fd\u4e0b\u7684\u822a\u901f\u4e0e\u673a\u52a8\u6027 (\u9644\u8fd1\u6ca1\u6709\u654c\u4eba\u7684\u60c5\u51b5\u4e0b)\uff0c\u5426\u5219 +" + (int)ZERO_FLUX_SPEED_BONUS_SMALL + " \u96f6\u5e45\u80fd\u4e0b\u7684\u822a\u901f\u4e0e\u673a\u52a8\u6027";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("can_deploy_left_right").modifyFlat(id, 1.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("can_deploy_left_right").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "\u80fd\u591f\u5728\u6240\u6709\u6218\u6597\u573a\u666f\u4e2d\uff0c\u4fa7\u7ffc\u90e8\u7f72\u4efb\u4f55\u89c4\u6a21\u5927\u5c0f\u7684\u8230\u8239";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("command_point_rate").modifyFlat(id, COMMAND_POINT_REGEN_PERCENT / 100.0f);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getStat("command_point_rate").unmodify(id);
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u8230\u961f");
            info.addSpacer(opad);
            info.addPara("+%s \u6307\u6325\u70b9\u6062\u590d\u901f\u5ea6", 0.0f, this.hc, this.hc, (int)COMMAND_POINT_REGEN_PERCENT + "%");
        }

        public String getEffectDescription(float level) {
            return null;
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

