/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class GunneryImplants {
    public static float RECOIL_BONUS = 25.0f;
    public static float TARGET_LEADING_BONUS = 100.0f;
    public static float RANGE_BONUS = 15.0f;
    public static float RANGE_BONUS_ELITE = 5.0f;
    public static float EW_FRIGATES = 4.0f;
    public static float EW_DESTROYERS = 2.0f;
    public static float EW_OTHER = 1.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxRecoilMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
            stats.getRecoilPerShotMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
            stats.getRecoilDecayMult().modifyMult(id, 1.0f - 0.01f * RECOIL_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxRecoilMult().unmodify(id);
            stats.getRecoilPerShotMult().unmodify(id);
            stats.getRecoilDecayMult().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "-" + (int)RECOIL_BONUS + "% \u6b66\u5668\u540e\u5750\u529b";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level1A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float bonus = 0.0f;
            if (hullSize == ShipAPI.HullSize.FRIGATE) {
                bonus = EW_FRIGATES;
            }
            if (hullSize == ShipAPI.HullSize.DESTROYER) {
                bonus = EW_DESTROYERS;
            }
            if (hullSize == ShipAPI.HullSize.CRUISER || hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
                bonus = EW_OTHER;
            }
            if (bonus > 0.0f) {
                stats.getDynamic().getMod("electronic_warfare_flat").modifyFlat(id, bonus);
            }
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("electronic_warfare_flat").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)EW_FRIGATES + "% \u7535\u5b50\u6218\u5f3a\u5ea6* (\u5f53\u65d7\u8230\u662f\u62a4\u536b\u8230\u65f6)\uff0c" + "+" + (int)EW_DESTROYERS + "% \u7535\u5b50\u6218\u5f3a\u5ea6 (\u5f53\u65d7\u8230\u662f\u9a71\u9010\u8230\u65f6)\uff0c" + "+" + (int)EW_OTHER + "% \u7535\u5b50\u6218\u5f3a\u5ea6 (\u5f53\u65d7\u8230\u4e3a\u5de1\u6d0b\u6216\u4e3b\u529b\u8230\u65f6) ";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getAutofireAimAccuracy().modifyFlat(id, TARGET_LEADING_BONUS * 0.01f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAutofireAimAccuracy().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)TARGET_LEADING_BONUS + "% \u81ea\u52a8\u5f00\u706b\u6b66\u5668\u7cbe\u5ea6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
            stats.getEnergyWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponRangeBonus().unmodify(id);
            stats.getEnergyWeaponRangeBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)RANGE_BONUS + "% \u5b9e\u5f39\u4e0e\u80fd\u91cf\u6b66\u5668\u5c04\u7a0b";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3A
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, RANGE_BONUS_ELITE);
            stats.getEnergyWeaponRangeBonus().modifyPercent(id, RANGE_BONUS_ELITE);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getBallisticWeaponRangeBonus().unmodify(id);
            stats.getEnergyWeaponRangeBonus().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)RANGE_BONUS_ELITE + "% \u5b9e\u5f39\u4e0e\u80fd\u91cf\u6b66\u5668\u5c04\u7a0b";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

