/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class Helmsmanship {
    public static float MANEUVERABILITY_BONUS = 50.0f;
    public static float SPEED_BONUS = 15.0f;
    public static float ELITE_SPEED_BONUS_FLAT = 10.0f;
    public static float ZERO_FLUX_LEVEL = 1.0f;

    public static class Level1
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getAcceleration().modifyPercent(id, MANEUVERABILITY_BONUS);
            stats.getDeceleration().modifyPercent(id, MANEUVERABILITY_BONUS);
            stats.getTurnAcceleration().modifyPercent(id, MANEUVERABILITY_BONUS * 2.0f);
            stats.getMaxTurnRate().modifyPercent(id, MANEUVERABILITY_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)MANEUVERABILITY_BONUS + "% \u673a\u52a8\u6027";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxSpeed().modifyPercent(id, SPEED_BONUS);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxSpeed().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)SPEED_BONUS + "% \u6700\u9ad8\u822a\u901f";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getAllowZeroFluxAtAnyLevel().modifyFlat(id, 1.0f);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getAllowZeroFluxAtAnyLevel().unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "\u82e5\u8230\u8239\u505c\u6b62\u4ea7\u751f\u5e45\u80fd\uff0c\u4e14\u672a\u5904\u4e8e\u5f3a\u5236\u6392\u5e45\u6216\u8fc7\u8f7d\u72b6\u6001\uff0c\u5373\u53ef\u5728\u4efb\u4f55\u5e45\u80fd\u6c34\u5e73\u4e0b\u4eab\u53d7 \"\u96f6\u5e45\u80fd\u52a0\u901f\" \u6548\u679c";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxSpeed().modifyFlat(id, ELITE_SPEED_BONUS_FLAT);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxSpeed().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)ELITE_SPEED_BONUS_FLAT + " \u6700\u9ad8\u822a\u901f";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

