/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.campaign.skills.FieldRepairsScript;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class HullRestoration {
    public static float RECOVERY_PROB = 2.0f;
    public static float CR_PER_SMOD = 5.0f;
    public static float CR_MAX_BONUS = 15.0f;
    public static float CR_MINUS_PER_DMOD = 5.0f;
    public static float DMOD_AVOID_MAX = 0.9f;
    public static float DMOD_AVOID_MIN = 0.75f;
    public static float DMOD_AVOID_MIN_DP = 5.0f;
    public static float DP_REDUCTION = 0.1f;
    public static float DP_REDUCTION_MAX = 5.0f;
    public static float DMOD_AVOID_MAX_DP = 60.0f;

    public static class Level1
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_recovery_mod").modifyFlat(id, RECOVERY_PROB);
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_recovery_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u5982\u679c\u4f60\u7684\u8230\u8239\u5728\u6218\u6597\u4e2d\u88ab\u51fb\u6c89\uff0c\u5c06\u51e0\u4e4e\u603b\u662f\u53ef\u5728\u6218\u540e\u88ab\u6253\u635e\u5e76\u4fee\u590d\u3002";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float mult;
            float dp = DMOD_AVOID_MIN_DP;
            if (stats.getFleetMember() != null) {
                dp = stats.getFleetMember().getDeploymentPointsCost();
            }
            if ((mult = 1.0f - (dp - DMOD_AVOID_MIN_DP) / (DMOD_AVOID_MAX_DP - DMOD_AVOID_MIN_DP)) > 1.0f) {
                mult = 1.0f;
            }
            if (mult < 0.0f) {
                mult = 0.0f;
            }
            float probAvoid = DMOD_AVOID_MIN + (DMOD_AVOID_MAX - DMOD_AVOID_MIN) * mult;
            stats.getDynamic().getMod("dmod_acquire_prob_mod").modifyMult(id, 1.0f - probAvoid);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("dmod_acquire_prob_mod").unmodify(id);
        }

        public String getEffectDescription(float level) {
            String lowDP = "" + (int)DMOD_AVOID_MIN_DP;
            String highDP = "" + (int)DMOD_AVOID_MAX_DP;
            String lowChance = Math.round(DMOD_AVOID_MIN * 100.0f) + "%";
            String highChance = Math.round(DMOD_AVOID_MAX * 100.0f) + "%";
            return "\u56e0\u6218\u6597\u800c\u88ab\u51fb\u6c89\u7684\u8230\u8239\u5c06\u6709 " + lowChance + " (\u90e8\u7f72\u70b9\u5927\u4e8e\u7b49\u4e8e " + highDP + " \u7684\u8230\u8239) \u81f3 " + highChance + " (\u90e8\u7f72\u70b9\u5c0f\u4e8e\u7b49\u4e8e " + lowDP + " \u7684\u8230\u8239) \u7684\u6982\u7387\u907f\u514d D-\u63d2\u4ef6 \u7684\u4ea7\u751f";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            float num = 0.0f;
            if (stats.getVariant() != null) {
                num = stats.getVariant().getSMods().size();
            }
            stats.getMaxCombatReadiness().modifyFlat(id, num * CR_PER_SMOD * 0.01f, "\u8239\u4f53\u4fee\u590d");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "\u8230\u8239\u4e0a\u6bcf\u62e5\u6709\u4e00\u4e2a S-\u63d2\u4ef6 \u5c31 +" + (int)CR_PER_SMOD + "% \u7684\u6218\u5907\u503c (CR) \u4e0a\u9650";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3B
    implements ShipSkillEffect {
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            FleetMemberAPI member = stats.getFleetMember();
            float dmods = 0.0f;
            if (member != null) {
                dmods = DModManager.getNumDMods(member.getVariant());
            } else if (stats.getVariant() != null) {
                dmods = DModManager.getNumDMods(stats.getVariant());
            }
            float bonus = CR_MAX_BONUS - dmods * CR_MINUS_PER_DMOD;
            bonus = Math.round(bonus);
            if (bonus < 0.0f) {
                bonus = 0.0f;
            }
            stats.getMaxCombatReadiness().modifyFlat(id, bonus * 0.01f, "\u8239\u4f53\u4fee\u590d");
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        public String getEffectDescription(float level) {
            return "+" + (int)CR_MAX_BONUS + "% \u5168\u8230\u8239\u6218\u5907\u503c (CR) \u4e0a\u9650\uff0c\u4f46\u8230\u8239\u7684\u6bcf\u4e00\u4e2a D-\u63d2\u4ef6 \u5c06\u4f7f\u672c\u589e\u76ca\u964d\u4f4e " + (int)CR_MINUS_PER_DMOD + "% (\u6700\u4f4e\u964d\u81f3 0%)";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4A
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
        }

        public String getEffectDescription(float level) {
            if (FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL == 1) {
                return "\u6bcf\u4e00\u4e2a\u6708\uff0c\u5c31\u6709\u51e0\u7387\u4ece\u968f\u673a\u4e00\u8258\u8239\u4e0a\u79fb\u9664\u4e00\u4e2a D-\u63d2\u4ef6\uff0c\u4f4e\u90e8\u7f72\u70b9\u8230\u8239\u5c06\u8017\u8d39\u66f4\u5c11\u7684\u65f6\u95f4";
            }
            if (FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL == 2) {
                return "\u6bcf\u4e24\u4e2a\u6708\uff0c\u5c31\u6709\u51e0\u7387\u4ece\u968f\u673a\u4e00\u8258\u8239\u4e0a\u79fb\u9664\u4e00\u4e2a D-\u63d2\u4ef6";
            }
            return "\u6bcf " + FieldRepairsScript.MONTHS_PER_DMOD_REMOVAL + " \u4e2a\u6708\uff0c\u5c31\u6709\u51e0\u7387\u4ece\u968f\u673a\u4e00\u8258\u8239\u4e0a\u79fb\u9664\u4e00\u4e2a D-\u63d2\u4ef6";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level4B
    implements FleetStatsSkillEffect {
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
        }

        public void unapply(MutableFleetStatsAPI stats, String id) {
        }

        public String getEffectDescription(float level) {
            return "\u83b7\u5f97\u65b0\u8239\u65f6\uff0c\u6709\u51e0\u7387\u7acb\u523b\u79fb\u9664\u4e00\u4e2a D-\u63d2\u4ef6\uff0c\u5176 D-\u63d2\u4ef6 \u8d8a\u591a\u6982\u7387\u4e5f\u5c31\u8d8a\u9ad8";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level5
    extends BaseSkillEffectDescription
    implements ShipSkillEffect {
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u65e0 D-\u63d2\u4ef6 \u6216\u53ea\u6709 1 \u4e2a D-\u63d2\u4ef6 \u7684\u8230\u8239");
            info.addSpacer(opad);
            String max = "" + (int)DP_REDUCTION_MAX;
            String percent = Math.round(DP_REDUCTION * 100.0f) + "%";
            info.addPara("\u90e8\u7f72\u70b9 -%s \u6216 %s \u70b9\uff0c\u6309\u4e24\u8005\u4e2d\u8f83\u4f4e\u8005\u8ba1\u7b97", 0.0f, Misc.getHighlightColor(), Misc.getHighlightColor(), percent, max);
        }

        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            FleetMemberAPI member = stats.getFleetMember();
            float dmods = 0.0f;
            if (member != null) {
                dmods = DModManager.getNumDMods(member.getVariant());
            }
            if (dmods > 1.0f) {
                return;
            }
            float baseCost = stats.getSuppliesToRecover().getBaseValue();
            float reduction = Math.min(DP_REDUCTION_MAX, baseCost * DP_REDUCTION);
            stats.getDynamic().getMod("deployment_points_mod").modifyFlat(id, -reduction);
        }

        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("deployment_points_mod").unmodifyFlat(id);
        }
    }
}

