/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class IndustrialPlanning {
    public static int SUPPLY_BONUS = 1;
    public static float CUSTOM_PRODUCTION_BONUS = 50.0f;

    public static class Level1
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("supply_bonus").modifyFlat(id, SUPPLY_BONUS);
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("supply_bonus").unmodifyFlat(id);
        }

        public String getEffectDescription(float level) {
            return "\u6240\u6709\u5de5\u4e1a\u8bbe\u65bd\u7684\u6210\u54c1\u4ea7\u91cf\u5747 +" + SUPPLY_BONUS + " \u5355\u4f4d";
        }

        public String getEffectPerLevelDescription() {
            return null;
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.GOVERNED_OUTPOST;
        }
    }

    public static class Level2
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("custom_production_mod").modifyMult(id, 1.0f + CUSTOM_PRODUCTION_BONUS / 100.0f, "\u5de5\u4e1a\u89c4\u5212");
        }

        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("custom_production_mod").unmodifyMult(id);
        }

        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("\u5f71\u54cd\uff1a %s", opad + 5.0f, Misc.getGrayColor(), c, "\u6240\u6709\u6b96\u6c11\u5730");
            info.addSpacer(opad);
            info.addPara("+%s \u751f\u4ea7\u8230\u8239\u4e0e\u6b66\u5668\u65f6\u7684\u6700\u5927\u4ea7\u80fd", 0.0f, this.hc, this.hc, (int)CUSTOM_PRODUCTION_BONUS + "%");
        }

        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_OUTPOSTS;
        }
    }
}

